/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.analyze.user.Privilege;
import io.crate.auth.user.User;
import io.crate.metadata.CustomMetadataUpgrader;
import io.crate.metadata.UsersMetadata;
import io.crate.metadata.UsersPrivilegesMetadata;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.settings.Settings;

public class PrivilegesMetadataUpgrader
implements CustomMetadataUpgrader {
    public Map<String, Metadata.Custom> apply(Settings settings, Map<String, Metadata.Custom> customMetadata) {
        UsersMetadata usersMetadata = (UsersMetadata)customMetadata.get("users");
        if (usersMetadata == null) {
            return customMetadata;
        }
        List<String> users = usersMetadata.userNames();
        if (users.size() == 0) {
            return customMetadata;
        }
        UsersPrivilegesMetadata privilegesMetadata = (UsersPrivilegesMetadata)customMetadata.get("users_privileges");
        if (privilegesMetadata == null) {
            privilegesMetadata = new UsersPrivilegesMetadata();
            customMetadata.put("users_privileges", privilegesMetadata);
        }
        for (String userName : usersMetadata.userNames()) {
            Set<Privilege> userPrivileges = privilegesMetadata.getUserPrivileges(userName);
            if (userPrivileges != null) continue;
            userPrivileges = new HashSet<Privilege>();
            privilegesMetadata.createPrivileges(userName, userPrivileges);
            for (Privilege.Type privilegeType : Privilege.Type.values()) {
                userPrivileges.add(new Privilege(Privilege.State.GRANT, privilegeType, Privilege.Clazz.CLUSTER, null, User.CRATE_USER.name()));
            }
        }
        return customMetadata;
    }
}

