/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth.user;

import com.google.common.collect.ImmutableSet;
import io.crate.action.FutureActionListener;
import io.crate.action.sql.SessionContext;
import io.crate.analyze.user.Privilege;
import io.crate.auth.user.AccessControl;
import io.crate.auth.user.AccessControlImpl;
import io.crate.auth.user.AlterUserRequest;
import io.crate.auth.user.CreateUserRequest;
import io.crate.auth.user.DropUserRequest;
import io.crate.auth.user.PrivilegesRequest;
import io.crate.auth.user.TransportAlterUserAction;
import io.crate.auth.user.TransportCreateUserAction;
import io.crate.auth.user.TransportDropUserAction;
import io.crate.auth.user.TransportPrivilegesAction;
import io.crate.auth.user.User;
import io.crate.auth.user.UserLookup;
import io.crate.auth.user.UserManager;
import io.crate.auth.user.UserManagerDDLModifier;
import io.crate.exceptions.UserAlreadyExistsException;
import io.crate.exceptions.UserUnknownException;
import io.crate.execution.engine.collect.sources.SysTableRegistry;
import io.crate.metadata.SystemTable;
import io.crate.metadata.UsersMetadata;
import io.crate.metadata.UsersPrivilegesMetadata;
import io.crate.metadata.cluster.DDLClusterStateModifier;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.metadata.sys.SysPrivilegesTableInfo;
import io.crate.metadata.sys.SysUsersTableInfo;
import io.crate.user.SecureHash;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.transport.TransportRequest;

@Singleton
public class UserManagerService
implements UserManager,
ClusterStateListener {
    private static final Consumer<User> ENSURE_DROP_USER_NOT_SUPERUSER = user -> {
        if (user != null && user.isSuperUser()) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot drop a superuser '%s'", user.name()));
        }
    };
    private static final Consumer<User> ENSURE_PRIVILEGE_USER_NOT_SUPERUSER = user -> {
        if (user != null && user.isSuperUser()) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot alter privileges for superuser '%s'", user.name()));
        }
    };
    private static final UserManagerDDLModifier DDL_MODIFIER = new UserManagerDDLModifier();
    private final TransportCreateUserAction transportCreateUserAction;
    private final TransportDropUserAction transportDropUserAction;
    private final TransportAlterUserAction transportAlterUserAction;
    private final TransportPrivilegesAction transportPrivilegesAction;
    private volatile Set<User> users = ImmutableSet.of((Object)User.CRATE_USER);

    @Inject
    public UserManagerService(TransportCreateUserAction transportCreateUserAction, TransportDropUserAction transportDropUserAction, TransportAlterUserAction transportAlterUserAction, TransportPrivilegesAction transportPrivilegesAction, SysTableRegistry sysTableRegistry, ClusterService clusterService, DDLClusterStateService ddlClusterStateService) {
        this.transportCreateUserAction = transportCreateUserAction;
        this.transportDropUserAction = transportDropUserAction;
        this.transportAlterUserAction = transportAlterUserAction;
        this.transportPrivilegesAction = transportPrivilegesAction;
        clusterService.addListener((ClusterStateListener)this);
        SystemTable<User> userTable = SysUsersTableInfo.create();
        sysTableRegistry.registerSysTable(userTable, () -> CompletableFuture.completedFuture(this.users()), userTable.expressions(), false);
        SystemTable<SysPrivilegesTableInfo.PrivilegeRow> privilegesTable = SysPrivilegesTableInfo.create();
        sysTableRegistry.registerSysTable(privilegesTable, () -> CompletableFuture.completedFuture(SysPrivilegesTableInfo.buildPrivilegesRows(this.users())), privilegesTable.expressions(), false);
        ddlClusterStateService.addModifier((DDLClusterStateModifier)DDL_MODIFIER);
    }

    static Set<User> getUsers(@Nullable UsersMetadata metadata, @Nullable UsersPrivilegesMetadata privilegesMetadata) {
        ImmutableSet.Builder usersBuilder = new ImmutableSet.Builder().add((Object)User.CRATE_USER);
        if (metadata != null) {
            for (Map.Entry<String, SecureHash> user : metadata.users().entrySet()) {
                String userName = user.getKey();
                SecureHash password = user.getValue();
                Set<Privilege> privileges = null;
                if (privilegesMetadata != null) {
                    privileges = privilegesMetadata.getUserPrivileges(userName);
                }
                usersBuilder.add((Object)User.of((String)userName, privileges, (SecureHash)password));
            }
        }
        return usersBuilder.build();
    }

    public CompletableFuture<Long> createUser(String userName, @Nullable SecureHash hashedPw) {
        FutureActionListener listener = new FutureActionListener(r -> {
            if (r.doesUserExist()) {
                throw new UserAlreadyExistsException(userName);
            }
            return 1L;
        });
        this.transportCreateUserAction.execute((TransportRequest)new CreateUserRequest(userName, hashedPw), (ActionListener)listener);
        return listener;
    }

    public CompletableFuture<Long> dropUser(String userName, boolean suppressNotFoundError) {
        ENSURE_DROP_USER_NOT_SUPERUSER.accept(this.findUser(userName));
        FutureActionListener listener = new FutureActionListener(r -> {
            if (!r.doesUserExist()) {
                if (suppressNotFoundError) {
                    return 0L;
                }
                throw new UserUnknownException(userName);
            }
            return 1L;
        });
        this.transportDropUserAction.execute((TransportRequest)new DropUserRequest(userName, suppressNotFoundError), (ActionListener)listener);
        return listener;
    }

    public CompletableFuture<Long> alterUser(String userName, @Nullable SecureHash newHashedPw) {
        FutureActionListener listener = new FutureActionListener(r -> {
            if (!r.doesUserExist()) {
                throw new UserUnknownException(userName);
            }
            return 1L;
        });
        this.transportAlterUserAction.execute((TransportRequest)new AlterUserRequest(userName, newHashedPw), (ActionListener)listener);
        return listener;
    }

    public CompletableFuture<Long> applyPrivileges(Collection<String> userNames, Collection<Privilege> privileges) {
        userNames.forEach(s -> ENSURE_PRIVILEGE_USER_NOT_SUPERUSER.accept(this.findUser((String)s)));
        FutureActionListener listener = new FutureActionListener(r -> {
            if (!r.unknownUserNames().isEmpty()) {
                throw new UserUnknownException(r.unknownUserNames());
            }
            return r.affectedRows();
        });
        this.transportPrivilegesAction.execute((TransportRequest)new PrivilegesRequest(userNames, privileges), (ActionListener)listener);
        return listener;
    }

    public Iterable<User> users() {
        return this.users;
    }

    public AccessControl getAccessControl(SessionContext sessionContext) {
        return new AccessControlImpl((UserLookup)this, sessionContext);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        Metadata prevMetadata = event.previousState().metadata();
        Metadata newMetadata = event.state().metadata();
        UsersMetadata prevUsers = (UsersMetadata)prevMetadata.custom("users");
        UsersMetadata newUsers = (UsersMetadata)newMetadata.custom("users");
        UsersPrivilegesMetadata prevUsersPrivileges = (UsersPrivilegesMetadata)prevMetadata.custom("users_privileges");
        UsersPrivilegesMetadata newUsersPrivileges = (UsersPrivilegesMetadata)newMetadata.custom("users_privileges");
        if (prevUsers != newUsers || prevUsersPrivileges != newUsersPrivileges) {
            this.users = UserManagerService.getUsers(newUsers, newUsersPrivileges);
        }
    }

    @Nullable
    public User findUser(String userName) {
        for (User user : this.users()) {
            if (!userName.equals(user.name())) continue;
            return user;
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }
}

