/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth.user;

import io.crate.metadata.RelationName;
import io.crate.metadata.UsersPrivilegesMetadata;
import io.crate.metadata.cluster.DDLClusterStateModifier;
import java.util.List;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;

public class UserManagerDDLModifier
implements DDLClusterStateModifier {
    public ClusterState onDropTable(ClusterState currentState, RelationName relationName) {
        return this.dropPrivilegesForTableOrView(currentState, relationName);
    }

    public ClusterState onDropView(ClusterState currentState, List<RelationName> relationNames) {
        for (RelationName relationName : relationNames) {
            currentState = this.dropPrivilegesForTableOrView(currentState, relationName);
        }
        return currentState;
    }

    public ClusterState onRenameTable(ClusterState currentState, RelationName sourceRelationName, RelationName targetRelationName, boolean isPartitionedTable) {
        Metadata currentMetadata = currentState.metadata();
        Metadata.Builder mdBuilder = Metadata.builder((Metadata)currentMetadata);
        if (UserManagerDDLModifier.transferTablePrivileges(mdBuilder, sourceRelationName, targetRelationName)) {
            return ClusterState.builder((ClusterState)currentState).metadata(mdBuilder).build();
        }
        return currentState;
    }

    public ClusterState onSwapRelations(ClusterState currentState, RelationName source, RelationName target) {
        Metadata currentMetadata = currentState.metadata();
        UsersPrivilegesMetadata userPrivileges = (UsersPrivilegesMetadata)currentMetadata.custom("users_privileges");
        if (userPrivileges == null) {
            return currentState;
        }
        UsersPrivilegesMetadata updatedPrivileges = UsersPrivilegesMetadata.swapPrivileges(userPrivileges, source, target);
        return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentMetadata).putCustom("users_privileges", (Metadata.Custom)updatedPrivileges).build()).build();
    }

    private ClusterState dropPrivilegesForTableOrView(ClusterState currentState, RelationName relationName) {
        Metadata currentMetadata = currentState.metadata();
        Metadata.Builder mdBuilder = Metadata.builder((Metadata)currentMetadata);
        if (!UserManagerDDLModifier.dropPrivileges(mdBuilder, relationName)) {
            return currentState;
        }
        return ClusterState.builder((ClusterState)currentState).metadata(mdBuilder).build();
    }

    private static boolean dropPrivileges(Metadata.Builder mdBuilder, RelationName relationName) {
        UsersPrivilegesMetadata newMetadata = UsersPrivilegesMetadata.copyOf((UsersPrivilegesMetadata)mdBuilder.getCustom("users_privileges"));
        long affectedRows = newMetadata.dropTableOrViewPrivileges(relationName.fqn());
        mdBuilder.putCustom("users_privileges", (Metadata.Custom)newMetadata);
        return affectedRows > 0L;
    }

    private static boolean transferTablePrivileges(Metadata.Builder mdBuilder, RelationName sourceRelationName, RelationName targetRelationName) {
        UsersPrivilegesMetadata oldMetadata = (UsersPrivilegesMetadata)mdBuilder.getCustom("users_privileges");
        if (oldMetadata == null) {
            return false;
        }
        UsersPrivilegesMetadata newMetadata = UsersPrivilegesMetadata.maybeCopyAndReplaceTableIdents(oldMetadata, sourceRelationName.fqn(), targetRelationName.fqn());
        if (newMetadata != null) {
            mdBuilder.putCustom("users_privileges", (Metadata.Custom)newMetadata);
            return true;
        }
        return false;
    }
}

