/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth.user;

import com.google.common.annotations.VisibleForTesting;
import io.crate.auth.user.PrivilegesRequest;
import io.crate.auth.user.PrivilegesResponse;
import io.crate.metadata.UsersMetadata;
import io.crate.metadata.UsersPrivilegesMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportPrivilegesAction
extends TransportMasterNodeAction<PrivilegesRequest, PrivilegesResponse> {
    private static final String ACTION_NAME = "internal:crate:sql/privileges/grant";

    @Inject
    public TransportPrivilegesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(ACTION_NAME, transportService, clusterService, threadPool, PrivilegesRequest::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected PrivilegesResponse read(StreamInput in) throws IOException {
        return new PrivilegesResponse(in);
    }

    protected ClusterBlockException checkBlock(PrivilegesRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(Task task, final PrivilegesRequest request, ClusterState state, ActionListener<PrivilegesResponse> listener) throws Exception {
        this.clusterService.submitStateUpdateTask("grant_privileges", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<PrivilegesResponse>(Priority.IMMEDIATE, (AckedRequest)request, listener){
            long affectedRows;
            List<String> unknownUserNames;
            {
                super(arg0, arg1, arg2);
                this.affectedRows = -1L;
                this.unknownUserNames = null;
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                Metadata currentMetadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder((Metadata)currentMetadata);
                this.unknownUserNames = TransportPrivilegesAction.validateUserNames(currentMetadata, request.userNames());
                if (this.unknownUserNames.isEmpty()) {
                    this.affectedRows = TransportPrivilegesAction.applyPrivileges(mdBuilder, request);
                }
                return ClusterState.builder((ClusterState)currentState).metadata(mdBuilder).build();
            }

            protected PrivilegesResponse newResponse(boolean acknowledged) {
                return new PrivilegesResponse(acknowledged, this.affectedRows, this.unknownUserNames);
            }
        });
    }

    @VisibleForTesting
    static List<String> validateUserNames(Metadata metadata, Collection<String> userNames) {
        UsersMetadata usersMetadata = (UsersMetadata)metadata.custom("users");
        if (usersMetadata == null) {
            return new ArrayList<String>(userNames);
        }
        ArrayList<String> unknownUserNames = null;
        for (String userName : userNames) {
            if (usersMetadata.userNames().contains(userName)) continue;
            if (unknownUserNames == null) {
                unknownUserNames = new ArrayList<String>();
            }
            unknownUserNames.add(userName);
        }
        if (unknownUserNames == null) {
            return Collections.emptyList();
        }
        return unknownUserNames;
    }

    @VisibleForTesting
    static long applyPrivileges(Metadata.Builder mdBuilder, PrivilegesRequest request) {
        UsersPrivilegesMetadata newMetadata = UsersPrivilegesMetadata.copyOf((UsersPrivilegesMetadata)mdBuilder.getCustom("users_privileges"));
        long affectedRows = newMetadata.applyPrivileges(request.userNames(), request.privileges());
        mdBuilder.putCustom("users_privileges", (Metadata.Custom)newMetadata);
        return affectedRows;
    }
}

