/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth.user;

import com.google.common.annotations.VisibleForTesting;
import io.crate.auth.user.DropUserRequest;
import io.crate.auth.user.WriteUserResponse;
import io.crate.metadata.UsersMetadata;
import io.crate.metadata.UsersPrivilegesMetadata;
import java.io.IOException;
import javax.annotation.Nullable;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDropUserAction
extends TransportMasterNodeAction<DropUserRequest, WriteUserResponse> {
    @Inject
    public TransportDropUserAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("internal:crate:sql/user/drop", transportService, clusterService, threadPool, DropUserRequest::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "generic";
    }

    protected WriteUserResponse read(StreamInput in) throws IOException {
        return new WriteUserResponse(in);
    }

    protected void masterOperation(Task task, final DropUserRequest request, ClusterState state, ActionListener<WriteUserResponse> listener) throws Exception {
        this.clusterService.submitStateUpdateTask("drop_user [" + request.userName() + "]", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<WriteUserResponse>(Priority.URGENT, (AckedRequest)request, listener){
            private boolean alreadyExists;
            {
                super(arg0, arg1, arg2);
                this.alreadyExists = true;
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                Metadata currentMetadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder((Metadata)currentMetadata);
                this.alreadyExists = TransportDropUserAction.dropUser(mdBuilder, (UsersMetadata)currentMetadata.custom("users"), request.userName());
                return ClusterState.builder((ClusterState)currentState).metadata(mdBuilder).build();
            }

            protected WriteUserResponse newResponse(boolean acknowledged) {
                return new WriteUserResponse(acknowledged, this.alreadyExists);
            }
        });
    }

    protected ClusterBlockException checkBlock(DropUserRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @VisibleForTesting
    static boolean dropUser(Metadata.Builder mdBuilder, @Nullable UsersMetadata oldMetadata, String name) {
        if (oldMetadata == null || !oldMetadata.contains(name)) {
            return false;
        }
        UsersMetadata newMetadata = UsersMetadata.newInstance(oldMetadata);
        newMetadata.remove(name);
        assert (!newMetadata.equals((Object)oldMetadata)) : "must not be equal to guarantee the cluster change action";
        mdBuilder.putCustom("users", (Metadata.Custom)newMetadata);
        UsersPrivilegesMetadata privilegesMetadata = UsersPrivilegesMetadata.copyOf((UsersPrivilegesMetadata)mdBuilder.getCustom("users_privileges"));
        privilegesMetadata.dropPrivileges(name);
        mdBuilder.putCustom("users_privileges", (Metadata.Custom)privilegesMetadata);
        return true;
    }
}

