/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth.user;

import com.google.common.annotations.VisibleForTesting;
import io.crate.auth.user.CreateUserRequest;
import io.crate.auth.user.WriteUserResponse;
import io.crate.metadata.UsersMetadata;
import io.crate.metadata.UsersPrivilegesMetadata;
import io.crate.user.SecureHash;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.Nullable;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportCreateUserAction
extends TransportMasterNodeAction<CreateUserRequest, WriteUserResponse> {
    @Inject
    public TransportCreateUserAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("internal:crate:sql/user/create", transportService, clusterService, threadPool, CreateUserRequest::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "generic";
    }

    protected WriteUserResponse read(StreamInput in) throws IOException {
        return new WriteUserResponse(in);
    }

    protected void masterOperation(Task task, final CreateUserRequest request, ClusterState state, ActionListener<WriteUserResponse> listener) throws Exception {
        this.clusterService.submitStateUpdateTask("create_user [" + request.userName() + "]", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<WriteUserResponse>(Priority.URGENT, (AckedRequest)request, listener){
            private boolean alreadyExists;
            {
                super(arg0, arg1, arg2);
                this.alreadyExists = false;
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                Metadata currentMetadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder((Metadata)currentMetadata);
                this.alreadyExists = TransportCreateUserAction.putUser(mdBuilder, request.userName(), request.secureHash());
                return ClusterState.builder((ClusterState)currentState).metadata(mdBuilder).build();
            }

            protected WriteUserResponse newResponse(boolean acknowledged) {
                return new WriteUserResponse(acknowledged, this.alreadyExists);
            }
        });
    }

    protected ClusterBlockException checkBlock(CreateUserRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @VisibleForTesting
    static boolean putUser(Metadata.Builder mdBuilder, String name, @Nullable SecureHash secureHash) {
        UsersMetadata oldMetadata = (UsersMetadata)mdBuilder.getCustom("users");
        if (oldMetadata != null && oldMetadata.contains(name)) {
            return true;
        }
        UsersMetadata newMetadata = UsersMetadata.newInstance(oldMetadata);
        newMetadata.put(name, secureHash);
        assert (!newMetadata.equals((Object)oldMetadata)) : "must not be equal to guarantee the cluster change action";
        mdBuilder.putCustom("users", (Metadata.Custom)newMetadata);
        UsersPrivilegesMetadata privilegesMetadata = UsersPrivilegesMetadata.copyOf((UsersPrivilegesMetadata)mdBuilder.getCustom("users_privileges"));
        privilegesMetadata.createPrivileges(name, Collections.emptySet());
        mdBuilder.putCustom("users_privileges", (Metadata.Custom)privilegesMetadata);
        return false;
    }
}

