/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth.user;

import com.google.common.annotations.VisibleForTesting;
import io.crate.auth.user.AlterUserRequest;
import io.crate.auth.user.WriteUserResponse;
import io.crate.metadata.UsersMetadata;
import io.crate.user.SecureHash;
import java.io.IOException;
import javax.annotation.Nullable;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportAlterUserAction
extends TransportMasterNodeAction<AlterUserRequest, WriteUserResponse> {
    @Inject
    public TransportAlterUserAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("internal:crate:sql/user/alter", transportService, clusterService, threadPool, AlterUserRequest::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected WriteUserResponse read(StreamInput in) throws IOException {
        return new WriteUserResponse(in);
    }

    protected void masterOperation(Task task, final AlterUserRequest request, ClusterState state, ActionListener<WriteUserResponse> listener) {
        this.clusterService.submitStateUpdateTask("alter_user [" + request.userName() + "]", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<WriteUserResponse>(Priority.URGENT, (AckedRequest)request, listener){
            private boolean userExists;
            {
                super(arg0, arg1, arg2);
                this.userExists = true;
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                Metadata currentMetadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder((Metadata)currentMetadata);
                this.userExists = TransportAlterUserAction.alterUser(mdBuilder, request.userName(), request.secureHash());
                return ClusterState.builder((ClusterState)currentState).metadata(mdBuilder).build();
            }

            protected WriteUserResponse newResponse(boolean acknowledged) {
                return new WriteUserResponse(acknowledged, this.userExists);
            }
        });
    }

    @VisibleForTesting
    static boolean alterUser(Metadata.Builder mdBuilder, String userName, @Nullable SecureHash secureHash) {
        UsersMetadata oldMetadata = (UsersMetadata)mdBuilder.getCustom("users");
        if (oldMetadata == null || !oldMetadata.contains(userName)) {
            return false;
        }
        UsersMetadata newMetadata = UsersMetadata.newInstance(oldMetadata);
        newMetadata.put(userName, secureHash);
        assert (!newMetadata.equals((Object)oldMetadata)) : "must not be equal to guarantee the cluster change action";
        mdBuilder.putCustom("users", (Metadata.Custom)newMetadata);
        return true;
    }

    protected ClusterBlockException checkBlock(AlterUserRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

