/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth.user;

import io.crate.analyze.user.Privilege;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class PrivilegesRequest
extends AcknowledgedRequest<PrivilegesRequest> {
    private final Collection<String> userNames;
    private final Collection<Privilege> privileges;

    PrivilegesRequest(Collection<String> userNames, Collection<Privilege> privileges) {
        this.userNames = userNames;
        this.privileges = privileges;
    }

    Collection<String> userNames() {
        return this.userNames;
    }

    public Collection<Privilege> privileges() {
        return this.privileges;
    }

    public PrivilegesRequest(StreamInput in) throws IOException {
        super(in);
        int userNamesSize = in.readVInt();
        this.userNames = new ArrayList<String>(userNamesSize);
        for (int i = 0; i < userNamesSize; ++i) {
            this.userNames.add(in.readString());
        }
        int privilegesSize = in.readVInt();
        this.privileges = new ArrayList<Privilege>(privilegesSize);
        for (int i = 0; i < privilegesSize; ++i) {
            this.privileges.add(new Privilege(in));
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.userNames.size());
        for (String userName : this.userNames) {
            out.writeString(userName);
        }
        out.writeVInt(this.privileges.size());
        for (Privilege privilege : this.privileges) {
            privilege.writeTo(out);
        }
    }
}

