/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth.user;

import com.google.common.annotations.VisibleForTesting;
import io.crate.analyze.user.Privilege;
import io.crate.auth.user.User;
import io.crate.exceptions.MissingPrivilegeException;
import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.SchemaUnknownException;
import io.crate.metadata.IndexParts;
import io.crate.metadata.RelationName;
import javax.annotation.Nullable;

class Privileges {
    Privileges() {
    }

    static void ensureUserHasPrivilege(Privilege.Type type, Privilege.Clazz clazz, @Nullable String ident, User user, String defaultSchema) throws MissingPrivilegeException {
        assert (user != null) : "User must not be null when trying to validate privileges";
        assert (type != null) : "Privilege type must not be null";
        if (Privileges.isInformationSchema(clazz, ident)) {
            return;
        }
        if (!user.hasPrivilege(type, clazz, ident, defaultSchema)) {
            boolean objectIsVisibleToUser = user.hasAnyPrivilege(clazz, ident);
            if (objectIsVisibleToUser) {
                throw new MissingPrivilegeException(user.name(), type);
            }
            switch (clazz) {
                case CLUSTER: {
                    throw new MissingPrivilegeException(user.name(), type);
                }
                case SCHEMA: {
                    throw new SchemaUnknownException(ident);
                }
                case TABLE: 
                case VIEW: {
                    RelationName relationName = RelationName.fromIndexName((String)ident);
                    if (user.hasAnyPrivilege(Privilege.Clazz.SCHEMA, relationName.schema())) {
                        throw new RelationUnknown(relationName);
                    }
                    throw new SchemaUnknownException(relationName.schema());
                }
            }
            throw new AssertionError((Object)("Invalid clazz: " + clazz));
        }
    }

    @VisibleForTesting
    static void ensureUserHasPrivilege(Privilege.Clazz clazz, @Nullable String ident, User user) throws MissingPrivilegeException {
        assert (user != null) : "User must not be null when trying to validate privileges";
        if (Privileges.isInformationSchema(clazz, ident)) {
            return;
        }
        if (!user.hasAnyPrivilege(clazz, ident)) {
            switch (clazz) {
                case CLUSTER: {
                    throw new MissingPrivilegeException(user.name());
                }
                case SCHEMA: {
                    throw new SchemaUnknownException(ident);
                }
                case TABLE: 
                case VIEW: {
                    RelationName relationName = RelationName.fromIndexName((String)ident);
                    if (user.hasAnyPrivilege(Privilege.Clazz.SCHEMA, relationName.schema())) {
                        throw new RelationUnknown(relationName);
                    }
                    throw new SchemaUnknownException(relationName.schema());
                }
            }
            throw new AssertionError((Object)("Invalid clazz: " + clazz));
        }
    }

    private static boolean isInformationSchema(Privilege.Clazz clazz, @Nullable String ident) {
        if (Privilege.Clazz.CLUSTER.equals((Object)clazz)) {
            return false;
        }
        assert (ident != null) : "ident must not be null if privilege class is not 'CLUSTER'";
        String schemaName = Privilege.Clazz.TABLE.equals((Object)clazz) ? new IndexParts(ident).getSchema() : ident;
        return "information_schema".equals(schemaName);
    }
}

