/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth.user;

import io.crate.user.SecureHash;
import java.io.IOException;
import javax.annotation.Nullable;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class CreateUserRequest
extends AcknowledgedRequest<CreateUserRequest> {
    private final String userName;
    @Nullable
    private final SecureHash secureHash;

    public CreateUserRequest(String userName, @Nullable SecureHash attributes) {
        this.userName = userName;
        this.secureHash = attributes;
    }

    public String userName() {
        return this.userName;
    }

    @Nullable
    public SecureHash secureHash() {
        return this.secureHash;
    }

    public CreateUserRequest(StreamInput in) throws IOException {
        super(in);
        this.userName = in.readString();
        this.secureHash = (SecureHash)in.readOptionalWriteable(SecureHash::readFrom);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.userName);
        out.writeOptionalWriteable((Writeable)this.secureHash);
    }
}

