/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth.user;

import io.crate.action.sql.SessionContext;
import io.crate.analyze.AnalyzedAlterBlobTable;
import io.crate.analyze.AnalyzedAlterTable;
import io.crate.analyze.AnalyzedAlterTableAddColumn;
import io.crate.analyze.AnalyzedAlterTableDropCheckConstraint;
import io.crate.analyze.AnalyzedAlterTableOpenClose;
import io.crate.analyze.AnalyzedAlterTableRename;
import io.crate.analyze.AnalyzedAlterUser;
import io.crate.analyze.AnalyzedBegin;
import io.crate.analyze.AnalyzedCommit;
import io.crate.analyze.AnalyzedCopyFrom;
import io.crate.analyze.AnalyzedCopyTo;
import io.crate.analyze.AnalyzedCreateAnalyzer;
import io.crate.analyze.AnalyzedCreateBlobTable;
import io.crate.analyze.AnalyzedCreateFunction;
import io.crate.analyze.AnalyzedCreateRepository;
import io.crate.analyze.AnalyzedCreateSnapshot;
import io.crate.analyze.AnalyzedCreateTable;
import io.crate.analyze.AnalyzedCreateUser;
import io.crate.analyze.AnalyzedDeallocate;
import io.crate.analyze.AnalyzedDeleteStatement;
import io.crate.analyze.AnalyzedDiscard;
import io.crate.analyze.AnalyzedDropFunction;
import io.crate.analyze.AnalyzedDropRepository;
import io.crate.analyze.AnalyzedDropSnapshot;
import io.crate.analyze.AnalyzedDropTable;
import io.crate.analyze.AnalyzedDropUser;
import io.crate.analyze.AnalyzedDropView;
import io.crate.analyze.AnalyzedInsertStatement;
import io.crate.analyze.AnalyzedKill;
import io.crate.analyze.AnalyzedPrivileges;
import io.crate.analyze.AnalyzedRefreshTable;
import io.crate.analyze.AnalyzedResetStatement;
import io.crate.analyze.AnalyzedRestoreSnapshot;
import io.crate.analyze.AnalyzedSetSessionAuthorizationStatement;
import io.crate.analyze.AnalyzedSetStatement;
import io.crate.analyze.AnalyzedSetTransaction;
import io.crate.analyze.AnalyzedShowCreateTable;
import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.AnalyzedUpdateStatement;
import io.crate.analyze.CreateViewStmt;
import io.crate.analyze.ExplainAnalyzedStatement;
import io.crate.analyze.QueriedSelectRelation;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.analyze.relations.AnalyzedView;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.relations.TableFunctionRelation;
import io.crate.analyze.relations.TableRelation;
import io.crate.analyze.relations.UnionSelect;
import io.crate.analyze.user.Privilege;
import io.crate.auth.user.AccessControl;
import io.crate.auth.user.Privileges;
import io.crate.auth.user.User;
import io.crate.auth.user.UserLookup;
import io.crate.exceptions.ClusterScopeException;
import io.crate.exceptions.CrateException;
import io.crate.exceptions.CrateExceptionVisitor;
import io.crate.exceptions.MissingPrivilegeException;
import io.crate.exceptions.SchemaScopeException;
import io.crate.exceptions.TableScopeException;
import io.crate.exceptions.UnauthorizedException;
import io.crate.exceptions.UnscopedException;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.sql.tree.SetStatement;
import java.util.Locale;

public final class AccessControlImpl
implements AccessControl {
    private final User sessionUser;
    private final User authenticatedUser;
    private final UserLookup userLookup;
    private final SessionContext sessionContext;

    public AccessControlImpl(UserLookup userLookup, SessionContext sessionContext) {
        this.userLookup = userLookup;
        this.sessionContext = sessionContext;
        this.sessionUser = sessionContext.sessionUser();
        this.authenticatedUser = sessionContext.authenticatedUser();
    }

    public void ensureMayExecute(AnalyzedStatement statement) {
        if (!this.sessionUser.isSuperUser()) {
            statement.accept((AnalyzedStatementVisitor)new StatementVisitor(this.userLookup, this.sessionContext.searchPath().currentSchema(), this.authenticatedUser), (Object)this.sessionUser);
        }
    }

    public void ensureMaySee(Throwable t) throws MissingPrivilegeException {
        if (!this.sessionUser.isSuperUser() && t instanceof CrateException) {
            ((CrateException)t).accept((CrateExceptionVisitor)MaskSensitiveExceptions.INSTANCE, (Object)this.sessionUser);
        }
    }

    private static void throwRequiresSuperUserPermission(String userName) {
        throw new UnauthorizedException(String.format(Locale.ENGLISH, "User \"%s\" is not authorized to execute the statement. Superuser permissions are required", userName));
    }

    private static final class StatementVisitor
    extends AnalyzedStatementVisitor<User, Void> {
        private final RelationVisitor relationVisitor;
        private final String defaultSchema;
        private final User authenticatedUser;

        public StatementVisitor(UserLookup userLookup, String defaultSchema, User authenticatedUser) {
            this.authenticatedUser = authenticatedUser;
            this.relationVisitor = new RelationVisitor(userLookup, defaultSchema);
            this.defaultSchema = defaultSchema;
        }

        private void visitRelation(AnalyzedRelation relation, User user, Privilege.Type type) {
            relation.accept((AnalyzedRelationVisitor)this.relationVisitor, (Object)new RelationContext(user, type));
        }

        protected Void visitAnalyzedStatement(AnalyzedStatement analyzedStatement, User user) {
            AccessControlImpl.throwRequiresSuperUserPermission(user.name());
            return null;
        }

        public Void visitAnalyzedAlterUser(AnalyzedAlterUser analysis, User user) {
            if (!analysis.userName().equals(user.name())) {
                throw new UnauthorizedException("A regular user can use ALTER USER only on himself. To modify other users superuser permissions are required.");
            }
            return null;
        }

        public Void visitAlterTable(AnalyzedAlterTable alterTable, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DDL, Privilege.Clazz.TABLE, alterTable.tableInfo().ident().toString(), user, this.defaultSchema);
            return null;
        }

        protected Void visitCopyFromStatement(AnalyzedCopyFrom analysis, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DML, Privilege.Clazz.TABLE, analysis.tableInfo().ident().toString(), user, this.defaultSchema);
            return null;
        }

        protected Void visitCopyToStatement(AnalyzedCopyTo analysis, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DQL, Privilege.Clazz.TABLE, analysis.tableInfo().ident().fqn(), user, this.defaultSchema);
            return null;
        }

        public Void visitCreateTable(AnalyzedCreateTable createTable, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DDL, Privilege.Clazz.SCHEMA, createTable.relationName().schema(), user, this.defaultSchema);
            return null;
        }

        protected Void visitCreateRepositoryAnalyzedStatement(AnalyzedCreateRepository analysis, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DDL, Privilege.Clazz.CLUSTER, null, user, this.defaultSchema);
            return null;
        }

        protected Void visitAnalyzedDeleteStatement(AnalyzedDeleteStatement delete, User user) {
            this.visitRelation((AnalyzedRelation)delete.relation(), user, Privilege.Type.DML);
            return null;
        }

        protected Void visitAnalyzedInsertStatement(AnalyzedInsertStatement analysis, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DML, Privilege.Clazz.TABLE, analysis.tableInfo().ident().toString(), user, this.defaultSchema);
            this.visitRelation(analysis.subQueryRelation(), user, Privilege.Type.DQL);
            return null;
        }

        public Void visitSelectStatement(AnalyzedRelation relation, User user) {
            this.visitRelation(relation, user, Privilege.Type.DQL);
            return null;
        }

        public Void visitAnalyzedUpdateStatement(AnalyzedUpdateStatement update, User user) {
            this.visitRelation((AnalyzedRelation)update.table(), user, Privilege.Type.DML);
            return null;
        }

        protected Void visitCreateFunction(AnalyzedCreateFunction analysis, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DDL, Privilege.Clazz.SCHEMA, analysis.schema(), user, this.defaultSchema);
            return null;
        }

        public Void visitDropFunction(AnalyzedDropFunction analysis, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DDL, Privilege.Clazz.SCHEMA, analysis.schema(), user, this.defaultSchema);
            return null;
        }

        public Void visitDropTable(AnalyzedDropTable<?> dropTable, User user) {
            TableInfo table = dropTable.table();
            if (table != null) {
                Privileges.ensureUserHasPrivilege(Privilege.Type.DDL, Privilege.Clazz.TABLE, table.ident().toString(), user, this.defaultSchema);
            }
            return null;
        }

        protected Void visitCreateAnalyzerStatement(AnalyzedCreateAnalyzer analysis, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DDL, Privilege.Clazz.CLUSTER, null, user, this.defaultSchema);
            return null;
        }

        public Void visitAnalyzedCreateBlobTable(AnalyzedCreateBlobTable analysis, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DDL, Privilege.Clazz.SCHEMA, analysis.relationName().schema(), user, this.defaultSchema);
            return null;
        }

        public Void visitRefreshTableStatement(AnalyzedRefreshTable analysis, User user) {
            for (DocTableInfo tableInfo : analysis.tables().values()) {
                Privileges.ensureUserHasPrivilege(Privilege.Type.DQL, Privilege.Clazz.TABLE, tableInfo.ident().fqn(), user, this.defaultSchema);
            }
            return null;
        }

        public Void visitAnalyzedAlterTableRename(AnalyzedAlterTableRename analysis, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DDL, Privilege.Clazz.TABLE, analysis.sourceTableInfo().toString(), user, this.defaultSchema);
            return null;
        }

        public Void visitAnalyzedAlterBlobTable(AnalyzedAlterBlobTable analysis, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DDL, Privilege.Clazz.TABLE, analysis.tableInfo().ident().toString(), user, this.defaultSchema);
            return null;
        }

        public Void visitSetStatement(AnalyzedSetStatement analysis, User user) {
            if (analysis.scope().equals((Object)SetStatement.Scope.GLOBAL)) {
                Privileges.ensureUserHasPrivilege(Privilege.Type.AL, Privilege.Clazz.CLUSTER, null, user, this.defaultSchema);
            }
            return null;
        }

        public Void visitSetSessionAuthorizationStatement(AnalyzedSetSessionAuthorizationStatement analysis, User sessionUser) {
            if (analysis.user() != null && !this.authenticatedUser.name().equals(analysis.user())) {
                throw new UnauthorizedException(String.format(Locale.ENGLISH, "User \"%s\" is not authorized to execute the statement. Superuser permissions are required or you can set the session authorization back to the authenticated user.", sessionUser.name()));
            }
            return null;
        }

        public Void visitAlterTableAddColumn(AnalyzedAlterTableAddColumn analysis, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DDL, Privilege.Clazz.TABLE, analysis.tableInfo().ident().toString(), user, this.defaultSchema);
            return null;
        }

        public Void visitAlterTableDropCheckConstraint(AnalyzedAlterTableDropCheckConstraint dropCheckConstraint, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DDL, Privilege.Clazz.TABLE, dropCheckConstraint.tableInfo().ident().toString(), user, this.defaultSchema);
            return null;
        }

        public Void visitAnalyzedAlterTableOpenClose(AnalyzedAlterTableOpenClose analysis, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DDL, Privilege.Clazz.TABLE, analysis.tableInfo().ident().toString(), user, this.defaultSchema);
            return null;
        }

        public Void visitKillAnalyzedStatement(AnalyzedKill analysis, User user) {
            return null;
        }

        public Void visitDeallocateAnalyzedStatement(AnalyzedDeallocate analysis, User user) {
            return null;
        }

        public Void visitShowCreateTableAnalyzedStatement(AnalyzedShowCreateTable analysis, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DQL, Privilege.Clazz.TABLE, analysis.tableInfo().ident().toString(), user, this.defaultSchema);
            return null;
        }

        public Void visitDropRepositoryAnalyzedStatement(AnalyzedDropRepository analysis, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DDL, Privilege.Clazz.CLUSTER, null, user, this.defaultSchema);
            return null;
        }

        public Void visitDropSnapshotAnalyzedStatement(AnalyzedDropSnapshot analysis, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DDL, Privilege.Clazz.CLUSTER, null, user, this.defaultSchema);
            return null;
        }

        public Void visitCreateSnapshotAnalyzedStatement(AnalyzedCreateSnapshot analysis, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DDL, Privilege.Clazz.CLUSTER, null, user, this.defaultSchema);
            return null;
        }

        public Void visitRestoreSnapshotAnalyzedStatement(AnalyzedRestoreSnapshot analysis, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DDL, Privilege.Clazz.CLUSTER, null, user, this.defaultSchema);
            return null;
        }

        public Void visitResetAnalyzedStatement(AnalyzedResetStatement resetAnalyzedStatement, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.AL, Privilege.Clazz.CLUSTER, null, user, this.defaultSchema);
            return null;
        }

        public Void visitExplainStatement(ExplainAnalyzedStatement explainAnalyzedStatement, User user) {
            return (Void)explainAnalyzedStatement.statement().accept((AnalyzedStatementVisitor)this, (Object)user);
        }

        public Void visitBegin(AnalyzedBegin analyzedBegin, User user) {
            return null;
        }

        public Void visitCommit(AnalyzedCommit analyzedCommit, User user) {
            return null;
        }

        public Void visitCreateViewStmt(CreateViewStmt createViewStmt, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.DDL, Privilege.Clazz.SCHEMA, createViewStmt.name().schema(), user, this.defaultSchema);
            this.visitRelation(createViewStmt.analyzedQuery(), user, Privilege.Type.DQL);
            return null;
        }

        protected Void visitAnalyzedCreateUser(AnalyzedCreateUser createUser, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.AL, Privilege.Clazz.CLUSTER, null, user, this.defaultSchema);
            return null;
        }

        protected Void visitDropUser(AnalyzedDropUser dropUser, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.AL, Privilege.Clazz.CLUSTER, null, user, this.defaultSchema);
            return null;
        }

        public Void visitPrivilegesStatement(AnalyzedPrivileges changePrivileges, User user) {
            Privileges.ensureUserHasPrivilege(Privilege.Type.AL, Privilege.Clazz.CLUSTER, null, user, this.defaultSchema);
            for (Privilege privilege : changePrivileges.privileges()) {
                if (privilege.state() != Privilege.State.GRANT) continue;
                Privileges.ensureUserHasPrivilege(privilege.ident().type(), privilege.ident().clazz(), privilege.ident().ident(), user, this.defaultSchema);
            }
            return null;
        }

        public Void visitDropView(AnalyzedDropView dropView, User user) {
            for (RelationName name : dropView.views()) {
                Privileges.ensureUserHasPrivilege(Privilege.Type.DDL, Privilege.Clazz.VIEW, name.toString(), user, this.defaultSchema);
            }
            return null;
        }

        public Void visitDiscard(AnalyzedDiscard discard, User context) {
            return null;
        }

        public Void visitSetTransaction(AnalyzedSetTransaction setTransaction, User context) {
            return null;
        }
    }

    private static class MaskSensitiveExceptions
    extends CrateExceptionVisitor<User, Void> {
        private static final MaskSensitiveExceptions INSTANCE = new MaskSensitiveExceptions();

        private MaskSensitiveExceptions() {
        }

        protected Void visitCrateException(CrateException e, User context) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "CrateException '%s' not supported by privileges exception validator", e.getClass()));
        }

        protected Void visitTableScopeException(TableScopeException e, User user) {
            for (RelationName relationName : e.getTableIdents()) {
                Privileges.ensureUserHasPrivilege(Privilege.Clazz.TABLE, relationName.toString(), user);
            }
            return null;
        }

        protected Void visitSchemaScopeException(SchemaScopeException e, User context) {
            Privileges.ensureUserHasPrivilege(Privilege.Clazz.SCHEMA, e.getSchemaName(), context);
            return null;
        }

        protected Void visitClusterScopeException(ClusterScopeException e, User context) {
            Privileges.ensureUserHasPrivilege(Privilege.Clazz.CLUSTER, null, context);
            return null;
        }

        protected Void visitUnscopedException(UnscopedException e, User context) {
            return null;
        }
    }

    private static final class RelationVisitor
    extends AnalyzedRelationVisitor<RelationContext, Void> {
        private final UserLookup userLookup;
        private final String defaultSchema;

        public RelationVisitor(UserLookup userLookup, String defaultSchema) {
            this.userLookup = userLookup;
            this.defaultSchema = defaultSchema;
        }

        protected Void visitAnalyzedRelation(AnalyzedRelation relation, RelationContext context) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Can't handle \"%s\"", relation));
        }

        public Void visitUnionSelect(UnionSelect unionSelect, RelationContext context) {
            unionSelect.left().accept((AnalyzedRelationVisitor)this, (Object)context);
            unionSelect.right().accept((AnalyzedRelationVisitor)this, (Object)context);
            return null;
        }

        public Void visitTableRelation(TableRelation tableRelation, RelationContext context) {
            Privileges.ensureUserHasPrivilege(context.type, Privilege.Clazz.TABLE, tableRelation.tableInfo().ident().fqn(), context.user, this.defaultSchema);
            return null;
        }

        public Void visitDocTableRelation(DocTableRelation relation, RelationContext context) {
            Privileges.ensureUserHasPrivilege(context.type, Privilege.Clazz.TABLE, ((DocTableInfo)relation.tableInfo()).ident().fqn(), context.user, this.defaultSchema);
            return null;
        }

        public Void visitTableFunctionRelation(TableFunctionRelation tableFunctionRelation, RelationContext context) {
            return null;
        }

        public Void visitQueriedSelectRelation(QueriedSelectRelation relation, RelationContext context) {
            for (AnalyzedRelation source : relation.from()) {
                source.accept((AnalyzedRelationVisitor)this, (Object)context);
            }
            return null;
        }

        public Void visitView(AnalyzedView analyzedView, RelationContext context) {
            User owner;
            Privileges.ensureUserHasPrivilege(context.type, Privilege.Clazz.VIEW, analyzedView.name().toString(), context.user, this.defaultSchema);
            User user = owner = analyzedView.owner() == null ? null : this.userLookup.findUser(analyzedView.owner());
            if (owner == null) {
                throw new UnauthorizedException("Owner \"" + analyzedView.owner() + "\" of the view \"" + analyzedView.name().fqn() + "\" not found");
            }
            User currentUser = context.user;
            context.user = owner;
            analyzedView.relation().accept((AnalyzedRelationVisitor)this, (Object)context);
            context.user = currentUser;
            return null;
        }
    }

    private static class RelationContext {
        private User user;
        private final Privilege.Type type;

        RelationContext(User user, Privilege.Type type) {
            this.user = user;
            this.type = type;
        }
    }
}

