/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth;

import io.crate.auth.AuthenticationMethod;
import io.crate.auth.user.User;
import io.crate.auth.user.UserLookup;
import io.crate.protocols.postgres.ConnectionProperties;
import org.elasticsearch.common.settings.SecureString;

public class TrustAuthenticationMethod
implements AuthenticationMethod {
    static final String NAME = "trust";
    private final UserLookup userLookup;

    public TrustAuthenticationMethod(UserLookup userLookup) {
        this.userLookup = userLookup;
    }

    public User authenticate(String userName, SecureString passwd, ConnectionProperties connectionProperties) {
        User user = this.userLookup.findUser(userName);
        if (user == null) {
            throw new RuntimeException("trust authentication failed for user \"" + userName + "\"");
        }
        return user;
    }

    public String name() {
        return NAME;
    }
}

