/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth;

import io.crate.auth.AuthenticationMethod;
import io.crate.auth.user.User;
import io.crate.auth.user.UserLookup;
import io.crate.protocols.postgres.ConnectionProperties;
import io.crate.user.SecureHash;
import javax.annotation.Nullable;
import org.elasticsearch.common.settings.SecureString;

public class PasswordAuthenticationMethod
implements AuthenticationMethod {
    public static final String NAME = "password";
    private UserLookup userLookup;

    PasswordAuthenticationMethod(UserLookup userLookup) {
        this.userLookup = userLookup;
    }

    @Nullable
    public User authenticate(String userName, SecureString passwd, ConnectionProperties connProperties) {
        SecureHash secureHash;
        User user = this.userLookup.findUser(userName);
        if (user != null && passwd != null && passwd.length() > 0 && (secureHash = user.password()) != null && secureHash.verifyHash(passwd)) {
            return user;
        }
        throw new RuntimeException("password authentication failed for user \"" + userName + "\"");
    }

    public String name() {
        return NAME;
    }
}

