/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSortedMap;
import io.crate.auth.AuthSettings;
import io.crate.auth.Authentication;
import io.crate.auth.AuthenticationMethod;
import io.crate.auth.ClientCertAuth;
import io.crate.auth.PasswordAuthenticationMethod;
import io.crate.auth.Protocol;
import io.crate.auth.TrustAuthenticationMethod;
import io.crate.auth.user.UserLookup;
import io.crate.protocols.postgres.ConnectionProperties;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import javax.annotation.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.network.Cidrs;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.settings.Settings;

public class HostBasedAuthentication
implements Authentication {
    private static final String DEFAULT_AUTH_METHOD = "trust";
    private static final String KEY_USER = "user";
    private static final String KEY_ADDRESS = "address";
    private static final String KEY_METHOD = "method";
    static final String KEY_PROTOCOL = "protocol";
    private SortedMap<String, Map<String, String>> hbaConf;
    private final UserLookup userLookup;

    @Inject
    public HostBasedAuthentication(Settings settings, UserLookup userLookup) {
        this.hbaConf = this.convertHbaSettingsToHbaConf(settings);
        this.userLookup = userLookup;
    }

    @VisibleForTesting
    SortedMap<String, Map<String, String>> convertHbaSettingsToHbaConf(Settings settings) {
        Settings hbaSettings = (Settings)AuthSettings.AUTH_HOST_BASED_CONFIG_SETTING.setting().get(settings);
        ImmutableSortedMap.Builder hostBasedConf = ImmutableSortedMap.naturalOrder();
        for (Map.Entry entry : hbaSettings.getAsGroups().entrySet()) {
            Settings hbaEntry = (Settings)entry.getValue();
            HashMap<String, String> map = new HashMap<String, String>(hbaEntry.size());
            for (String name : hbaEntry.keySet()) {
                map.put(name, hbaEntry.get(name));
            }
            hostBasedConf.put((Object)((String)entry.getKey()), map);
        }
        return hostBasedConf.build();
    }

    @Nullable
    private AuthenticationMethod methodForName(String method) {
        switch (method) {
            case "trust": {
                return new TrustAuthenticationMethod(this.userLookup);
            }
            case "cert": {
                return new ClientCertAuth(this.userLookup);
            }
            case "password": {
                return new PasswordAuthenticationMethod(this.userLookup);
            }
        }
        return null;
    }

    @Nullable
    public AuthenticationMethod resolveAuthenticationType(String user, ConnectionProperties connProperties) {
        assert (this.hbaConf != null) : "hba configuration is missing";
        Optional<Map.Entry<String, Map<String, String>>> entry = this.getEntry(user, connProperties);
        if (entry.isPresent()) {
            String methodName = entry.get().getValue().getOrDefault(KEY_METHOD, DEFAULT_AUTH_METHOD);
            return this.methodForName(methodName);
        }
        return null;
    }

    @VisibleForTesting
    Map<String, Map<String, String>> hbaConf() {
        return this.hbaConf;
    }

    @VisibleForTesting
    Optional<Map.Entry<String, Map<String, String>>> getEntry(String user, ConnectionProperties connectionProperties) {
        if (user == null || connectionProperties == null) {
            return Optional.empty();
        }
        return this.hbaConf.entrySet().stream().filter(e -> Matchers.isValidUser(e, user)).filter(e -> Matchers.isValidAddress((String)((Map)e.getValue()).get(KEY_ADDRESS), connectionProperties.address())).filter(e -> Matchers.isValidProtocol((String)((Map)e.getValue()).get(KEY_PROTOCOL), connectionProperties.protocol())).filter(e -> Matchers.isValidConnection((String)((Map)e.getValue()).get("ssl"), connectionProperties)).findFirst();
    }

    static enum SSL {
        REQUIRED("on"),
        NEVER("off"),
        OPTIONAL("optional");

        static final String KEY = "ssl";
        final String VALUE;

        private SSL(String value) {
            this.VALUE = value;
        }
    }

    static class Matchers {
        private static final long IPV4_LOCALHOST = Matchers.inetAddressToInt(InetAddresses.forString((String)"127.0.0.1"));
        private static final long IPV6_LOCALHOST = Matchers.inetAddressToInt(InetAddresses.forString((String)"::1"));

        Matchers() {
        }

        static boolean isValidUser(Map.Entry<String, Map<String, String>> entry, String user) {
            String hbaUser = entry.getValue().get(HostBasedAuthentication.KEY_USER);
            return hbaUser == null || user.equals(hbaUser);
        }

        static boolean isValidAddress(@Nullable String hbaAddress, InetAddress address) {
            long addressAsLong;
            if (hbaAddress == null) {
                return true;
            }
            if (hbaAddress.equals("_local_")) {
                return Matchers.inetAddressToInt(address) == IPV4_LOCALHOST || Matchers.inetAddressToInt(address) == IPV6_LOCALHOST;
            }
            int p = hbaAddress.indexOf(47);
            if (p < 0) {
                return InetAddresses.forString((String)hbaAddress).equals(address);
            }
            long[] minAndMax = Cidrs.cidrMaskToMinMax((String)hbaAddress);
            return minAndMax[0] <= (addressAsLong = Matchers.inetAddressToInt(address)) && addressAsLong < minAndMax[1];
        }

        static boolean isValidProtocol(String hbaProtocol, Protocol protocol) {
            return hbaProtocol == null || hbaProtocol.equals(protocol.toString());
        }

        static boolean isValidConnection(String hbaConnectionMode, ConnectionProperties connectionProperties) {
            return hbaConnectionMode == null || hbaConnectionMode.isEmpty() || hbaConnectionMode.equals(SSL.OPTIONAL.VALUE) || hbaConnectionMode.equals(SSL.NEVER.VALUE) && !connectionProperties.hasSSL() || hbaConnectionMode.equals(SSL.REQUIRED.VALUE) && connectionProperties.hasSSL();
        }

        private static long inetAddressToInt(InetAddress address) {
            long net = 0L;
            for (byte a : address.getAddress()) {
                net <<= 8;
                net |= (long)(a & 0xFF);
            }
            return net;
        }
    }
}

