/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth;

import io.crate.auth.AuthenticationMethod;
import io.crate.auth.user.User;
import io.crate.auth.user.UserLookup;
import io.crate.protocols.SSL;
import io.crate.protocols.postgres.ConnectionProperties;
import java.security.cert.Certificate;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.common.settings.SecureString;

public class ClientCertAuth
implements AuthenticationMethod {
    static final String NAME = "cert";
    private final UserLookup userLookup;

    ClientCertAuth(UserLookup userLookup) {
        this.userLookup = userLookup;
    }

    @Nullable
    public User authenticate(String userName, SecureString passwd, ConnectionProperties connProperties) {
        Certificate clientCert = connProperties.clientCert();
        if (clientCert != null) {
            String commonName = SSL.extractCN((Certificate)clientCert);
            if (Objects.equals(userName, commonName)) {
                User user = this.userLookup.findUser(userName);
                if (user != null) {
                    return user;
                }
            } else {
                throw new RuntimeException("Common name \"" + commonName + "\" in client certificate doesn't match username \"" + userName + "\"");
            }
        }
        throw new RuntimeException("Client certificate authentication failed for user \"" + userName + "\"");
    }

    public String name() {
        return NAME;
    }
}

