/*
 * Decompiled with CFR 0.152.
 */
package io.crate.window;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.window.WindowFrameState;
import io.crate.execution.engine.window.WindowFunction;
import io.crate.metadata.functions.Signature;
import io.crate.module.EnterpriseFunctionsModule;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;
import java.util.function.IntBinaryOperator;

public class RankFunctions
implements WindowFunction {
    private static final String RANK_NAME = "rank";
    private static final String DENSE_RANK_NAME = "dense_rank";
    private final Signature signature;
    private final Signature boundSignature;
    private int seenLastUpperBound = -1;
    private int rank;
    private final IntBinaryOperator rankIncrementor;

    private RankFunctions(Signature signature, Signature boundSignature, IntBinaryOperator rankIncrementor) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.rankIncrementor = rankIncrementor;
    }

    public Signature signature() {
        return this.signature;
    }

    public Signature boundSignature() {
        return this.boundSignature;
    }

    public Object execute(int idxInPartition, WindowFrameState currentFrame, List<? extends CollectExpression<Row, ?>> expressions, Input ... args) {
        if (idxInPartition == 0) {
            this.rank = 1;
            this.seenLastUpperBound = currentFrame.upperBoundExclusive();
        }
        if (currentFrame.upperBoundExclusive() != this.seenLastUpperBound) {
            this.rank = this.rankIncrementor.applyAsInt(this.rank, this.seenLastUpperBound);
            this.seenLastUpperBound = currentFrame.upperBoundExclusive();
        }
        return this.rank;
    }

    public static void register(EnterpriseFunctionsModule module) {
        module.register(Signature.window((String)RANK_NAME, (TypeSignature[])new TypeSignature[]{DataTypes.INTEGER.getTypeSignature()}), (signature, boundSignature) -> new RankFunctions((Signature)signature, (Signature)boundSignature, (rank, upperBound) -> upperBound + 1));
        module.register(Signature.window((String)DENSE_RANK_NAME, (TypeSignature[])new TypeSignature[]{DataTypes.INTEGER.getTypeSignature()}), (signature, boundSignature) -> new RankFunctions((Signature)signature, (Signature)boundSignature, (rank, upperBound) -> rank + 1));
    }
}

