/*
 * Decompiled with CFR 0.152.
 */
package io.crate.window;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.RowN;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.window.WindowFrameState;
import io.crate.execution.engine.window.WindowFunction;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.module.EnterpriseFunctionsModule;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;

public class OffsetValueFunctions
implements WindowFunction {
    private static final String LAG_NAME = "lag";
    private static final String LEAD_NAME = "lead";
    private final OffsetDirection offsetDirection;
    private final Signature signature;
    private final Signature boundSignature;

    private OffsetValueFunctions(Signature signature, Signature boundSignature, OffsetDirection offsetDirection) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.offsetDirection = offsetDirection;
    }

    public Signature signature() {
        return this.signature;
    }

    public Signature boundSignature() {
        return this.boundSignature;
    }

    public Object execute(int idxInPartition, WindowFrameState currentFrame, List<? extends CollectExpression<Row, ?>> expressions, Input ... args) {
        int offset;
        if (args.length > 1) {
            Object offsetValue = args[1].value();
            if (offsetValue == null) {
                return null;
            }
            offset = ((Number)offsetValue).intValue();
        } else {
            offset = 1;
        }
        Object[] lagRowCells = currentFrame.getRowInPartitionAtIndexOrNull(this.offsetDirection.getTargetIndex(idxInPartition, offset));
        if (lagRowCells != null) {
            RowN lagRow = new RowN(lagRowCells);
            for (CollectExpression<Row, ?> expression : expressions) {
                expression.setNextRow((Object)lagRow);
            }
            return args[0].value();
        }
        return OffsetValueFunctions.getDefaultOrNull(args);
    }

    private static Object getDefaultOrNull(Input[] args) {
        if (args.length == 3) {
            return args[2].value();
        }
        return null;
    }

    public static void register(EnterpriseFunctionsModule module) {
        module.register(Signature.window((String)LEAD_NAME, (TypeSignature[])new TypeSignature[]{TypeSignature.parseTypeSignature((String)"E"), TypeSignature.parseTypeSignature((String)"E")}).withTypeVariableConstraints(new TypeVariableConstraint[]{TypeVariableConstraint.typeVariable((String)"E")}), (signature, boundSignature) -> new OffsetValueFunctions((Signature)signature, (Signature)boundSignature, OffsetDirection.FORWARD));
        module.register(Signature.window((String)LEAD_NAME, (TypeSignature[])new TypeSignature[]{TypeSignature.parseTypeSignature((String)"E"), DataTypes.INTEGER.getTypeSignature(), TypeSignature.parseTypeSignature((String)"E")}).withTypeVariableConstraints(new TypeVariableConstraint[]{TypeVariableConstraint.typeVariable((String)"E")}), (signature, boundSignature) -> new OffsetValueFunctions((Signature)signature, (Signature)boundSignature, OffsetDirection.FORWARD));
        module.register(Signature.window((String)LEAD_NAME, (TypeSignature[])new TypeSignature[]{TypeSignature.parseTypeSignature((String)"E"), DataTypes.INTEGER.getTypeSignature(), TypeSignature.parseTypeSignature((String)"E"), TypeSignature.parseTypeSignature((String)"E")}).withTypeVariableConstraints(new TypeVariableConstraint[]{TypeVariableConstraint.typeVariable((String)"E")}), (signature, boundSignature) -> new OffsetValueFunctions((Signature)signature, (Signature)boundSignature, OffsetDirection.FORWARD));
        module.register(Signature.window((String)LAG_NAME, (TypeSignature[])new TypeSignature[]{TypeSignature.parseTypeSignature((String)"E"), TypeSignature.parseTypeSignature((String)"E")}).withTypeVariableConstraints(new TypeVariableConstraint[]{TypeVariableConstraint.typeVariable((String)"E")}), (signature, boundSignature) -> new OffsetValueFunctions((Signature)signature, (Signature)boundSignature, OffsetDirection.BACKWARD));
        module.register(Signature.window((String)LAG_NAME, (TypeSignature[])new TypeSignature[]{TypeSignature.parseTypeSignature((String)"E"), DataTypes.INTEGER.getTypeSignature(), TypeSignature.parseTypeSignature((String)"E")}).withTypeVariableConstraints(new TypeVariableConstraint[]{TypeVariableConstraint.typeVariable((String)"E")}), (signature, boundSignature) -> new OffsetValueFunctions((Signature)signature, (Signature)boundSignature, OffsetDirection.BACKWARD));
        module.register(Signature.window((String)LAG_NAME, (TypeSignature[])new TypeSignature[]{TypeSignature.parseTypeSignature((String)"E"), DataTypes.INTEGER.getTypeSignature(), TypeSignature.parseTypeSignature((String)"E"), TypeSignature.parseTypeSignature((String)"E")}).withTypeVariableConstraints(new TypeVariableConstraint[]{TypeVariableConstraint.typeVariable((String)"E")}), (signature, boundSignature) -> new OffsetValueFunctions((Signature)signature, (Signature)boundSignature, OffsetDirection.BACKWARD));
    }

    private static enum OffsetDirection {
        FORWARD{

            @Override
            int getTargetIndex(int idxInPartition, int offset) {
                return idxInPartition + offset;
            }
        }
        ,
        BACKWARD{

            @Override
            int getTargetIndex(int idxInPartition, int offset) {
                return idxInPartition - offset;
            }
        };


        abstract int getTargetIndex(int var1, int var2);
    }
}

