/*
 * Decompiled with CFR 0.152.
 */
package io.crate.window;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.RowN;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.window.WindowFrameState;
import io.crate.execution.engine.window.WindowFunction;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.module.EnterpriseFunctionsModule;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;
import java.util.function.BiFunction;

public class NthValueFunctions
implements WindowFunction {
    public static final String LAST_VALUE_NAME = "last_value";
    private static final String FIRST_VALUE_NAME = "first_value";
    private static final String NTH_VALUE = "nth_value";
    private final Signature signature;
    private final Signature boundSignature;
    private final BiFunction<WindowFrameState, Input[], Integer> frameIndexSupplier;
    private int seenFrameLowerBound = -1;
    private int seenFrameUpperBound = -1;
    private Object resultForCurrentFrame = null;

    public static void register(EnterpriseFunctionsModule module) {
        module.register(Signature.window((String)FIRST_VALUE_NAME, (TypeSignature[])new TypeSignature[]{TypeSignature.parseTypeSignature((String)"E"), TypeSignature.parseTypeSignature((String)"E")}).withTypeVariableConstraints(new TypeVariableConstraint[]{TypeVariableConstraint.typeVariable((String)"E")}), (signature, boundSignature) -> new NthValueFunctions((Signature)signature, (Signature)boundSignature, (frame, inputs) -> 0));
        module.register(Signature.window((String)LAST_VALUE_NAME, (TypeSignature[])new TypeSignature[]{TypeSignature.parseTypeSignature((String)"E"), TypeSignature.parseTypeSignature((String)"E")}).withTypeVariableConstraints(new TypeVariableConstraint[]{TypeVariableConstraint.typeVariable((String)"E")}), (signature, boundSignature) -> new NthValueFunctions((Signature)signature, (Signature)boundSignature, (frame, inputs) -> frame.size() - 1));
        module.register(Signature.window((String)NTH_VALUE, (TypeSignature[])new TypeSignature[]{TypeSignature.parseTypeSignature((String)"E"), DataTypes.INTEGER.getTypeSignature(), TypeSignature.parseTypeSignature((String)"E")}).withTypeVariableConstraints(new TypeVariableConstraint[]{TypeVariableConstraint.typeVariable((String)"E")}), (signature, boundSignature) -> new NthValueFunctions((Signature)signature, (Signature)boundSignature, (frame, inputs) -> {
            Number position = (Number)inputs[1].value();
            if (position == null) {
                return -1;
            }
            return position.intValue() - 1;
        }));
    }

    private NthValueFunctions(Signature signature, Signature boundSignature, BiFunction<WindowFrameState, Input[], Integer> frameIndexSupplier) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.frameIndexSupplier = frameIndexSupplier;
    }

    public Signature signature() {
        return this.signature;
    }

    public Signature boundSignature() {
        return this.boundSignature;
    }

    public Object execute(int idxInPartition, WindowFrameState currentFrame, List<? extends CollectExpression<Row, ?>> expressions, Input ... args) {
        boolean shrinkingWindow = WindowFrameState.isLowerBoundIncreasing((WindowFrameState)currentFrame, (int)this.seenFrameLowerBound);
        if (idxInPartition == 0 || currentFrame.upperBoundExclusive() > this.seenFrameUpperBound || shrinkingWindow) {
            Object[] nthRowCells;
            this.seenFrameLowerBound = currentFrame.lowerBound();
            this.seenFrameUpperBound = currentFrame.upperBoundExclusive();
            int index = this.frameIndexSupplier.apply(currentFrame, args);
            if (shrinkingWindow) {
                index = currentFrame.lowerBound() + index;
            }
            if ((nthRowCells = currentFrame.getRowInFrameAtIndexOrNull(index)) == null) {
                this.resultForCurrentFrame = null;
                return null;
            }
            RowN nthRowInFrame = new RowN(nthRowCells);
            for (CollectExpression<Row, ?> expression : expressions) {
                expression.setNextRow((Object)nthRowInFrame);
            }
            this.resultForCurrentFrame = args[0].value();
        }
        return this.resultForCurrentFrame;
    }
}

