/*
 * Decompiled with CFR 0.152.
 */
package io.crate.operation.aggregation;

import com.carrotsearch.hppc.BitMixer;
import com.google.common.annotations.VisibleForTesting;
import io.crate.Streamer;
import io.crate.breaker.RamAccounting;
import io.crate.data.Input;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.impl.HyperLogLogPlusPlus;
import io.crate.memory.MemoryManager;
import io.crate.metadata.functions.Signature;
import io.crate.module.EnterpriseFunctionsModule;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class HyperLogLogDistinctAggregation
extends AggregationFunction<HllState, Long> {
    static final String NAME = "hyperloglog_distinct";
    private final Signature signature;
    private final Signature boundSignature;
    private final DataType<?> dataType;

    public static void register(EnterpriseFunctionsModule mod) {
        for (DataType supportedType : DataTypes.PRIMITIVE_TYPES) {
            mod.register(Signature.aggregate((String)NAME, (TypeSignature[])new TypeSignature[]{supportedType.getTypeSignature(), DataTypes.LONG.getTypeSignature()}), (signature, boundSignature) -> new HyperLogLogDistinctAggregation((Signature)signature, (Signature)boundSignature, (DataType<?>)supportedType));
            mod.register(Signature.aggregate((String)NAME, (TypeSignature[])new TypeSignature[]{supportedType.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.LONG.getTypeSignature()}), (signature, boundSignature) -> new HyperLogLogDistinctAggregation((Signature)signature, (Signature)boundSignature, (DataType<?>)supportedType));
        }
    }

    private HyperLogLogDistinctAggregation(Signature signature, Signature boundSignature, DataType<?> dataType) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.dataType = dataType;
    }

    @Nullable
    public HllState newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
        return new HllState(this.dataType, minNodeInCluster.onOrAfter(Version.V_4_1_0));
    }

    public HllState iterate(RamAccounting ramAccounting, MemoryManager memoryManager, HllState state, Input ... args) throws CircuitBreakingException {
        Object value;
        if (!state.isInitialized()) {
            int precision = 14;
            if (args.length > 1) {
                precision = DataTypes.INTEGER.sanitizeValue(args[1].value());
            }
            state.init(memoryManager, precision);
        }
        if ((value = args[0].value()) != null) {
            state.add(value);
        }
        return state;
    }

    public HllState reduce(RamAccounting ramAccounting, HllState state1, HllState state2) {
        if (!state1.isInitialized()) {
            return state2;
        }
        if (state2.isInitialized()) {
            state1.merge(state2);
        }
        return state1;
    }

    public Long terminatePartial(RamAccounting ramAccounting, HllState state) {
        if (state.isInitialized()) {
            return state.value();
        }
        return null;
    }

    public DataType<?> partialType() {
        return HllStateType.INSTANCE;
    }

    public Signature signature() {
        return this.signature;
    }

    public Signature boundSignature() {
        return this.boundSignature;
    }

    static {
        DataTypes.register((int)17000, in -> HllStateType.INSTANCE);
    }

    public static class HllState
    implements Comparable<HllState>,
    Writeable {
        private final DataType<?> dataType;
        private final Murmur3Hash murmur3Hash;
        private final boolean allOn4_1;
        private HyperLogLogPlusPlus hyperLogLogPlusPlus;

        HllState(DataType<?> dataType, boolean allOn4_1) {
            this.dataType = dataType;
            this.allOn4_1 = allOn4_1;
            this.murmur3Hash = Murmur3Hash.getForType(dataType, allOn4_1);
        }

        HllState(StreamInput in) throws IOException {
            this.allOn4_1 = in.getVersion().onOrAfter(Version.V_4_1_0) ? in.readBoolean() : false;
            this.dataType = DataTypes.fromStream((StreamInput)in);
            this.murmur3Hash = Murmur3Hash.getForType(this.dataType, this.allOn4_1);
            if (in.readBoolean()) {
                this.hyperLogLogPlusPlus = HyperLogLogPlusPlus.readFrom(in);
            }
        }

        void init(MemoryManager memoryManager, int precision) {
            assert (this.hyperLogLogPlusPlus == null) : "hyperLogLog algorithm was already initialized";
            try {
                this.hyperLogLogPlusPlus = new HyperLogLogPlusPlus(precision, arg_0 -> ((MemoryManager)memoryManager).allocate(arg_0));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("precision must be >= 4 and <= 18");
            }
        }

        boolean isInitialized() {
            return this.hyperLogLogPlusPlus != null;
        }

        void add(Object value) {
            this.hyperLogLogPlusPlus.collect(this.murmur3Hash.hash(value));
        }

        void merge(HllState state) {
            this.hyperLogLogPlusPlus.merge(state.hyperLogLogPlusPlus);
        }

        long value() {
            return this.hyperLogLogPlusPlus.cardinality();
        }

        @Override
        public int compareTo(HllState o) {
            return Long.compare(this.hyperLogLogPlusPlus.cardinality(), o.hyperLogLogPlusPlus.cardinality());
        }

        public String toString() {
            return String.valueOf(this.value());
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (out.getVersion().onOrAfter(Version.V_4_1_0)) {
                out.writeBoolean(this.allOn4_1);
            }
            DataTypes.toStream(this.dataType, (StreamOutput)out);
            if (this.isInitialized()) {
                out.writeBoolean(true);
                this.hyperLogLogPlusPlus.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public static class HllStateType
    extends DataType<HllState>
    implements Streamer<HllState> {
        static final int ID = 17000;
        static final HllStateType INSTANCE = new HllStateType();

        public int id() {
            return 17000;
        }

        public DataType.Precedence precedence() {
            return DataType.Precedence.CUSTOM;
        }

        public String getName() {
            return "hll_state";
        }

        public Streamer<HllState> streamer() {
            return this;
        }

        public HllState sanitizeValue(Object value) {
            return (HllState)value;
        }

        public int compare(HllState val1, HllState val2) {
            if (val1 == null) {
                return -1;
            }
            return val1.compareTo(val2);
        }

        public HllState readValueFrom(StreamInput in) throws IOException {
            return new HllState(in);
        }

        public void writeValueTo(StreamOutput out, HllState v) throws IOException {
            v.writeTo(out);
        }
    }

    @VisibleForTesting
    static abstract class Murmur3Hash {
        Murmur3Hash() {
        }

        static Murmur3Hash getForType(DataType<?> dataType, boolean allOn4_1) {
            switch (dataType.id()) {
                case 6: 
                case 7: {
                    return Double.INSTANCE;
                }
                case 2: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    return Long.INSTANCE;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (allOn4_1) {
                        return Bytes64.INSTANCE;
                    }
                    return new Bytes();
                }
            }
            throw new IllegalArgumentException("data type \"" + dataType + "\" is not supported");
        }

        abstract long hash(Object var1);

        private static class Double
        extends Murmur3Hash {
            private static final Double INSTANCE = new Double();

            private Double() {
            }

            @Override
            long hash(Object val) {
                return BitMixer.mix64((long)java.lang.Double.doubleToLongBits(DataTypes.DOUBLE.sanitizeValue(val)));
            }
        }

        private static class Long
        extends Murmur3Hash {
            private static final Long INSTANCE = new Long();

            private Long() {
            }

            @Override
            long hash(Object val) {
                return BitMixer.mix64((long)DataTypes.LONG.sanitizeValue(val));
            }
        }

        static class Bytes64
        extends Murmur3Hash {
            static final Bytes64 INSTANCE = new Bytes64();

            Bytes64() {
            }

            @Override
            long hash(Object val) {
                byte[] bytes = DataTypes.STRING.implicitCast(val).getBytes(StandardCharsets.UTF_8);
                return MurmurHash3.hash64((byte[])bytes, (int)bytes.length);
            }
        }

        static class Bytes
        extends Murmur3Hash {
            private final MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();

            Bytes() {
            }

            @Override
            long hash(Object val) {
                byte[] bytes = DataTypes.STRING.implicitCast(val).getBytes(StandardCharsets.UTF_8);
                MurmurHash3.hash128((byte[])bytes, (int)0, (int)bytes.length, (long)0L, (MurmurHash3.Hash128)this.hash);
                return this.hash.h1;
            }
        }
    }
}

