/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.util.Collection;
import java.util.HashSet;
import org.joda.time.DateTimeFieldType;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public class StrictISODateTimeFormat {
    protected StrictISODateTimeFormat() {
    }

    public static DateTimeFormatter forFields(Collection<DateTimeFieldType> fields, boolean extended, boolean strictISO) {
        if (fields == null || fields.size() == 0) {
            throw new IllegalArgumentException("The fields must not be null or empty");
        }
        HashSet<DateTimeFieldType> workingFields = new HashSet<DateTimeFieldType>(fields);
        int inputSize = workingFields.size();
        boolean reducedPrec = false;
        DateTimeFormatterBuilder bld = new DateTimeFormatterBuilder();
        if (workingFields.contains(DateTimeFieldType.monthOfYear())) {
            reducedPrec = StrictISODateTimeFormat.dateByMonth(bld, workingFields, extended, strictISO);
        } else if (workingFields.contains(DateTimeFieldType.dayOfYear())) {
            reducedPrec = StrictISODateTimeFormat.dateByOrdinal(bld, workingFields, extended);
        } else if (workingFields.contains(DateTimeFieldType.weekOfWeekyear())) {
            reducedPrec = StrictISODateTimeFormat.dateByWeek(bld, workingFields, extended, strictISO);
        } else if (workingFields.contains(DateTimeFieldType.dayOfMonth())) {
            reducedPrec = StrictISODateTimeFormat.dateByMonth(bld, workingFields, extended, strictISO);
        } else if (workingFields.contains(DateTimeFieldType.dayOfWeek())) {
            reducedPrec = StrictISODateTimeFormat.dateByWeek(bld, workingFields, extended, strictISO);
        } else if (workingFields.remove(DateTimeFieldType.year())) {
            bld.append(Constants.YE);
            reducedPrec = true;
        } else if (workingFields.remove(DateTimeFieldType.weekyear())) {
            bld.append(Constants.WE);
            reducedPrec = true;
        }
        boolean datePresent = workingFields.size() < inputSize;
        StrictISODateTimeFormat.time(bld, workingFields, extended, strictISO, reducedPrec, datePresent);
        if (!bld.canBuildFormatter()) {
            throw new IllegalArgumentException("No valid format for fields: " + fields);
        }
        try {
            fields.retainAll(workingFields);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return bld.toFormatter();
    }

    private static boolean dateByMonth(DateTimeFormatterBuilder bld, Collection<DateTimeFieldType> fields, boolean extended, boolean strictISO) {
        boolean reducedPrec = false;
        if (fields.remove(DateTimeFieldType.year())) {
            bld.append(Constants.YE);
            if (fields.remove(DateTimeFieldType.monthOfYear())) {
                if (fields.remove(DateTimeFieldType.dayOfMonth())) {
                    StrictISODateTimeFormat.appendSeparator(bld, extended);
                    bld.appendMonthOfYear(2);
                    StrictISODateTimeFormat.appendSeparator(bld, extended);
                    bld.appendDayOfMonth(2);
                } else {
                    bld.appendLiteral('-');
                    bld.appendMonthOfYear(2);
                    reducedPrec = true;
                }
            } else if (fields.remove(DateTimeFieldType.dayOfMonth())) {
                StrictISODateTimeFormat.checkNotStrictISO(fields, strictISO);
                bld.appendLiteral('-');
                bld.appendLiteral('-');
                bld.appendDayOfMonth(2);
            } else {
                reducedPrec = true;
            }
        } else if (fields.remove(DateTimeFieldType.monthOfYear())) {
            bld.appendLiteral('-');
            bld.appendLiteral('-');
            bld.appendMonthOfYear(2);
            if (fields.remove(DateTimeFieldType.dayOfMonth())) {
                StrictISODateTimeFormat.appendSeparator(bld, extended);
                bld.appendDayOfMonth(2);
            } else {
                reducedPrec = true;
            }
        } else if (fields.remove(DateTimeFieldType.dayOfMonth())) {
            bld.appendLiteral('-');
            bld.appendLiteral('-');
            bld.appendLiteral('-');
            bld.appendDayOfMonth(2);
        }
        return reducedPrec;
    }

    private static boolean dateByOrdinal(DateTimeFormatterBuilder bld, Collection<DateTimeFieldType> fields, boolean extended) {
        boolean reducedPrec = false;
        if (fields.remove(DateTimeFieldType.year())) {
            bld.append(Constants.YE);
            if (fields.remove(DateTimeFieldType.dayOfYear())) {
                StrictISODateTimeFormat.appendSeparator(bld, extended);
                bld.appendDayOfYear(3);
            } else {
                reducedPrec = true;
            }
        } else if (fields.remove(DateTimeFieldType.dayOfYear())) {
            bld.appendLiteral('-');
            bld.appendDayOfYear(3);
        }
        return reducedPrec;
    }

    private static boolean dateByWeek(DateTimeFormatterBuilder bld, Collection<DateTimeFieldType> fields, boolean extended, boolean strictISO) {
        boolean reducedPrec = false;
        if (fields.remove(DateTimeFieldType.weekyear())) {
            bld.append(Constants.WE);
            if (fields.remove(DateTimeFieldType.weekOfWeekyear())) {
                StrictISODateTimeFormat.appendSeparator(bld, extended);
                bld.appendLiteral('W');
                bld.appendWeekOfWeekyear(2);
                if (fields.remove(DateTimeFieldType.dayOfWeek())) {
                    StrictISODateTimeFormat.appendSeparator(bld, extended);
                    bld.appendDayOfWeek(1);
                } else {
                    reducedPrec = true;
                }
            } else if (fields.remove(DateTimeFieldType.dayOfWeek())) {
                StrictISODateTimeFormat.checkNotStrictISO(fields, strictISO);
                StrictISODateTimeFormat.appendSeparator(bld, extended);
                bld.appendLiteral('W');
                bld.appendLiteral('-');
                bld.appendDayOfWeek(1);
            } else {
                reducedPrec = true;
            }
        } else if (fields.remove(DateTimeFieldType.weekOfWeekyear())) {
            bld.appendLiteral('-');
            bld.appendLiteral('W');
            bld.appendWeekOfWeekyear(2);
            if (fields.remove(DateTimeFieldType.dayOfWeek())) {
                StrictISODateTimeFormat.appendSeparator(bld, extended);
                bld.appendDayOfWeek(1);
            } else {
                reducedPrec = true;
            }
        } else if (fields.remove(DateTimeFieldType.dayOfWeek())) {
            bld.appendLiteral('-');
            bld.appendLiteral('W');
            bld.appendLiteral('-');
            bld.appendDayOfWeek(1);
        }
        return reducedPrec;
    }

    private static void time(DateTimeFormatterBuilder bld, Collection<DateTimeFieldType> fields, boolean extended, boolean strictISO, boolean reducedPrec, boolean datePresent) {
        boolean hour = fields.remove(DateTimeFieldType.hourOfDay());
        boolean minute = fields.remove(DateTimeFieldType.minuteOfHour());
        boolean second = fields.remove(DateTimeFieldType.secondOfMinute());
        boolean milli = fields.remove(DateTimeFieldType.millisOfSecond());
        if (!(hour || minute || second || milli)) {
            return;
        }
        if (hour || minute || second || milli) {
            if (strictISO && reducedPrec) {
                throw new IllegalArgumentException("No valid ISO8601 format for fields because Date was reduced precision: " + fields);
            }
            if (datePresent) {
                bld.appendLiteral('T');
            }
        }
        if (!(hour && minute && second || hour && !second && !milli)) {
            if (strictISO && datePresent) {
                throw new IllegalArgumentException("No valid ISO8601 format for fields because Time was truncated: " + fields);
            }
            if (!(!hour && (minute && second || minute && !milli || second) || !strictISO)) {
                throw new IllegalArgumentException("No valid ISO8601 format for fields: " + fields);
            }
        }
        if (hour) {
            bld.appendHourOfDay(2);
        } else if (minute || second || milli) {
            bld.appendLiteral('-');
        }
        if (extended && hour && minute) {
            bld.appendLiteral(':');
        }
        if (minute) {
            bld.appendMinuteOfHour(2);
        } else if (second || milli) {
            bld.appendLiteral('-');
        }
        if (extended && minute && second) {
            bld.appendLiteral(':');
        }
        if (second) {
            bld.appendSecondOfMinute(2);
        } else if (milli) {
            bld.appendLiteral('-');
        }
        if (milli) {
            bld.appendLiteral('.');
            bld.appendMillisOfSecond(3);
        }
    }

    private static void checkNotStrictISO(Collection<DateTimeFieldType> fields, boolean strictISO) {
        if (strictISO) {
            throw new IllegalArgumentException("No valid ISO8601 format for fields: " + fields);
        }
    }

    private static void appendSeparator(DateTimeFormatterBuilder bld, boolean extended) {
        if (extended) {
            bld.appendLiteral('-');
        }
    }

    public static DateTimeFormatter dateParser() {
        return Constants.DP;
    }

    public static DateTimeFormatter localDateParser() {
        return Constants.LDP;
    }

    public static DateTimeFormatter dateElementParser() {
        return Constants.DPE;
    }

    public static DateTimeFormatter timeParser() {
        return Constants.TP;
    }

    public static DateTimeFormatter localTimeParser() {
        return Constants.LTP;
    }

    public static DateTimeFormatter timeElementParser() {
        return Constants.TPE;
    }

    public static DateTimeFormatter dateTimeParser() {
        return Constants.DTP;
    }

    public static DateTimeFormatter dateOptionalTimeParser() {
        return Constants.DOTP;
    }

    public static DateTimeFormatter localDateOptionalTimeParser() {
        return Constants.LDOTP;
    }

    public static DateTimeFormatter date() {
        return StrictISODateTimeFormat.yearMonthDay();
    }

    public static DateTimeFormatter time() {
        return Constants.T;
    }

    public static DateTimeFormatter timeNoMillis() {
        return Constants.TX;
    }

    public static DateTimeFormatter tTime() {
        return Constants.TT;
    }

    public static DateTimeFormatter tTimeNoMillis() {
        return Constants.TTX;
    }

    public static DateTimeFormatter dateTime() {
        return Constants.DT;
    }

    public static DateTimeFormatter dateTimeNoMillis() {
        return Constants.DTX;
    }

    public static DateTimeFormatter ordinalDate() {
        return Constants.OD;
    }

    public static DateTimeFormatter ordinalDateTime() {
        return Constants.ODT;
    }

    public static DateTimeFormatter ordinalDateTimeNoMillis() {
        return Constants.ODTX;
    }

    public static DateTimeFormatter weekDate() {
        return Constants.WWD;
    }

    public static DateTimeFormatter weekDateTime() {
        return Constants.WDT;
    }

    public static DateTimeFormatter weekDateTimeNoMillis() {
        return Constants.WDTX;
    }

    public static DateTimeFormatter basicDate() {
        return Constants.BD;
    }

    public static DateTimeFormatter basicTime() {
        return Constants.BT;
    }

    public static DateTimeFormatter basicTimeNoMillis() {
        return Constants.BTX;
    }

    public static DateTimeFormatter basicTTime() {
        return Constants.BTT;
    }

    public static DateTimeFormatter basicTTimeNoMillis() {
        return Constants.BTTX;
    }

    public static DateTimeFormatter basicDateTime() {
        return Constants.BDT;
    }

    public static DateTimeFormatter basicDateTimeNoMillis() {
        return Constants.BDTX;
    }

    public static DateTimeFormatter basicOrdinalDate() {
        return Constants.BOD;
    }

    public static DateTimeFormatter basicOrdinalDateTime() {
        return Constants.BODT;
    }

    public static DateTimeFormatter basicOrdinalDateTimeNoMillis() {
        return Constants.BODTX;
    }

    public static DateTimeFormatter basicWeekDate() {
        return Constants.BWD;
    }

    public static DateTimeFormatter basicWeekDateTime() {
        return Constants.BWDT;
    }

    public static DateTimeFormatter basicWeekDateTimeNoMillis() {
        return Constants.BWDTX;
    }

    public static DateTimeFormatter year() {
        return Constants.YE;
    }

    public static DateTimeFormatter yearMonth() {
        return Constants.YM;
    }

    public static DateTimeFormatter yearMonthDay() {
        return Constants.YMD;
    }

    public static DateTimeFormatter weekyear() {
        return Constants.WE;
    }

    public static DateTimeFormatter weekyearWeek() {
        return Constants.WW;
    }

    public static DateTimeFormatter weekyearWeekDay() {
        return Constants.WWD;
    }

    public static DateTimeFormatter hour() {
        return Constants.HDE;
    }

    public static DateTimeFormatter hourMinute() {
        return Constants.HM;
    }

    public static DateTimeFormatter hourMinuteSecond() {
        return Constants.HMS;
    }

    public static DateTimeFormatter hourMinuteSecondMillis() {
        return Constants.HMSL;
    }

    public static DateTimeFormatter hourMinuteSecondFraction() {
        return Constants.HMSF;
    }

    public static DateTimeFormatter dateHour() {
        return Constants.DH;
    }

    public static DateTimeFormatter dateHourMinute() {
        return Constants.DHM;
    }

    public static DateTimeFormatter dateHourMinuteSecond() {
        return Constants.DHMS;
    }

    public static DateTimeFormatter dateHourMinuteSecondMillis() {
        return Constants.DHMSL;
    }

    public static DateTimeFormatter dateHourMinuteSecondFraction() {
        return Constants.DHMSF;
    }

    static final class Constants {
        private static final DateTimeFormatter YE = Constants.yearElement();
        private static final DateTimeFormatter MYE = Constants.monthElement();
        private static final DateTimeFormatter DME = Constants.dayOfMonthElement();
        private static final DateTimeFormatter WE = Constants.weekyearElement();
        private static final DateTimeFormatter WWE = Constants.weekElement();
        private static final DateTimeFormatter DWE = Constants.dayOfWeekElement();
        private static final DateTimeFormatter DYE = Constants.dayOfYearElement();
        private static final DateTimeFormatter HDE = Constants.hourElement();
        private static final DateTimeFormatter MHE = Constants.minuteElement();
        private static final DateTimeFormatter SME = Constants.secondElement();
        private static final DateTimeFormatter FSE = Constants.fractionElement();
        private static final DateTimeFormatter ZE = Constants.offsetElement();
        private static final DateTimeFormatter LTE = Constants.literalTElement();
        private static final DateTimeFormatter YM = Constants.yearMonth();
        private static final DateTimeFormatter YMD = Constants.yearMonthDay();
        private static final DateTimeFormatter WW = Constants.weekyearWeek();
        private static final DateTimeFormatter WWD = Constants.weekyearWeekDay();
        private static final DateTimeFormatter HM = Constants.hourMinute();
        private static final DateTimeFormatter HMS = Constants.hourMinuteSecond();
        private static final DateTimeFormatter HMSL = Constants.hourMinuteSecondMillis();
        private static final DateTimeFormatter HMSF = Constants.hourMinuteSecondFraction();
        private static final DateTimeFormatter DH = Constants.dateHour();
        private static final DateTimeFormatter DHM = Constants.dateHourMinute();
        private static final DateTimeFormatter DHMS = Constants.dateHourMinuteSecond();
        private static final DateTimeFormatter DHMSL = Constants.dateHourMinuteSecondMillis();
        private static final DateTimeFormatter DHMSF = Constants.dateHourMinuteSecondFraction();
        private static final DateTimeFormatter T = Constants.time();
        private static final DateTimeFormatter TX = Constants.timeNoMillis();
        private static final DateTimeFormatter TT = Constants.tTime();
        private static final DateTimeFormatter TTX = Constants.tTimeNoMillis();
        private static final DateTimeFormatter DT = Constants.dateTime();
        private static final DateTimeFormatter DTX = Constants.dateTimeNoMillis();
        private static final DateTimeFormatter WDT = Constants.weekDateTime();
        private static final DateTimeFormatter WDTX = Constants.weekDateTimeNoMillis();
        private static final DateTimeFormatter OD = Constants.ordinalDate();
        private static final DateTimeFormatter ODT = Constants.ordinalDateTime();
        private static final DateTimeFormatter ODTX = Constants.ordinalDateTimeNoMillis();
        private static final DateTimeFormatter BD = Constants.basicDate();
        private static final DateTimeFormatter BT = Constants.basicTime();
        private static final DateTimeFormatter BTX = Constants.basicTimeNoMillis();
        private static final DateTimeFormatter BTT = Constants.basicTTime();
        private static final DateTimeFormatter BTTX = Constants.basicTTimeNoMillis();
        private static final DateTimeFormatter BDT = Constants.basicDateTime();
        private static final DateTimeFormatter BDTX = Constants.basicDateTimeNoMillis();
        private static final DateTimeFormatter BOD = Constants.basicOrdinalDate();
        private static final DateTimeFormatter BODT = Constants.basicOrdinalDateTime();
        private static final DateTimeFormatter BODTX = Constants.basicOrdinalDateTimeNoMillis();
        private static final DateTimeFormatter BWD = Constants.basicWeekDate();
        private static final DateTimeFormatter BWDT = Constants.basicWeekDateTime();
        private static final DateTimeFormatter BWDTX = Constants.basicWeekDateTimeNoMillis();
        private static final DateTimeFormatter DPE = Constants.dateElementParser();
        private static final DateTimeFormatter TPE = Constants.timeElementParser();
        private static final DateTimeFormatter DP = Constants.dateParser();
        private static final DateTimeFormatter LDP = Constants.localDateParser();
        private static final DateTimeFormatter TP = Constants.timeParser();
        private static final DateTimeFormatter LTP = Constants.localTimeParser();
        private static final DateTimeFormatter DTP = Constants.dateTimeParser();
        private static final DateTimeFormatter DOTP = Constants.dateOptionalTimeParser();
        private static final DateTimeFormatter LDOTP = Constants.localDateOptionalTimeParser();

        Constants() {
        }

        private static DateTimeFormatter dateParser() {
            if (DP == null) {
                DateTimeParser tOffset = new DateTimeFormatterBuilder().appendLiteral('T').append(Constants.offsetElement()).toParser();
                return new DateTimeFormatterBuilder().append(Constants.dateElementParser()).appendOptional(tOffset).toFormatter();
            }
            return DP;
        }

        private static DateTimeFormatter localDateParser() {
            if (LDP == null) {
                return Constants.dateElementParser().withZoneUTC();
            }
            return LDP;
        }

        private static DateTimeFormatter dateElementParser() {
            if (DPE == null) {
                return new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{new DateTimeFormatterBuilder().append(Constants.yearElement()).appendOptional(new DateTimeFormatterBuilder().append(Constants.monthElement()).appendOptional(Constants.dayOfMonthElement().getParser()).toParser()).toParser(), new DateTimeFormatterBuilder().append(Constants.weekyearElement()).append(Constants.weekElement()).appendOptional(Constants.dayOfWeekElement().getParser()).toParser(), new DateTimeFormatterBuilder().append(Constants.yearElement()).append(Constants.dayOfYearElement()).toParser()}).toFormatter();
            }
            return DPE;
        }

        private static DateTimeFormatter timeParser() {
            if (TP == null) {
                return new DateTimeFormatterBuilder().appendOptional(Constants.literalTElement().getParser()).append(Constants.timeElementParser()).appendOptional(Constants.offsetElement().getParser()).toFormatter();
            }
            return TP;
        }

        private static DateTimeFormatter localTimeParser() {
            if (LTP == null) {
                return new DateTimeFormatterBuilder().appendOptional(Constants.literalTElement().getParser()).append(Constants.timeElementParser()).toFormatter().withZoneUTC();
            }
            return LTP;
        }

        private static DateTimeFormatter timeElementParser() {
            if (TPE == null) {
                DateTimeParser decimalPoint = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{new DateTimeFormatterBuilder().appendLiteral('.').toParser(), new DateTimeFormatterBuilder().appendLiteral(',').toParser()}).toParser();
                return new DateTimeFormatterBuilder().append(Constants.hourElement()).append(null, new DateTimeParser[]{new DateTimeFormatterBuilder().append(Constants.minuteElement()).append(null, new DateTimeParser[]{new DateTimeFormatterBuilder().append(Constants.secondElement()).appendOptional(new DateTimeFormatterBuilder().append(decimalPoint).appendFractionOfSecond(1, 9).toParser()).toParser(), new DateTimeFormatterBuilder().append(decimalPoint).appendFractionOfMinute(1, 9).toParser(), null}).toParser(), new DateTimeFormatterBuilder().append(decimalPoint).appendFractionOfHour(1, 9).toParser(), null}).toFormatter();
            }
            return TPE;
        }

        private static DateTimeFormatter dateTimeParser() {
            if (DTP == null) {
                DateTimeParser time = new DateTimeFormatterBuilder().appendLiteral('T').append(Constants.timeElementParser()).appendOptional(Constants.offsetElement().getParser()).toParser();
                return new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{time, Constants.dateOptionalTimeParser().getParser()}).toFormatter();
            }
            return DTP;
        }

        private static DateTimeFormatter dateOptionalTimeParser() {
            if (DOTP == null) {
                DateTimeParser timeOrOffset = new DateTimeFormatterBuilder().appendLiteral('T').appendOptional(Constants.timeElementParser().getParser()).appendOptional(Constants.offsetElement().getParser()).toParser();
                return new DateTimeFormatterBuilder().append(Constants.dateElementParser()).appendOptional(timeOrOffset).toFormatter();
            }
            return DOTP;
        }

        private static DateTimeFormatter localDateOptionalTimeParser() {
            if (LDOTP == null) {
                DateTimeParser time = new DateTimeFormatterBuilder().appendLiteral('T').append(Constants.timeElementParser()).toParser();
                return new DateTimeFormatterBuilder().append(Constants.dateElementParser()).appendOptional(time).toFormatter().withZoneUTC();
            }
            return LDOTP;
        }

        private static DateTimeFormatter time() {
            if (T == null) {
                return new DateTimeFormatterBuilder().append(Constants.hourMinuteSecondFraction()).append(Constants.offsetElement()).toFormatter();
            }
            return T;
        }

        private static DateTimeFormatter timeNoMillis() {
            if (TX == null) {
                return new DateTimeFormatterBuilder().append(Constants.hourMinuteSecond()).append(Constants.offsetElement()).toFormatter();
            }
            return TX;
        }

        private static DateTimeFormatter tTime() {
            if (TT == null) {
                return new DateTimeFormatterBuilder().append(Constants.literalTElement()).append(Constants.time()).toFormatter();
            }
            return TT;
        }

        private static DateTimeFormatter tTimeNoMillis() {
            if (TTX == null) {
                return new DateTimeFormatterBuilder().append(Constants.literalTElement()).append(Constants.timeNoMillis()).toFormatter();
            }
            return TTX;
        }

        private static DateTimeFormatter dateTime() {
            if (DT == null) {
                return new DateTimeFormatterBuilder().append(StrictISODateTimeFormat.date()).append(Constants.tTime()).toFormatter();
            }
            return DT;
        }

        private static DateTimeFormatter dateTimeNoMillis() {
            if (DTX == null) {
                return new DateTimeFormatterBuilder().append(StrictISODateTimeFormat.date()).append(Constants.tTimeNoMillis()).toFormatter();
            }
            return DTX;
        }

        private static DateTimeFormatter ordinalDate() {
            if (OD == null) {
                return new DateTimeFormatterBuilder().append(Constants.yearElement()).append(Constants.dayOfYearElement()).toFormatter();
            }
            return OD;
        }

        private static DateTimeFormatter ordinalDateTime() {
            if (ODT == null) {
                return new DateTimeFormatterBuilder().append(Constants.ordinalDate()).append(Constants.tTime()).toFormatter();
            }
            return ODT;
        }

        private static DateTimeFormatter ordinalDateTimeNoMillis() {
            if (ODTX == null) {
                return new DateTimeFormatterBuilder().append(Constants.ordinalDate()).append(Constants.tTimeNoMillis()).toFormatter();
            }
            return ODTX;
        }

        private static DateTimeFormatter weekDateTime() {
            if (WDT == null) {
                return new DateTimeFormatterBuilder().append(StrictISODateTimeFormat.weekDate()).append(Constants.tTime()).toFormatter();
            }
            return WDT;
        }

        private static DateTimeFormatter weekDateTimeNoMillis() {
            if (WDTX == null) {
                return new DateTimeFormatterBuilder().append(StrictISODateTimeFormat.weekDate()).append(Constants.tTimeNoMillis()).toFormatter();
            }
            return WDTX;
        }

        private static DateTimeFormatter basicDate() {
            if (BD == null) {
                return new DateTimeFormatterBuilder().appendYear(4, 4).appendFixedDecimal(DateTimeFieldType.monthOfYear(), 2).appendFixedDecimal(DateTimeFieldType.dayOfMonth(), 2).toFormatter();
            }
            return BD;
        }

        private static DateTimeFormatter basicTime() {
            if (BT == null) {
                return new DateTimeFormatterBuilder().appendFixedDecimal(DateTimeFieldType.hourOfDay(), 2).appendFixedDecimal(DateTimeFieldType.minuteOfHour(), 2).appendFixedDecimal(DateTimeFieldType.secondOfMinute(), 2).appendLiteral('.').appendFractionOfSecond(3, 9).appendTimeZoneOffset("Z", false, 2, 2).toFormatter();
            }
            return BT;
        }

        private static DateTimeFormatter basicTimeNoMillis() {
            if (BTX == null) {
                return new DateTimeFormatterBuilder().appendFixedDecimal(DateTimeFieldType.hourOfDay(), 2).appendFixedDecimal(DateTimeFieldType.minuteOfHour(), 2).appendFixedDecimal(DateTimeFieldType.secondOfMinute(), 2).appendTimeZoneOffset("Z", false, 2, 2).toFormatter();
            }
            return BTX;
        }

        private static DateTimeFormatter basicTTime() {
            if (BTT == null) {
                return new DateTimeFormatterBuilder().append(Constants.literalTElement()).append(Constants.basicTime()).toFormatter();
            }
            return BTT;
        }

        private static DateTimeFormatter basicTTimeNoMillis() {
            if (BTTX == null) {
                return new DateTimeFormatterBuilder().append(Constants.literalTElement()).append(Constants.basicTimeNoMillis()).toFormatter();
            }
            return BTTX;
        }

        private static DateTimeFormatter basicDateTime() {
            if (BDT == null) {
                return new DateTimeFormatterBuilder().append(Constants.basicDate()).append(Constants.basicTTime()).toFormatter();
            }
            return BDT;
        }

        private static DateTimeFormatter basicDateTimeNoMillis() {
            if (BDTX == null) {
                return new DateTimeFormatterBuilder().append(Constants.basicDate()).append(Constants.basicTTimeNoMillis()).toFormatter();
            }
            return BDTX;
        }

        private static DateTimeFormatter basicOrdinalDate() {
            if (BOD == null) {
                return new DateTimeFormatterBuilder().appendYear(4, 4).appendFixedDecimal(DateTimeFieldType.dayOfYear(), 3).toFormatter();
            }
            return BOD;
        }

        private static DateTimeFormatter basicOrdinalDateTime() {
            if (BODT == null) {
                return new DateTimeFormatterBuilder().append(Constants.basicOrdinalDate()).append(Constants.basicTTime()).toFormatter();
            }
            return BODT;
        }

        private static DateTimeFormatter basicOrdinalDateTimeNoMillis() {
            if (BODTX == null) {
                return new DateTimeFormatterBuilder().append(Constants.basicOrdinalDate()).append(Constants.basicTTimeNoMillis()).toFormatter();
            }
            return BODTX;
        }

        private static DateTimeFormatter basicWeekDate() {
            if (BWD == null) {
                return new DateTimeFormatterBuilder().appendFixedSignedDecimal(DateTimeFieldType.weekyear(), 4).appendLiteral('W').appendFixedDecimal(DateTimeFieldType.weekOfWeekyear(), 2).appendFixedDecimal(DateTimeFieldType.dayOfWeek(), 1).toFormatter();
            }
            return BWD;
        }

        private static DateTimeFormatter basicWeekDateTime() {
            if (BWDT == null) {
                return new DateTimeFormatterBuilder().append(Constants.basicWeekDate()).append(Constants.basicTTime()).toFormatter();
            }
            return BWDT;
        }

        private static DateTimeFormatter basicWeekDateTimeNoMillis() {
            if (BWDTX == null) {
                return new DateTimeFormatterBuilder().append(Constants.basicWeekDate()).append(Constants.basicTTimeNoMillis()).toFormatter();
            }
            return BWDTX;
        }

        private static DateTimeFormatter yearMonth() {
            if (YM == null) {
                return new DateTimeFormatterBuilder().append(Constants.yearElement()).append(Constants.monthElement()).toFormatter();
            }
            return YM;
        }

        private static DateTimeFormatter yearMonthDay() {
            if (YMD == null) {
                return new DateTimeFormatterBuilder().append(Constants.yearElement()).append(Constants.monthElement()).append(Constants.dayOfMonthElement()).toFormatter();
            }
            return YMD;
        }

        private static DateTimeFormatter weekyearWeek() {
            if (WW == null) {
                return new DateTimeFormatterBuilder().append(Constants.weekyearElement()).append(Constants.weekElement()).toFormatter();
            }
            return WW;
        }

        private static DateTimeFormatter weekyearWeekDay() {
            if (WWD == null) {
                return new DateTimeFormatterBuilder().append(Constants.weekyearElement()).append(Constants.weekElement()).append(Constants.dayOfWeekElement()).toFormatter();
            }
            return WWD;
        }

        private static DateTimeFormatter hourMinute() {
            if (HM == null) {
                return new DateTimeFormatterBuilder().append(Constants.hourElement()).append(Constants.minuteElement()).toFormatter();
            }
            return HM;
        }

        private static DateTimeFormatter hourMinuteSecond() {
            if (HMS == null) {
                return new DateTimeFormatterBuilder().append(Constants.hourElement()).append(Constants.minuteElement()).append(Constants.secondElement()).toFormatter();
            }
            return HMS;
        }

        private static DateTimeFormatter hourMinuteSecondMillis() {
            if (HMSL == null) {
                return new DateTimeFormatterBuilder().append(Constants.hourElement()).append(Constants.minuteElement()).append(Constants.secondElement()).appendLiteral('.').appendFractionOfSecond(3, 3).toFormatter();
            }
            return HMSL;
        }

        private static DateTimeFormatter hourMinuteSecondFraction() {
            if (HMSF == null) {
                return new DateTimeFormatterBuilder().append(Constants.hourElement()).append(Constants.minuteElement()).append(Constants.secondElement()).append(Constants.fractionElement()).toFormatter();
            }
            return HMSF;
        }

        private static DateTimeFormatter dateHour() {
            if (DH == null) {
                return new DateTimeFormatterBuilder().append(StrictISODateTimeFormat.date()).append(Constants.literalTElement()).append(StrictISODateTimeFormat.hour()).toFormatter();
            }
            return DH;
        }

        private static DateTimeFormatter dateHourMinute() {
            if (DHM == null) {
                return new DateTimeFormatterBuilder().append(StrictISODateTimeFormat.date()).append(Constants.literalTElement()).append(Constants.hourMinute()).toFormatter();
            }
            return DHM;
        }

        private static DateTimeFormatter dateHourMinuteSecond() {
            if (DHMS == null) {
                return new DateTimeFormatterBuilder().append(StrictISODateTimeFormat.date()).append(Constants.literalTElement()).append(Constants.hourMinuteSecond()).toFormatter();
            }
            return DHMS;
        }

        private static DateTimeFormatter dateHourMinuteSecondMillis() {
            if (DHMSL == null) {
                return new DateTimeFormatterBuilder().append(StrictISODateTimeFormat.date()).append(Constants.literalTElement()).append(Constants.hourMinuteSecondMillis()).toFormatter();
            }
            return DHMSL;
        }

        private static DateTimeFormatter dateHourMinuteSecondFraction() {
            if (DHMSF == null) {
                return new DateTimeFormatterBuilder().append(StrictISODateTimeFormat.date()).append(Constants.literalTElement()).append(Constants.hourMinuteSecondFraction()).toFormatter();
            }
            return DHMSF;
        }

        private static DateTimeFormatter yearElement() {
            if (YE == null) {
                return new DateTimeFormatterBuilder().appendFixedSignedDecimal(DateTimeFieldType.year(), 4).toFormatter();
            }
            return YE;
        }

        private static DateTimeFormatter monthElement() {
            if (MYE == null) {
                return new DateTimeFormatterBuilder().appendLiteral('-').appendFixedSignedDecimal(DateTimeFieldType.monthOfYear(), 2).toFormatter();
            }
            return MYE;
        }

        private static DateTimeFormatter dayOfMonthElement() {
            if (DME == null) {
                return new DateTimeFormatterBuilder().appendLiteral('-').appendFixedSignedDecimal(DateTimeFieldType.dayOfMonth(), 2).toFormatter();
            }
            return DME;
        }

        private static DateTimeFormatter weekyearElement() {
            if (WE == null) {
                return new DateTimeFormatterBuilder().appendFixedSignedDecimal(DateTimeFieldType.weekyear(), 4).toFormatter();
            }
            return WE;
        }

        private static DateTimeFormatter weekElement() {
            if (WWE == null) {
                return new DateTimeFormatterBuilder().appendLiteral("-W").appendFixedSignedDecimal(DateTimeFieldType.weekOfWeekyear(), 2).toFormatter();
            }
            return WWE;
        }

        private static DateTimeFormatter dayOfWeekElement() {
            if (DWE == null) {
                return new DateTimeFormatterBuilder().appendLiteral('-').appendDayOfWeek(1).toFormatter();
            }
            return DWE;
        }

        private static DateTimeFormatter dayOfYearElement() {
            if (DYE == null) {
                return new DateTimeFormatterBuilder().appendLiteral('-').appendFixedSignedDecimal(DateTimeFieldType.dayOfYear(), 3).toFormatter();
            }
            return DYE;
        }

        private static DateTimeFormatter literalTElement() {
            if (LTE == null) {
                return new DateTimeFormatterBuilder().appendLiteral('T').toFormatter();
            }
            return LTE;
        }

        private static DateTimeFormatter hourElement() {
            if (HDE == null) {
                return new DateTimeFormatterBuilder().appendFixedSignedDecimal(DateTimeFieldType.hourOfDay(), 2).toFormatter();
            }
            return HDE;
        }

        private static DateTimeFormatter minuteElement() {
            if (MHE == null) {
                return new DateTimeFormatterBuilder().appendLiteral(':').appendFixedSignedDecimal(DateTimeFieldType.minuteOfHour(), 2).toFormatter();
            }
            return MHE;
        }

        private static DateTimeFormatter secondElement() {
            if (SME == null) {
                return new DateTimeFormatterBuilder().appendLiteral(':').appendFixedSignedDecimal(DateTimeFieldType.secondOfMinute(), 2).toFormatter();
            }
            return SME;
        }

        private static DateTimeFormatter fractionElement() {
            if (FSE == null) {
                return new DateTimeFormatterBuilder().appendLiteral('.').appendFractionOfSecond(3, 9).toFormatter();
            }
            return FSE;
        }

        private static DateTimeFormatter offsetElement() {
            if (ZE == null) {
                return new DateTimeFormatterBuilder().appendTimeZoneOffset("Z", true, 2, 4).toFormatter();
            }
            return ZE;
        }
    }
}

