/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.crate.concurrent.CompletableContext;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.transport.TcpServerChannel;

public class Netty4TcpServerChannel
implements TcpServerChannel {
    private final Channel channel;
    private final String profile;
    private final CompletableContext<Void> closeContext = new CompletableContext();

    Netty4TcpServerChannel(Channel channel, String profile) {
        this.channel = channel;
        this.profile = profile;
        this.channel.closeFuture().addListener(f -> {
            if (f.isSuccess()) {
                this.closeContext.complete(null);
            } else {
                Throwable cause = f.cause();
                if (cause instanceof Error) {
                    ExceptionsHelper.maybeDieOnAnotherThread(cause);
                    this.closeContext.completeExceptionally(new Exception(cause));
                } else {
                    this.closeContext.completeExceptionally((Exception)cause);
                }
            }
        });
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    @Override
    public void close() {
        this.channel.close();
    }

    @Override
    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(ActionListener.toBiConsumer(listener));
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public String toString() {
        return "Netty4TcpChannel{localAddress=" + this.getLocalAddress() + "}";
    }
}

