/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.crate.concurrent.CompletableContext;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4TcpChannel
implements TcpChannel {
    private final Channel channel;
    private final boolean isServer;
    private final String profile;
    private final CompletableContext<Void> connectContext;
    private final CompletableFuture<Void> closeContext = new CompletableFuture();
    private final TcpChannel.ChannelStats stats = new TcpChannel.ChannelStats();

    Netty4TcpChannel(Channel channel, boolean isServer, String profile, @Nullable ChannelFuture connectFuture) {
        this.channel = channel;
        this.isServer = isServer;
        this.profile = profile;
        this.connectContext = new CompletableContext();
        this.channel.closeFuture().addListener(f -> {
            if (f.isSuccess()) {
                this.closeContext.complete(null);
            } else {
                Throwable cause = f.cause();
                if (cause instanceof Error) {
                    ExceptionsHelper.maybeDieOnAnotherThread(cause);
                    this.closeContext.completeExceptionally(cause);
                } else {
                    this.closeContext.completeExceptionally(cause);
                }
            }
        });
        connectFuture.addListener(f -> {
            if (f.isSuccess()) {
                this.connectContext.complete(null);
            } else {
                Throwable cause = f.cause();
                if (cause instanceof Error) {
                    ExceptionsHelper.maybeDieOnAnotherThread(cause);
                    this.connectContext.completeExceptionally(new Exception(cause));
                } else {
                    this.connectContext.completeExceptionally((Exception)cause);
                }
            }
        });
    }

    @Override
    public void close() {
        this.channel.close();
    }

    @Override
    public boolean isServerChannel() {
        return this.isServer;
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.whenComplete((BiConsumer)ActionListener.toBiConsumer(listener));
    }

    @Override
    public void addConnectListener(ActionListener<Void> listener) {
        this.connectContext.addListener(ActionListener.toBiConsumer(listener));
    }

    @Override
    public TcpChannel.ChannelStats getChannelStats() {
        return this.stats;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    @Override
    public void sendMessage(BytesReference reference, ActionListener<Void> listener) {
        ChannelPromise writePromise = this.channel.newPromise();
        writePromise.addListener(f -> {
            if (f.isSuccess()) {
                listener.onResponse(null);
            } else {
                Throwable cause = f.cause();
                ExceptionsHelper.maybeDieOnAnotherThread(cause);
                assert (cause instanceof Exception);
                listener.onFailure((Exception)cause);
            }
        });
        this.channel.writeAndFlush((Object)Netty4Utils.toByteBuf(reference), writePromise);
        if (this.channel.eventLoop().isShutdown()) {
            listener.onFailure(new TransportException("Cannot send message, event loop is shutting down."));
        }
    }

    public String toString() {
        return "Netty4TcpChannel{localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.channel.remoteAddress() + "}";
    }
}

