/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.Version;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.transport.OutboundHandler;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseOptions;

public final class TcpTransportChannel
implements TransportChannel {
    private final OutboundHandler outboundHandler;
    private final TcpChannel channel;
    private final String action;
    private final long requestId;
    private final Version version;
    private final CircuitBreakerService breakerService;
    private final long reservedBytes;
    private final AtomicBoolean released = new AtomicBoolean();
    private Exception releaseBy;

    TcpTransportChannel(OutboundHandler outboundHandler, TcpChannel channel, String action, long requestId, Version version, CircuitBreakerService breakerService, long reservedBytes, boolean compressResponse) {
        this.version = version;
        this.channel = channel;
        this.outboundHandler = outboundHandler;
        this.action = action;
        this.requestId = requestId;
        this.breakerService = breakerService;
        this.reservedBytes = reservedBytes;
    }

    @Override
    public String getProfileName() {
        return this.channel.getProfile();
    }

    @Override
    public void sendResponse(TransportResponse response) throws IOException {
        this.sendResponse(response, TransportResponseOptions.EMPTY);
    }

    @Override
    public void sendResponse(TransportResponse response, TransportResponseOptions options) throws IOException {
        try {
            this.outboundHandler.sendResponse(this.version, this.channel, this.requestId, this.action, response, options.compress(), false);
        }
        finally {
            this.release(false);
        }
    }

    @Override
    public void sendResponse(Exception exception) throws IOException {
        try {
            this.outboundHandler.sendErrorResponse(this.version, this.channel, this.requestId, this.action, exception);
        }
        finally {
            this.release(true);
        }
    }

    private void release(boolean isExceptionResponse) {
        if (this.released.compareAndSet(false, true)) {
            this.breakerService.getBreaker("in_flight_requests").addWithoutBreaking(-this.reservedBytes);
        } else if (!isExceptionResponse) {
            throw new IllegalStateException("reserved bytes are already released", this.releaseBy);
        }
    }

    @Override
    public String getChannelType() {
        return "transport";
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public TcpChannel getChannel() {
        return this.channel;
    }
}

