/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import org.elasticsearch.Version;
import org.elasticsearch.transport.TransportStatus;

public abstract class NetworkMessage {
    protected final Version version;
    protected final long requestId;
    protected final byte status;

    NetworkMessage(Version version, byte status, long requestId) {
        this.version = version;
        this.requestId = requestId;
        this.status = status;
    }

    public Version getVersion() {
        return this.version;
    }

    public long getRequestId() {
        return this.requestId;
    }

    boolean isCompress() {
        return TransportStatus.isCompress(this.status);
    }

    boolean isResponse() {
        return !TransportStatus.isRequest(this.status);
    }

    boolean isRequest() {
        return TransportStatus.isRequest(this.status);
    }

    boolean isHandshake() {
        return TransportStatus.isHandshake(this.status);
    }

    boolean isError() {
        return TransportStatus.isError(this.status);
    }
}

