/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import io.crate.common.io.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.compress.NotCompressedException;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.transport.NetworkMessage;
import org.elasticsearch.transport.TransportStatus;

public abstract class InboundMessage
extends NetworkMessage
implements Closeable {
    private final StreamInput streamInput;

    InboundMessage(Version version, byte status, long requestId, StreamInput streamInput) {
        super(version, status, requestId);
        this.streamInput = streamInput;
    }

    StreamInput getStreamInput() {
        return this.streamInput;
    }

    @Override
    public void close() throws IOException {
        this.streamInput.close();
    }

    private static void ensureVersionCompatibility(Version version, Version currentVersion, boolean isHandshake) {
        Version compatibilityVersion;
        Version version2 = compatibilityVersion = isHandshake ? currentVersion.minimumCompatibilityVersion() : currentVersion;
        if (!version.isCompatible(compatibilityVersion)) {
            Version minCompatibilityVersion = isHandshake ? compatibilityVersion : compatibilityVersion.minimumCompatibilityVersion();
            String msg = "Received " + (isHandshake ? "handshake " : "") + "message from unsupported version: [";
            throw new IllegalStateException(msg + version + "] minimal compatible version is: [" + minCompatibilityVersion + "]");
        }
    }

    public static class Response
    extends InboundMessage {
        Response(Version version, byte status, long requestId, StreamInput streamInput) {
            super(version, status, requestId, streamInput);
        }
    }

    public static class Request
    extends InboundMessage {
        private final String actionName;

        Request(Version version, byte status, long requestId, String actionName, StreamInput streamInput) {
            super(version, status, requestId, streamInput);
            this.actionName = actionName;
        }

        String getActionName() {
            return this.actionName;
        }
    }

    static class Reader {
        private final Version version;
        private final NamedWriteableRegistry namedWriteableRegistry;

        Reader(Version version, NamedWriteableRegistry namedWriteableRegistry) {
            this.version = version;
            this.namedWriteableRegistry = namedWriteableRegistry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InboundMessage deserialize(BytesReference reference) throws IOException {
            Response response;
            block10: {
                int messageLengthBytes = reference.length();
                int totalMessageSize = messageLengthBytes + 2 + 4;
                boolean hasMessageBytesToRead = totalMessageSize - 19 > 0;
                StreamInput streamInput = reference.streamInput();
                boolean success = false;
                try {
                    InboundMessage message;
                    long requestId = streamInput.readLong();
                    byte status = streamInput.readByte();
                    Version remoteVersion = Version.fromId(streamInput.readInt());
                    boolean isHandshake = TransportStatus.isHandshake(status);
                    InboundMessage.ensureVersionCompatibility(remoteVersion, this.version, isHandshake);
                    if (TransportStatus.isCompress(status) && hasMessageBytesToRead && streamInput.available() > 0) {
                        Compressor compressor;
                        try {
                            int bytesConsumed = 13;
                            compressor = CompressorFactory.compressor(reference.slice(13, reference.length() - 13));
                        }
                        catch (NotCompressedException ex) {
                            int maxToRead = Math.min(reference.length(), 10);
                            StringBuilder sb = new StringBuilder("stream marked as compressed, but no compressor found, first [").append(maxToRead).append("] content bytes out of [").append(reference.length()).append("] readable bytes with message size [").append(messageLengthBytes).append("] ").append("] are [");
                            for (int i = 0; i < maxToRead; ++i) {
                                sb.append(reference.get(i)).append(",");
                            }
                            sb.append("]");
                            throw new IllegalStateException(sb.toString());
                        }
                        streamInput = compressor.streamInput(streamInput);
                    }
                    streamInput = new NamedWriteableAwareStreamInput(streamInput, this.namedWriteableRegistry);
                    streamInput.setVersion(remoteVersion);
                    ThreadContext.bwcReadHeaders(streamInput);
                    if (TransportStatus.isRequest(status)) {
                        if (remoteVersion.before(Version.V_4_3_0)) {
                            streamInput.readStringArray();
                        }
                        String action = streamInput.readString();
                        message = new Request(remoteVersion, status, requestId, action, streamInput);
                    } else {
                        message = new Response(remoteVersion, status, requestId, streamInput);
                    }
                    success = true;
                    response = message;
                    if (success) break block10;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException(streamInput);
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(streamInput);
            }
            return response;
        }
    }
}

