/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import io.crate.common.collections.MapBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.InboundMessage;
import org.elasticsearch.transport.OutboundHandler;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TcpTransportChannel;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportHandshaker;
import org.elasticsearch.transport.TransportKeepAlive;
import org.elasticsearch.transport.TransportMessageListener;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportSerializationException;

public class InboundHandler {
    private static final Logger LOGGER = LogManager.getLogger(InboundHandler.class);
    private final MeanMetric readBytesMetric = new MeanMetric();
    private final ThreadPool threadPool;
    private final OutboundHandler outboundHandler;
    private final CircuitBreakerService circuitBreakerService;
    private final InboundMessage.Reader reader;
    private final TransportHandshaker handshaker;
    private final TransportKeepAlive keepAlive;
    private final Transport.ResponseHandlers responseHandlers = new Transport.ResponseHandlers();
    private volatile Map<String, RequestHandlerRegistry<? extends TransportRequest>> requestHandlers = Collections.emptyMap();
    private volatile TransportMessageListener messageListener = TransportMessageListener.NOOP_LISTENER;

    InboundHandler(ThreadPool threadPool, OutboundHandler outboundHandler, InboundMessage.Reader reader, CircuitBreakerService circuitBreakerService, TransportHandshaker handshaker, TransportKeepAlive keepAlive) {
        this.threadPool = threadPool;
        this.outboundHandler = outboundHandler;
        this.circuitBreakerService = circuitBreakerService;
        this.reader = reader;
        this.handshaker = handshaker;
        this.keepAlive = keepAlive;
    }

    synchronized <Request extends TransportRequest> void registerRequestHandler(RequestHandlerRegistry<Request> reg) {
        if (this.requestHandlers.containsKey(reg.getAction())) {
            throw new IllegalArgumentException("transport handlers for action " + reg.getAction() + " is already registered");
        }
        this.requestHandlers = MapBuilder.newMapBuilder(this.requestHandlers).put(reg.getAction(), reg).immutableMap();
    }

    final <T extends TransportRequest> RequestHandlerRegistry<T> getRequestHandler(String action) {
        return this.requestHandlers.get(action);
    }

    final Transport.ResponseHandlers getResponseHandlers() {
        return this.responseHandlers;
    }

    MeanMetric getReadBytes() {
        return this.readBytesMetric;
    }

    void setMessageListener(TransportMessageListener listener) {
        if (this.messageListener != TransportMessageListener.NOOP_LISTENER) {
            throw new IllegalStateException("Cannot set message listener twice");
        }
        this.messageListener = listener;
    }

    void inboundMessage(TcpChannel channel, BytesReference message) throws Exception {
        channel.getChannelStats().markAccessed(this.threadPool.relativeTimeInMillis());
        this.readBytesMetric.inc(message.length() + 2 + 4);
        if (message.length() != 0) {
            this.messageReceived(message, channel);
        } else {
            this.keepAlive.receiveKeepAlive(channel);
        }
    }

    private void messageReceived(BytesReference reference, TcpChannel channel) throws IOException {
        InetSocketAddress remoteAddress = channel.getRemoteAddress();
        try (InboundMessage message = this.reader.deserialize(reference);){
            if (message.isRequest()) {
                this.handleRequest(channel, (InboundMessage.Request)message, reference.length());
            } else {
                TransportResponseHandler<TransportHandshaker.HandshakeResponse> theHandler;
                long requestId = message.getRequestId();
                TransportResponseHandler<TransportHandshaker.HandshakeResponse> handler = message.isHandshake() ? this.handshaker.removeHandlerForHandshake(requestId) : ((theHandler = this.responseHandlers.onResponseReceived(requestId, this.messageListener)) == null && message.isError() ? this.handshaker.removeHandlerForHandshake(requestId) : theHandler);
                if (handler != null) {
                    if (message.isError()) {
                        this.handlerResponseError(message.getStreamInput(), handler);
                    } else {
                        this.handleResponse(remoteAddress, message.getStreamInput(), handler);
                    }
                    int nextByte = message.getStreamInput().read();
                    if (nextByte != -1) {
                        throw new IllegalStateException("Message not fully read (response) for requestId [" + requestId + "], handler [" + handler + "], error [" + message.isError() + "]; resetting");
                    }
                }
            }
        }
    }

    private <T extends TransportRequest> void handleRequest(TcpChannel channel, InboundMessage.Request message, int messageLengthBytes) {
        String action = message.getActionName();
        long requestId = message.getRequestId();
        StreamInput stream = message.getStreamInput();
        Version version = message.getVersion();
        TransportChannel transportChannel = null;
        try {
            this.messageListener.onRequestReceived(requestId, action);
            if (message.isHandshake()) {
                this.handshaker.handleHandshake(version, channel, requestId, stream);
            } else {
                RequestHandlerRegistry<T> reg = this.getRequestHandler(action);
                if (reg == null) {
                    throw new ActionNotFoundTransportException(action);
                }
                CircuitBreaker breaker = this.circuitBreakerService.getBreaker("in_flight_requests");
                if (reg.canTripCircuitBreaker()) {
                    breaker.addEstimateBytesAndMaybeBreak(messageLengthBytes, "<transport_request>");
                } else {
                    breaker.addWithoutBreaking(messageLengthBytes);
                }
                transportChannel = new TcpTransportChannel(this.outboundHandler, channel, action, requestId, version, this.circuitBreakerService, messageLengthBytes, message.isCompress());
                T request = reg.newRequest(stream);
                int nextByte = stream.read();
                if (nextByte != -1) {
                    throw new IllegalStateException("Message not fully read (request) for requestId [" + requestId + "], action [" + action + "], available [" + stream.available() + "]; resetting");
                }
                this.threadPool.executor(reg.getExecutor()).execute(new RequestHandler<T>(reg, request, transportChannel));
            }
        }
        catch (Exception e) {
            if (transportChannel == null) {
                transportChannel = new TcpTransportChannel(this.outboundHandler, channel, action, requestId, version, this.circuitBreakerService, 0L, message.isCompress());
            }
            try {
                transportChannel.sendResponse(e);
            }
            catch (IOException inner) {
                inner.addSuppressed(e);
                LOGGER.warn(() -> new ParameterizedMessage("Failed to send error message back to client for action [{}]", (Object)action), (Throwable)inner);
            }
        }
    }

    private <T extends TransportResponse> void handleResponse(InetSocketAddress remoteAddress, StreamInput stream, final TransportResponseHandler<T> handler) {
        Object response;
        try {
            response = handler.read(stream);
        }
        catch (Exception e) {
            this.handleException(handler, new TransportSerializationException("Failed to deserialize response from handler [" + handler.getClass().getName() + "]", e));
            return;
        }
        this.threadPool.executor(handler.executor()).execute(new AbstractRunnable((TransportResponse)response){
            final /* synthetic */ TransportResponse val$response;
            {
                this.val$response = transportResponse;
            }

            @Override
            public void onFailure(Exception e) {
                InboundHandler.this.handleException(handler, new ResponseHandlerFailureTransportException(e));
            }

            @Override
            protected void doRun() {
                handler.handleResponse(this.val$response);
            }
        });
    }

    private void handlerResponseError(StreamInput stream, TransportResponseHandler handler) {
        Object error;
        try {
            error = stream.readException();
        }
        catch (Exception e) {
            error = new TransportSerializationException("Failed to deserialize exception response from stream", e);
        }
        this.handleException(handler, (Throwable)error);
    }

    private void handleException(TransportResponseHandler handler, Throwable error) {
        if (!(error instanceof RemoteTransportException)) {
            error = new RemoteTransportException(error.getMessage(), error);
        }
        RemoteTransportException rtx = (RemoteTransportException)error;
        this.threadPool.executor(handler.executor()).execute(() -> {
            try {
                handler.handleException(rtx);
            }
            catch (Exception e) {
                LOGGER.error(() -> new ParameterizedMessage("failed to handle exception response [{}]", (Object)handler), (Throwable)e);
            }
        });
    }

    private static class RequestHandler<T extends TransportRequest>
    extends AbstractRunnable {
        private final RequestHandlerRegistry<T> reg;
        private final T request;
        private final TransportChannel transportChannel;

        RequestHandler(RequestHandlerRegistry<T> reg, T request, TransportChannel transportChannel) {
            this.reg = reg;
            this.request = request;
            this.transportChannel = transportChannel;
        }

        @Override
        protected void doRun() throws Exception {
            this.reg.processMessageReceived(this.request, this.transportChannel);
        }

        @Override
        public boolean isForceExecution() {
            return this.reg.isForceExecution();
        }

        @Override
        public void onFailure(Exception e) {
            try {
                this.transportChannel.sendResponse(e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                LOGGER.warn(() -> new ParameterizedMessage("Failed to send error message back to client for action [{}]", (Object)this.reg.getAction()), (Throwable)inner);
            }
        }
    }
}

