/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ProfileResult {
    private final String type;
    private final String description;
    private final Map<String, Long> timings;
    private final long nodeTime;
    private final List<ProfileResult> children;

    public ProfileResult(String type, String description, Map<String, Long> timings, List<ProfileResult> children) {
        this.type = type;
        this.description = description;
        this.timings = Objects.requireNonNull(timings, "required timings argument missing");
        this.children = children;
        this.nodeTime = ProfileResult.getTotalTime(timings);
    }

    public String getLuceneDescription() {
        return this.description;
    }

    public String getQueryName() {
        return this.type;
    }

    public Map<String, Long> getTimeBreakdown() {
        return Collections.unmodifiableMap(this.timings);
    }

    public long getTime() {
        return this.nodeTime;
    }

    public List<ProfileResult> getProfiledChildren() {
        return Collections.unmodifiableList(this.children);
    }

    private static long getTotalTime(Map<String, Long> timings) {
        long nodeTime = 0L;
        for (long time : timings.values()) {
            nodeTime += time;
        }
        return nodeTime;
    }
}

