/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Base64;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.NetworkAddress;

public interface DocValueFormat
extends NamedWriteable {
    public static final DocValueFormat RAW = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "raw";
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }

        @Override
        public Long format(long value) {
            return value;
        }

        @Override
        public Double format(double value) {
            return value;
        }

        @Override
        public String format(BytesRef value) {
            return value.utf8ToString();
        }
    };
    public static final DocValueFormat BINARY = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "binary";
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }

        @Override
        public Object format(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object format(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String format(BytesRef value) {
            return Base64.getEncoder().withoutPadding().encodeToString(Arrays.copyOfRange(value.bytes, value.offset, value.offset + value.length));
        }
    };
    public static final DocValueFormat BOOLEAN = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "bool";
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }

        @Override
        public Boolean format(long value) {
            return value != 0L;
        }

        @Override
        public Boolean format(double value) {
            return value != 0.0;
        }

        @Override
        public String format(BytesRef value) {
            throw new UnsupportedOperationException();
        }
    };
    public static final DocValueFormat IP = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "ip";
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }

        @Override
        public String format(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String format(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String format(BytesRef value) {
            byte[] bytes = Arrays.copyOfRange(value.bytes, value.offset, value.offset + value.length);
            InetAddress inet = InetAddressPoint.decode((byte[])bytes);
            return NetworkAddress.format(inet);
        }
    };

    public Object format(long var1);

    public Object format(double var1);

    public Object format(BytesRef var1);
}

