/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.url;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.url.URLBlobStore;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.URIPattern;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.threadpool.ThreadPool;

public class URLRepository
extends BlobStoreRepository {
    private static final Logger LOGGER = LogManager.getLogger(URLRepository.class);
    public static final String TYPE = "url";
    public static final Setting<List<String>> SUPPORTED_PROTOCOLS_SETTING = Setting.listSetting("repositories.url.supported_protocols", Arrays.asList("http", "https", "ftp", "file", "jar"), Function.identity(), Setting.Property.NodeScope);
    public static final Setting<List<URIPattern>> ALLOWED_URLS_SETTING = Setting.listSetting("repositories.url.allowed_urls", Collections.emptyList(), URIPattern::new, Setting.Property.NodeScope);
    public static final Setting<URL> URL_SETTING = new Setting<URL>("url", "http:", URLRepository::parseURL, Setting.Property.NodeScope);
    public static final Setting<URL> REPOSITORIES_URL_SETTING = new Setting<URL>("repositories.url.url", s -> s.get("repositories.uri.url", "http:"), URLRepository::parseURL, Setting.Property.NodeScope);
    private final List<String> supportedProtocols;
    private final URIPattern[] urlWhiteList;
    private final Environment environment;
    private final BlobPath basePath;
    private final URL url;

    public static List<Setting<?>> mandatorySettings() {
        return List.of(URL_SETTING);
    }

    public URLRepository(RepositoryMetadata metadata, Environment environment, NamedXContentRegistry namedXContentRegistry, ThreadPool threadPool) {
        super(metadata, environment.settings(), namedXContentRegistry, threadPool, BlobPath.cleanPath());
        if (!URL_SETTING.exists(metadata.settings()) && !REPOSITORIES_URL_SETTING.exists(environment.settings())) {
            throw new RepositoryException(metadata.name(), "missing url");
        }
        this.environment = environment;
        this.supportedProtocols = SUPPORTED_PROTOCOLS_SETTING.get(environment.settings());
        this.urlWhiteList = ALLOWED_URLS_SETTING.get(environment.settings()).toArray(new URIPattern[0]);
        this.basePath = BlobPath.cleanPath();
        this.url = URL_SETTING.exists(metadata.settings()) ? URL_SETTING.get(metadata.settings()) : REPOSITORIES_URL_SETTING.get(environment.settings());
    }

    @Override
    protected BlobStore createBlobStore() {
        URL normalizedURL = this.checkURL(this.url);
        return new URLBlobStore(this.environment.settings(), normalizedURL);
    }

    @Override
    protected BlobContainer blobContainer() {
        return super.blobContainer();
    }

    @Override
    protected BlobStore getBlobStore() {
        return super.getBlobStore();
    }

    @Override
    public BlobPath basePath() {
        return this.basePath;
    }

    private URL checkURL(URL url) {
        String protocol = url.getProtocol();
        if (protocol == null) {
            throw new RepositoryException(this.getMetadata().name(), "unknown url protocol from URL [" + url + "]");
        }
        for (String supportedProtocol : this.supportedProtocols) {
            if (!supportedProtocol.equals(protocol)) continue;
            try {
                if (URIPattern.match(this.urlWhiteList, url.toURI())) {
                    return url;
                }
            }
            catch (URISyntaxException ex) {
                LOGGER.warn("cannot parse the specified url [{}]", (Object)url);
                throw new RepositoryException(this.getMetadata().name(), "cannot parse the specified url [" + url + "]");
            }
            URL normalizedUrl = this.environment.resolveRepoURL(url);
            if (normalizedUrl == null) {
                String logMessage = "The specified url [{}] doesn't start with any repository paths specified by the path.repo setting or by {} setting: [{}] ";
                LOGGER.warn(logMessage, (Object)url, (Object)ALLOWED_URLS_SETTING.getKey(), (Object)this.environment.repoFiles());
                String exceptionMessage = "file url [" + url + "] doesn't match any of the locations specified by path.repo or " + ALLOWED_URLS_SETTING.getKey();
                throw new RepositoryException(this.getMetadata().name(), exceptionMessage);
            }
            return normalizedUrl;
        }
        throw new RepositoryException(this.getMetadata().name(), "unsupported url protocol [" + protocol + "] from URL [" + url + "]");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    private static URL parseURL(String s) {
        try {
            return new URL(s);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to parse URL repository setting", e);
        }
    }
}

