/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import io.crate.exceptions.InvalidArgumentException;
import java.io.Closeable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.repositories.s3.AmazonS3Reference;
import org.elasticsearch.repositories.s3.S3ClientSettings;

class S3Service
implements Closeable {
    private static final Logger LOGGER = LogManager.getLogger(S3Service.class);
    private volatile AmazonS3Reference clientCache;
    private volatile S3ClientSettings clientSettingsCache;

    S3Service() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmazonS3Reference client(RepositoryMetadata metadata) {
        S3ClientSettings clientSettings = S3ClientSettings.getClientSettings(metadata.settings());
        boolean settingsUpdated = !clientSettings.equals(this.clientSettingsCache);
        S3Service s3Service = this;
        synchronized (s3Service) {
            AmazonS3Reference localClientRef = this.clientCache;
            if (localClientRef != null && !settingsUpdated && localClientRef.tryIncRef()) {
                return localClientRef;
            }
            AmazonS3Reference newClientRef = new AmazonS3Reference(this.buildClient(clientSettings));
            newClientRef.incRef();
            this.clientCache = newClientRef;
            this.clientSettingsCache = clientSettings;
            return newClientRef;
        }
    }

    private AmazonS3 buildClient(S3ClientSettings clientSettings) {
        AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
        builder.withCredentials(S3Service.buildCredentials(LOGGER, clientSettings));
        builder.withClientConfiguration(S3Service.buildConfiguration(clientSettings));
        String endpoint = Strings.hasLength(clientSettings.endpoint) ? clientSettings.endpoint : "s3.amazonaws.com";
        LOGGER.debug("using endpoint [{}]", (Object)endpoint);
        builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, null));
        return (AmazonS3)builder.build();
    }

    static ClientConfiguration buildConfiguration(S3ClientSettings clientSettings) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setResponseMetadataCacheSize(0);
        clientConfiguration.setProtocol(clientSettings.protocol);
        if (Strings.hasText(clientSettings.proxyHost)) {
            clientConfiguration.setProxyHost(clientSettings.proxyHost);
            clientConfiguration.setProxyPort(clientSettings.proxyPort);
            clientConfiguration.setProxyUsername(clientSettings.proxyUsername);
            clientConfiguration.setProxyPassword(clientSettings.proxyPassword);
        }
        clientConfiguration.setMaxErrorRetry(clientSettings.maxRetries);
        clientConfiguration.setUseThrottleRetries(clientSettings.throttleRetries);
        clientConfiguration.setSocketTimeout(clientSettings.readTimeoutMillis);
        return clientConfiguration;
    }

    static AWSCredentialsProvider buildCredentials(Logger logger, S3ClientSettings clientSettings) {
        AWSCredentials credentials = clientSettings.credentials;
        if (credentials == null) {
            logger.debug("Using instance profile credentials");
            EC2ContainerCredentialsProviderWrapper ec2ContainerCredentialsProviderWrapper = new EC2ContainerCredentialsProviderWrapper();
            try {
                ec2ContainerCredentialsProviderWrapper.getCredentials();
                return ec2ContainerCredentialsProviderWrapper;
            }
            catch (SdkClientException e) {
                throw new InvalidArgumentException("Cannot find required credentials to create a repository of type s3. Credentials must be provided either as repository options access_key and secret_key or AWS IAM roles.");
            }
        }
        logger.debug("Using basic key/secret credentials");
        return new AWSStaticCredentialsProvider(credentials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        S3Service s3Service = this;
        synchronized (s3Service) {
            AmazonS3Reference localClientRef = this.clientCache;
            if (localClientRef != null) {
                localClientRef.decRef();
            }
            this.clientCache = null;
            this.clientSettingsCache = null;
        }
        IdleConnectionReaper.shutdown();
    }
}

