/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import io.crate.common.unit.TimeValue;
import java.util.Locale;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.monitor.jvm.JvmInfo;

class S3RepositorySettings {
    static final Setting<Boolean> READONLY_SETTING = Setting.boolSetting("readonly", false, new Setting.Property[0]);
    static final Setting<SecureString> ACCESS_KEY_SETTING = Setting.maskedString("access_key");
    static final Setting<SecureString> SECRET_KEY_SETTING = Setting.maskedString("secret_key");
    private static final ByteSizeValue DEFAULT_BUFFER_SIZE = new ByteSizeValue(Math.max(ByteSizeUnit.MB.toBytes(5L), Math.min(ByteSizeUnit.MB.toBytes(100L), JvmInfo.jvmInfo().getMem().getHeapMax().getBytes() / 20L)), ByteSizeUnit.BYTES);
    static final Setting<String> BUCKET_SETTING = Setting.simpleString("bucket", new Setting.Property[0]);
    static final Setting<Boolean> SERVER_SIDE_ENCRYPTION_SETTING = Setting.boolSetting("server_side_encryption", false, new Setting.Property[0]);
    static final ByteSizeValue MAX_FILE_SIZE = new ByteSizeValue(5L, ByteSizeUnit.GB);
    static final ByteSizeValue MIN_PART_SIZE_USING_MULTIPART = new ByteSizeValue(5L, ByteSizeUnit.MB);
    private static final ByteSizeValue MAX_PART_SIZE_USING_MULTIPART = MAX_FILE_SIZE;
    static final ByteSizeValue MAX_FILE_SIZE_USING_MULTIPART = new ByteSizeValue(5L, ByteSizeUnit.TB);
    static final Setting<ByteSizeValue> BUFFER_SIZE_SETTING = Setting.byteSizeSetting("buffer_size", DEFAULT_BUFFER_SIZE, MIN_PART_SIZE_USING_MULTIPART, MAX_PART_SIZE_USING_MULTIPART, new Setting.Property[0]);
    static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting("chunk_size", new ByteSizeValue(1L, ByteSizeUnit.GB), new ByteSizeValue(5L, ByteSizeUnit.MB), new ByteSizeValue(5L, ByteSizeUnit.TB), new Setting.Property[0]);
    static final Setting<String> STORAGE_CLASS_SETTING = Setting.simpleString("storage_class", new Setting.Property[0]);
    static final Setting<String> CANNED_ACL_SETTING = Setting.simpleString("canned_acl", new Setting.Property[0]);
    static final Setting<String> BASE_PATH_SETTING = Setting.simpleString("base_path", new Setting.Property[0]);
    static final Setting<SecureString> SESSION_TOKEN_SETTING = Setting.maskedString("session_token");
    static final Setting<String> ENDPOINT_SETTING = new Setting<String>("endpoint", "", s -> s.toLowerCase(Locale.ROOT), Setting.Property.NodeScope);
    static final Setting<Protocol> PROTOCOL_SETTING = new Setting<Protocol>("protocol", "https", s -> Protocol.valueOf((String)s.toUpperCase(Locale.ROOT)), Setting.Property.NodeScope);
    static final Setting<String> PROXY_HOST_SETTING = Setting.simpleString("proxy_host", Setting.Property.NodeScope);
    static final Setting<Integer> PROXY_PORT_SETTING = Setting.intSetting("proxy_port", 80, 0, 65536, Setting.Property.NodeScope);
    static final Setting<SecureString> PROXY_USERNAME_SETTING = Setting.maskedString("proxy_username");
    static final Setting<SecureString> PROXY_PASSWORD_SETTING = Setting.maskedString("proxy_password");
    static final Setting<TimeValue> READ_TIMEOUT_SETTING = Setting.timeSetting("read_timeout", TimeValue.timeValueMillis(50000L), Setting.Property.NodeScope);
    static final Setting<Integer> MAX_RETRIES_SETTING = Setting.intSetting("max_retries", ClientConfiguration.DEFAULT_RETRY_POLICY.getMaxErrorRetry(), 0, Setting.Property.NodeScope);
    static final Setting<Boolean> USE_THROTTLE_RETRIES_SETTING = Setting.boolSetting("use_throttle_retries", true, Setting.Property.NodeScope);

    S3RepositorySettings() {
    }
}

