/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.util.json.Jackson;
import io.crate.analyze.repositories.TypeSettings;
import java.security.AccessController;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.s3.S3Repository;
import org.elasticsearch.repositories.s3.S3RepositorySettings;
import org.elasticsearch.repositories.s3.S3Service;
import org.elasticsearch.threadpool.ThreadPool;

public class S3RepositoryPlugin
extends Plugin
implements RepositoryPlugin {
    protected final S3Service service = new S3Service();

    @Override
    public List<Setting<?>> getSettings() {
        return List.of(S3RepositorySettings.ACCESS_KEY_SETTING, S3RepositorySettings.SECRET_KEY_SETTING);
    }

    @Override
    public Map<String, Repository.Factory> getRepositories(final Environment env, final NamedXContentRegistry registry, final ThreadPool threadPool) {
        return Collections.singletonMap("s3", new Repository.Factory(){

            @Override
            public TypeSettings settings() {
                return new TypeSettings(List.of(), S3Repository.optionalSettings());
            }

            @Override
            public Repository create(RepositoryMetadata metadata) throws Exception {
                return new S3Repository(metadata, env.settings(), registry, S3RepositoryPlugin.this.service, threadPool);
            }
        });
    }

    @Override
    public void close() {
        this.service.close();
    }

    static {
        AccessController.doPrivileged(() -> {
            try {
                Jackson.jsonNodeOf((String)"{}");
                Class.forName("com.amazonaws.ClientConfiguration");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }
}

