/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.fs;

import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.fs.FsBlobStore;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.threadpool.ThreadPool;

public class FsRepository
extends BlobStoreRepository {
    private static final Logger LOGGER = LogManager.getLogger(FsRepository.class);
    public static final String TYPE = "fs";
    public static final Setting<String> LOCATION_SETTING = new Setting("location", "", Function.identity(), Setting.Property.NodeScope);
    public static final Setting<String> REPOSITORIES_LOCATION_SETTING = new Setting<String>("repositories.fs.location", LOCATION_SETTING, Function.identity(), Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting("chunk_size", new ByteSizeValue(Long.MAX_VALUE), new ByteSizeValue(5L), new ByteSizeValue(Long.MAX_VALUE), Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> REPOSITORIES_CHUNK_SIZE_SETTING = Setting.byteSizeSetting("repositories.fs.chunk_size", new ByteSizeValue(Long.MAX_VALUE), new ByteSizeValue(5L), new ByteSizeValue(Long.MAX_VALUE), Setting.Property.NodeScope);
    static final Setting<Boolean> READONLY_SETTING = Setting.boolSetting("readonly", false, Setting.Property.NodeScope);
    private final Environment environment;
    private final ByteSizeValue chunkSize;
    private final BlobPath basePath;

    public static List<Setting<?>> mandatorySettings() {
        return List.of(LOCATION_SETTING);
    }

    public static List<Setting<?>> optionalSettings() {
        return List.of(COMPRESS_SETTING, CHUNK_SIZE_SETTING, READONLY_SETTING);
    }

    public FsRepository(RepositoryMetadata metadata, Environment environment, NamedXContentRegistry namedXContentRegistry, ThreadPool threadPool) {
        super(metadata, environment.settings(), namedXContentRegistry, threadPool, BlobPath.cleanPath());
        this.environment = environment;
        String location = REPOSITORIES_LOCATION_SETTING.get(metadata.settings());
        if (location.isEmpty()) {
            LOGGER.warn("the repository location is missing, it should point to a shared file system location that is available on all master and data nodes");
            throw new RepositoryException(metadata.name(), "missing location");
        }
        Path locationFile = environment.resolveRepoFile(location);
        if (locationFile == null) {
            if (environment.repoFiles().length > 0) {
                LOGGER.warn("The specified location [{}] doesn't start with any repository paths specified by the path.repo setting: [{}] ", (Object)location, (Object)environment.repoFiles());
                throw new RepositoryException(metadata.name(), "location [" + location + "] doesn't match any of the locations specified by path.repo");
            }
            LOGGER.warn("The specified location [{}] should start with a repository path specified by the path.repo setting, but the path.repo setting was not set on this node", (Object)location);
            throw new RepositoryException(metadata.name(), "location [" + location + "] doesn't match any of the locations specified by path.repo because this setting is empty");
        }
        this.chunkSize = CHUNK_SIZE_SETTING.exists(metadata.settings()) ? CHUNK_SIZE_SETTING.get(metadata.settings()) : REPOSITORIES_CHUNK_SIZE_SETTING.get(environment.settings());
        this.basePath = BlobPath.cleanPath();
    }

    @Override
    protected BlobStore createBlobStore() throws Exception {
        String location = REPOSITORIES_LOCATION_SETTING.get(this.metadata.settings());
        Path locationFile = this.environment.resolveRepoFile(location);
        return new FsBlobStore(this.environment.settings(), locationFile);
    }

    @Override
    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    @Override
    public BlobPath basePath() {
        return this.basePath;
    }
}

