/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import io.crate.common.collections.Tuple;
import io.crate.exceptions.InvalidArgumentException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RateLimiter;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetadata;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.fs.FsBlobContainer;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.store.InputStreamIndexInput;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshots;
import org.elasticsearch.index.snapshots.blobstore.RateLimitingInputStream;
import org.elasticsearch.index.snapshots.blobstore.SlicedInputStream;
import org.elasticsearch.index.snapshots.blobstore.SnapshotFiles;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryVerificationException;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.blobstore.ChecksumBlobStoreFormat;
import org.elasticsearch.repositories.blobstore.FileRestoreContext;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class BlobStoreRepository
extends AbstractLifecycleComponent
implements Repository {
    private static final Logger LOGGER = LogManager.getLogger(BlobStoreRepository.class);
    protected final RepositoryMetadata metadata;
    protected final ThreadPool threadPool;
    private static final int BUFFER_SIZE = 4096;
    private static final String SNAPSHOT_PREFIX = "snap-";
    private static final String SNAPSHOT_CODEC = "snapshot";
    private static final String INDEX_FILE_PREFIX = "index-";
    private static final String INDEX_LATEST_BLOB = "index.latest";
    private static final String TESTS_FILE = "tests-";
    public static final String METADATA_PREFIX = "meta-";
    public static final String METADATA_NAME_FORMAT = "meta-%s.dat";
    private static final String METADATA_CODEC = "metadata";
    private static final String INDEX_METADATA_CODEC = "index-metadata";
    private static final String SNAPSHOT_NAME_FORMAT = "snap-%s.dat";
    private static final String SNAPSHOT_INDEX_PREFIX = "index-";
    private static final String SNAPSHOT_INDEX_NAME_FORMAT = "index-%s";
    private static final String SNAPSHOT_INDEX_CODEC = "snapshots";
    private static final String DATA_BLOB_PREFIX = "__";
    public static final Setting<Boolean> COMPRESS_SETTING = Setting.boolSetting("compress", true, Setting.Property.NodeScope);
    private final Settings settings;
    private final boolean compress;
    private final RateLimiter snapshotRateLimiter;
    private final RateLimiter restoreRateLimiter;
    private final CounterMetric snapshotRateLimitingTimeInNanos = new CounterMetric();
    private final CounterMetric restoreRateLimitingTimeInNanos = new CounterMetric();
    private final ChecksumBlobStoreFormat<Metadata> globalMetadataFormat;
    private final ChecksumBlobStoreFormat<IndexMetadata> indexMetadataFormat;
    private final ChecksumBlobStoreFormat<SnapshotInfo> snapshotFormat;
    private final boolean readOnly;
    private final ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshot> indexShardSnapshotFormat;
    private final ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshots> indexShardSnapshotsFormat;
    private final Object lock = new Object();
    private final SetOnce<BlobContainer> blobContainer = new SetOnce();
    private final SetOnce<BlobStore> blobStore = new SetOnce();
    private final BlobPath basePath;

    protected BlobStoreRepository(RepositoryMetadata metadata, Settings settings, NamedXContentRegistry namedXContentRegistry, ThreadPool threadPool, BlobPath basePath) {
        this.settings = settings;
        this.metadata = metadata;
        this.threadPool = threadPool;
        this.compress = COMPRESS_SETTING.get(metadata.settings());
        this.snapshotRateLimiter = this.getRateLimiter(metadata.settings(), "max_snapshot_bytes_per_sec", new ByteSizeValue(40L, ByteSizeUnit.MB));
        this.restoreRateLimiter = this.getRateLimiter(metadata.settings(), "max_restore_bytes_per_sec", new ByteSizeValue(40L, ByteSizeUnit.MB));
        this.readOnly = metadata.settings().getAsBoolean("readonly", false);
        this.basePath = basePath;
        this.indexShardSnapshotFormat = new ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshot>(SNAPSHOT_CODEC, SNAPSHOT_NAME_FORMAT, BlobStoreIndexShardSnapshot::fromXContent, namedXContentRegistry, this.compress);
        this.indexShardSnapshotsFormat = new ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshots>(SNAPSHOT_INDEX_CODEC, SNAPSHOT_INDEX_NAME_FORMAT, BlobStoreIndexShardSnapshots::fromXContent, namedXContentRegistry, this.compress);
        this.globalMetadataFormat = new ChecksumBlobStoreFormat<Metadata>(METADATA_CODEC, METADATA_NAME_FORMAT, Metadata::fromXContent, namedXContentRegistry, this.compress);
        this.indexMetadataFormat = new ChecksumBlobStoreFormat<IndexMetadata>(INDEX_METADATA_CODEC, METADATA_NAME_FORMAT, IndexMetadata::fromXContent, namedXContentRegistry, this.compress);
        this.snapshotFormat = new ChecksumBlobStoreFormat<SnapshotInfo>(SNAPSHOT_CODEC, SNAPSHOT_NAME_FORMAT, SnapshotInfo::fromXContentInternal, namedXContentRegistry, this.compress);
    }

    @Override
    protected void doStart() {
        ByteSizeValue chunkSize = this.chunkSize();
        if (chunkSize != null && chunkSize.getBytes() <= 0L) {
            throw new IllegalArgumentException("the chunk size cannot be negative: [" + chunkSize + "]");
        }
    }

    @Override
    protected void doStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() {
        BlobStore store;
        Object object = this.lock;
        synchronized (object) {
            store = (BlobStore)this.blobStore.get();
        }
        if (store != null) {
            try {
                store.close();
            }
            catch (Exception t) {
                LOGGER.warn("cannot close blob store", (Throwable)t);
            }
        }
    }

    public ThreadPool threadPool() {
        return this.threadPool;
    }

    protected BlobStore getBlobStore() {
        return (BlobStore)this.blobStore.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlobContainer blobContainer() {
        this.assertSnapshotOrGenericThread();
        BlobContainer blobContainer = (BlobContainer)this.blobContainer.get();
        if (blobContainer == null) {
            Object object = this.lock;
            synchronized (object) {
                blobContainer = (BlobContainer)this.blobContainer.get();
                if (blobContainer == null) {
                    blobContainer = this.blobStore().blobContainer(this.basePath());
                    this.blobContainer.set((Object)blobContainer);
                }
            }
        }
        return blobContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobStore blobStore() {
        this.assertSnapshotOrGenericThread();
        BlobStore store = (BlobStore)this.blobStore.get();
        if (store == null) {
            Object object = this.lock;
            synchronized (object) {
                store = (BlobStore)this.blobStore.get();
                if (store == null) {
                    if (!this.lifecycle.started()) {
                        throw new RepositoryException(this.metadata.name(), "repository is not in started state");
                    }
                    try {
                        store = this.createBlobStore();
                    }
                    catch (InvalidArgumentException | RepositoryException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RepositoryException(this.metadata.name(), "cannot create blob store: " + e.getMessage(), e);
                    }
                    this.blobStore.set((Object)store);
                }
            }
        }
        return store;
    }

    protected abstract BlobStore createBlobStore() throws Exception;

    public BlobPath basePath() {
        return this.basePath;
    }

    protected final boolean isCompress() {
        return this.compress;
    }

    protected ByteSizeValue chunkSize() {
        return null;
    }

    @Override
    public RepositoryMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void deleteSnapshot(SnapshotId snapshotId, long repositoryStateId, boolean writeShardGens, ActionListener<Void> listener) {
        if (this.isReadOnly()) {
            listener.onFailure(new RepositoryException(this.metadata.name(), "cannot delete snapshot from a readonly repository"));
        } else {
            try {
                Map<String, BlobMetadata> rootBlobs = this.blobContainer().listBlobs();
                RepositoryData repositoryData = this.getRepositoryData(this.latestGeneration(rootBlobs.keySet()));
                Map<String, BlobContainer> foundIndices = this.blobStore().blobContainer(this.indicesPath()).children();
                this.doDeleteShardSnapshots(snapshotId, repositoryStateId, foundIndices, rootBlobs, repositoryData, writeShardGens, listener);
            }
            catch (Exception ex) {
                listener.onFailure(new RepositoryException(this.metadata.name(), "failed to delete snapshot [" + snapshotId + "]", ex));
            }
        }
    }

    private void doDeleteShardSnapshots(SnapshotId snapshotId, long repositoryStateId, Map<String, BlobContainer> foundIndices, Map<String, BlobMetadata> rootBlobs, RepositoryData repositoryData, boolean writeShardGens, ActionListener<Void> listener) throws IOException {
        if (writeShardGens) {
            StepListener<Collection<ShardSnapshotMetaDeleteResult>> writeShardMetadataAndComputeDeletesStep = new StepListener<Collection<ShardSnapshotMetaDeleteResult>>();
            this.writeUpdatedShardMetadataAndComputeDeletes(snapshotId, repositoryData, true, writeShardMetadataAndComputeDeletesStep);
            StepListener<RepositoryData> writeUpdatedRepoDataStep = new StepListener<RepositoryData>();
            writeShardMetadataAndComputeDeletesStep.whenComplete(deleteResults -> {
                ShardGenerations.Builder builder = ShardGenerations.builder();
                for (ShardSnapshotMetaDeleteResult newGen : deleteResults) {
                    builder.put(newGen.indexId, newGen.shardId, newGen.newGeneration);
                }
                RepositoryData updatedRepoData = repositoryData.removeSnapshot(snapshotId, builder.build());
                this.writeIndexGen(updatedRepoData, repositoryStateId, true);
                writeUpdatedRepoDataStep.onResponse(updatedRepoData);
            }, listener::onFailure);
            writeUpdatedRepoDataStep.whenComplete(updatedRepoData -> {
                GroupedActionListener<Void> afterCleanupsListener = new GroupedActionListener<Void>(ActionListener.wrap(() -> listener.onResponse(null)), 2);
                this.asyncCleanupUnlinkedRootAndIndicesBlobs(foundIndices, rootBlobs, (RepositoryData)updatedRepoData, (ActionListener<Void>)afterCleanupsListener);
                this.asyncCleanupUnlinkedShardLevelBlobs(snapshotId, (Collection)writeShardMetadataAndComputeDeletesStep.result(), afterCleanupsListener);
            }, listener::onFailure);
        } else {
            RepositoryData updatedRepoData2 = repositoryData.removeSnapshot(snapshotId, ShardGenerations.EMPTY);
            this.writeIndexGen(updatedRepoData2, repositoryStateId, false);
            GroupedActionListener<Void> afterCleanupsListener = new GroupedActionListener<Void>(ActionListener.wrap(() -> listener.onResponse(null)), 2);
            this.asyncCleanupUnlinkedRootAndIndicesBlobs(foundIndices, rootBlobs, updatedRepoData2, afterCleanupsListener);
            StepListener<Collection<ShardSnapshotMetaDeleteResult>> writeMetaAndComputeDeletesStep = new StepListener<Collection<ShardSnapshotMetaDeleteResult>>();
            this.writeUpdatedShardMetadataAndComputeDeletes(snapshotId, repositoryData, false, writeMetaAndComputeDeletesStep);
            writeMetaAndComputeDeletesStep.whenComplete(deleteResults -> this.asyncCleanupUnlinkedShardLevelBlobs(snapshotId, (Collection<ShardSnapshotMetaDeleteResult>)deleteResults, (ActionListener<Void>)afterCleanupsListener), afterCleanupsListener::onFailure);
        }
    }

    private void asyncCleanupUnlinkedRootAndIndicesBlobs(Map<String, BlobContainer> foundIndices, Map<String, BlobMetadata> rootBlobs, RepositoryData updatedRepoData, ActionListener<Void> listener) {
        this.threadPool.executor(SNAPSHOT_CODEC).execute(ActionRunnable.wrap(listener, l -> this.cleanupStaleBlobs(foundIndices, rootBlobs, updatedRepoData, ActionListener.map(l, ignored -> null))));
    }

    private void asyncCleanupUnlinkedShardLevelBlobs(SnapshotId snapshotId, Collection<ShardSnapshotMetaDeleteResult> deleteResults, ActionListener<Void> listener) {
        this.threadPool.executor(SNAPSHOT_CODEC).execute(ActionRunnable.wrap(listener, l -> {
            try {
                this.blobContainer().deleteBlobsIgnoringIfNotExists(this.resolveFilesToDelete(snapshotId, deleteResults));
                l.onResponse(null);
            }
            catch (Exception e) {
                LOGGER.warn(() -> new ParameterizedMessage("[{}] Failed to delete some blobs during snapshot delete", (Object)snapshotId), (Throwable)e);
                throw e;
            }
        }));
    }

    private void writeUpdatedShardMetadataAndComputeDeletes(final SnapshotId snapshotId, final RepositoryData oldRepositoryData, final boolean useUUIDs, ActionListener<Collection<ShardSnapshotMetaDeleteResult>> onAllShardsCompleted) {
        Executor executor = this.threadPool.executor(SNAPSHOT_CODEC);
        List<IndexId> indices = oldRepositoryData.indicesToUpdateAfterRemovingSnapshot(snapshotId);
        if (indices.isEmpty()) {
            onAllShardsCompleted.onResponse(Collections.emptyList());
            return;
        }
        GroupedActionListener deleteIndexMetadataListener = new GroupedActionListener(ActionListener.map(onAllShardsCompleted, res -> res.stream().flatMap(Collection::stream).collect(Collectors.toList())), indices.size());
        for (final IndexId indexId : indices) {
            final Set survivingSnapshots = oldRepositoryData.getSnapshots(indexId).stream().filter(id -> !id.equals(snapshotId)).collect(Collectors.toSet());
            executor.execute(ActionRunnable.wrap(deleteIndexMetadataListener, deleteIdxMetaListener -> {
                IndexMetadata indexMetadata;
                try {
                    indexMetadata = this.getSnapshotIndexMetadata(snapshotId, indexId);
                }
                catch (Exception ex) {
                    LOGGER.warn(() -> new ParameterizedMessage("[{}] [{}] failed to read metadata for index", (Object)snapshotId, (Object)indexId.getName()), (Throwable)ex);
                    deleteIdxMetaListener.onResponse(null);
                    return;
                }
                int shardCount = indexMetadata.getNumberOfShards();
                assert (shardCount > 0) : "index did not have positive shard count, get [" + shardCount + "]";
                final GroupedActionListener allShardsListener = new GroupedActionListener(deleteIdxMetaListener, shardCount);
                Index index = indexMetadata.getIndex();
                for (int shardId = 0; shardId < indexMetadata.getNumberOfShards(); ++shardId) {
                    final ShardId shard = new ShardId(index, shardId);
                    executor.execute(new AbstractRunnable(){

                        @Override
                        protected void doRun() throws Exception {
                            BlobStoreIndexShardSnapshots blobStoreIndexShardSnapshots;
                            String newGen;
                            BlobContainer shardContainer = BlobStoreRepository.this.shardContainer(indexId, shard);
                            Set<String> blobs = BlobStoreRepository.getShardBlobs(shard, shardContainer);
                            if (useUUIDs) {
                                newGen = UUIDs.randomBase64UUID();
                                blobStoreIndexShardSnapshots = BlobStoreRepository.this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer, oldRepositoryData.shardGenerations().getShardGen(indexId, shard.getId())).v1();
                            } else {
                                Tuple<BlobStoreIndexShardSnapshots, Long> tuple = BlobStoreRepository.this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer);
                                newGen = Long.toString(tuple.v2() + 1L);
                                blobStoreIndexShardSnapshots = tuple.v1();
                            }
                            allShardsListener.onResponse(BlobStoreRepository.this.deleteFromShardSnapshotMeta(survivingSnapshots, indexId, shard, snapshotId, shardContainer, blobs, blobStoreIndexShardSnapshots, newGen));
                        }

                        @Override
                        public void onFailure(Exception ex) {
                            LOGGER.warn(() -> new ParameterizedMessage("[{}] failed to delete shard data for shard [{}][{}]", new Object[]{snapshotId, indexId.getName(), shard.id()}), (Throwable)ex);
                            allShardsListener.onResponse(null);
                        }
                    });
                }
            }));
        }
    }

    private List<String> resolveFilesToDelete(SnapshotId snapshotId, Collection<ShardSnapshotMetaDeleteResult> deleteResults) {
        String basePath = this.basePath().buildAsString();
        int basePathLen = basePath.length();
        return Stream.concat(deleteResults.stream().flatMap(shardResult -> {
            String shardPath = this.shardContainer(shardResult.indexId, shardResult.shardId).path().buildAsString();
            return shardResult.blobsToDelete.stream().map(blob -> shardPath + blob);
        }), deleteResults.stream().map(shardResult -> shardResult.indexId).distinct().map(indexId -> this.indexContainer((IndexId)indexId).path().buildAsString() + this.globalMetadataFormat.blobName(snapshotId.getUUID()))).map(absolutePath -> {
            assert (absolutePath.startsWith(basePath));
            return absolutePath.substring(basePathLen);
        }).collect(Collectors.toList());
    }

    private void cleanupStaleBlobs(Map<String, BlobContainer> foundIndices, Map<String, BlobMetadata> rootBlobs, RepositoryData newRepoData, ActionListener<Long> listener) {
        GroupedActionListener groupedListener = new GroupedActionListener(ActionListener.wrap(deleteResults -> {
            long deletes = 0L;
            for (Long result : deleteResults) {
                deletes += result.longValue();
            }
            listener.onResponse(deletes);
        }, listener::onFailure), 2);
        Executor executor = this.threadPool.executor(SNAPSHOT_CODEC);
        executor.execute(ActionRunnable.supply(groupedListener, () -> {
            List<String> deletedBlobs = this.cleanupStaleRootFiles(this.staleRootBlobs(newRepoData, rootBlobs.keySet()));
            return deletedBlobs.size();
        }));
        Set survivingIndexIds = newRepoData.getIndices().values().stream().map(IndexId::getId).collect(Collectors.toSet());
        executor.execute(ActionRunnable.supply(groupedListener, () -> this.cleanupStaleIndices(foundIndices, survivingIndexIds)));
    }

    private List<String> staleRootBlobs(RepositoryData repositoryData, Set<String> rootBlobNames) {
        Set allSnapshotIds = repositoryData.getSnapshotIds().stream().map(SnapshotId::getUUID).collect(Collectors.toSet());
        return rootBlobNames.stream().filter(blob -> {
            if (FsBlobContainer.isTempBlobName(blob)) {
                return true;
            }
            if (blob.endsWith(".dat")) {
                String foundUUID;
                if (blob.startsWith(SNAPSHOT_PREFIX)) {
                    foundUUID = blob.substring(SNAPSHOT_PREFIX.length(), blob.length() - ".dat".length());
                    assert (this.snapshotFormat.blobName(foundUUID).equals(blob));
                } else if (blob.startsWith(METADATA_PREFIX)) {
                    foundUUID = blob.substring(METADATA_PREFIX.length(), blob.length() - ".dat".length());
                    assert (this.globalMetadataFormat.blobName(foundUUID).equals(blob));
                } else {
                    return false;
                }
                return !allSnapshotIds.contains(foundUUID);
            }
            return false;
        }).collect(Collectors.toList());
    }

    private List<String> cleanupStaleRootFiles(List<String> blobsToDelete) {
        if (blobsToDelete.isEmpty()) {
            return blobsToDelete;
        }
        try {
            LOGGER.info("[{}] Found stale root level blobs {}. Cleaning them up", (Object)this.metadata.name(), blobsToDelete);
            this.blobContainer().deleteBlobsIgnoringIfNotExists(blobsToDelete);
            return blobsToDelete;
        }
        catch (IOException e) {
            LOGGER.warn(() -> new ParameterizedMessage("[{}] The following blobs are no longer part of any snapshot [{}] but failed to remove them", (Object)this.metadata.name(), (Object)blobsToDelete), (Throwable)e);
        }
        catch (Exception e) {
            assert (false) : e;
            LOGGER.warn((Message)new ParameterizedMessage("[{}] Exception during cleanup of root level blobs", (Object)this.metadata.name()), (Throwable)e);
        }
        return Collections.emptyList();
    }

    private long cleanupStaleIndices(Map<String, BlobContainer> foundIndices, Set<String> survivingIndexIds) {
        long deleteResult = 0L;
        try {
            for (Map.Entry<String, BlobContainer> indexEntry : foundIndices.entrySet()) {
                String indexSnId = indexEntry.getKey();
                try {
                    if (survivingIndexIds.contains(indexSnId)) continue;
                    LOGGER.debug("[{}] Found stale index [{}]. Cleaning it up", (Object)this.metadata.name(), (Object)indexSnId);
                    indexEntry.getValue().delete();
                    ++deleteResult;
                    LOGGER.debug("[{}] Cleaned up stale index [{}]", (Object)this.metadata.name(), (Object)indexSnId);
                }
                catch (Exception e) {
                    LOGGER.warn(() -> new ParameterizedMessage("[{}] index {} is no longer part of any snapshots in the repository, but failed to clean up their index folders", (Object)this.metadata.name(), (Object)indexSnId), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            assert (false) : e;
            LOGGER.warn((Message)new ParameterizedMessage("[{}] Exception during cleanup of stale indices", (Object)this.metadata.name()), (Throwable)e);
        }
        return deleteResult;
    }

    @Override
    public void finalizeSnapshot(SnapshotId snapshotId, ShardGenerations shardGenerations, long startTime, String failure, int totalShards, List<SnapshotShardFailure> shardFailures, long repositoryStateId, boolean includeGlobalState, Metadata clusterMetadata, boolean writeShardGens, ActionListener<SnapshotInfo> listener) {
        Collection<IndexId> indices = shardGenerations.indices();
        GroupedActionListener allMetaListener = new GroupedActionListener(ActionListener.wrap(snapshotInfos -> {
            assert (snapshotInfos.size() == 1) : "Should have only received a single SnapshotInfo but received " + snapshotInfos;
            SnapshotInfo snapshotInfo = (SnapshotInfo)snapshotInfos.iterator().next();
            RepositoryData existingRepositoryData = this.getRepositoryData();
            RepositoryData updatedRepositoryData = existingRepositoryData.addSnapshot(snapshotId, snapshotInfo.state(), shardGenerations);
            this.writeIndexGen(updatedRepositoryData, repositoryStateId, writeShardGens);
            if (writeShardGens) {
                this.cleanupOldShardGens(existingRepositoryData, updatedRepositoryData);
            }
            listener.onResponse(snapshotInfo);
        }, e -> listener.onFailure(new SnapshotException(this.metadata.name(), snapshotId, "failed to update snapshot in repository", (Throwable)e))), 2 + indices.size());
        Executor executor = this.threadPool.executor(SNAPSHOT_CODEC);
        executor.execute(ActionRunnable.run(allMetaListener, () -> this.globalMetadataFormat.write(clusterMetadata, this.blobContainer(), snapshotId.getUUID(), false)));
        for (IndexId index : indices) {
            executor.execute(ActionRunnable.run(allMetaListener, () -> this.indexMetadataFormat.write(clusterMetadata.index(index.getName()), this.indexContainer(index), snapshotId.getUUID(), false)));
        }
        executor.execute(ActionRunnable.supply(allMetaListener, () -> {
            SnapshotInfo snapshotInfo = new SnapshotInfo(snapshotId, indices.stream().map(IndexId::getName).collect(Collectors.toList()), startTime, failure, this.threadPool.absoluteTimeInMillis(), totalShards, shardFailures, includeGlobalState);
            this.snapshotFormat.write(snapshotInfo, this.blobContainer(), snapshotId.getUUID(), false);
            return snapshotInfo;
        }));
    }

    private void cleanupOldShardGens(RepositoryData existingRepositoryData, RepositoryData updatedRepositoryData) {
        ArrayList<String> toDelete = new ArrayList<String>();
        int prefixPathLen = this.basePath().buildAsString().length();
        updatedRepositoryData.shardGenerations().obsoleteShardGenerations(existingRepositoryData.shardGenerations()).forEach((indexId, gens) -> gens.forEach((shardId, oldGen) -> toDelete.add(this.shardContainer((IndexId)indexId, (int)shardId).path().buildAsString().substring(prefixPathLen) + "index-" + oldGen)));
        try {
            this.blobContainer().deleteBlobsIgnoringIfNotExists(toDelete);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to clean up old shard generation blobs", (Throwable)e);
        }
    }

    @Override
    public SnapshotInfo getSnapshotInfo(SnapshotId snapshotId) {
        try {
            return this.snapshotFormat.read(this.blobContainer(), snapshotId.getUUID());
        }
        catch (NoSuchFileException ex) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex);
        }
        catch (IOException | NotXContentException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotId, "failed to get snapshots", (Throwable)ex);
        }
    }

    @Override
    public Metadata getSnapshotGlobalMetadata(SnapshotId snapshotId) {
        try {
            return this.globalMetadataFormat.read(this.blobContainer(), snapshotId.getUUID());
        }
        catch (NoSuchFileException ex) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotId, "failed to read global metadata", (Throwable)ex);
        }
    }

    @Override
    public IndexMetadata getSnapshotIndexMetadata(SnapshotId snapshotId, IndexId index) throws IOException {
        return this.indexMetadataFormat.read(this.indexContainer(index), snapshotId.getUUID());
    }

    private BlobPath indicesPath() {
        return this.basePath().add("indices");
    }

    private BlobContainer indexContainer(IndexId indexId) {
        return this.blobStore().blobContainer(this.indicesPath().add(indexId.getId()));
    }

    private BlobContainer shardContainer(IndexId indexId, ShardId shardId) {
        return this.blobStore().blobContainer(this.indicesPath().add(indexId.getId()).add(Integer.toString(shardId.getId())));
    }

    private BlobContainer shardContainer(IndexId indexId, int shardId) {
        return this.blobStore().blobContainer(this.indicesPath().add(indexId.getId()).add(Integer.toString(shardId)));
    }

    private RateLimiter getRateLimiter(Settings repositorySettings, String setting, ByteSizeValue defaultRate) {
        ByteSizeValue maxSnapshotBytesPerSec = repositorySettings.getAsBytesSize(setting, this.settings.getAsBytesSize(setting, defaultRate));
        if (maxSnapshotBytesPerSec.getBytes() <= 0L) {
            return null;
        }
        return new RateLimiter.SimpleRateLimiter(maxSnapshotBytesPerSec.getMbFrac());
    }

    protected void assertSnapshotOrGenericThread() {
        assert (Thread.currentThread().getName().contains(SNAPSHOT_CODEC) || Thread.currentThread().getName().contains("generic") || Thread.currentThread().getName().contains("search")) : "Expected current thread [" + Thread.currentThread() + "] to be the snapshot or generic thread.";
    }

    @Override
    public String startVerification() {
        try {
            if (this.isReadOnly()) {
                this.latestIndexBlobId();
                return "read-only";
            }
            String seed = UUIDs.randomBase64UUID();
            byte[] testBytes = seed.getBytes(StandardCharsets.UTF_8);
            BlobContainer testContainer = this.blobStore().blobContainer(this.basePath().add(BlobStoreRepository.testBlobPrefix(seed)));
            String blobName = "master.dat";
            BytesArray bytes = new BytesArray(testBytes);
            try (StreamInput stream = bytes.streamInput();){
                testContainer.writeBlobAtomic(blobName, stream, bytes.length(), true);
            }
            return seed;
        }
        catch (Exception e) {
            throw new RepositoryVerificationException(this.metadata.name(), String.format(Locale.ENGLISH, "Unable to verify the repository, [%s] is not accessible on master node: %s '%s'", this.metadata.name(), e.getCause().getClass().getSimpleName(), e.getCause().getMessage()));
        }
    }

    @Override
    public void endVerification(String seed) {
        if (!this.isReadOnly()) {
            try {
                this.blobStore().delete(this.basePath().add(BlobStoreRepository.testBlobPrefix(seed)));
            }
            catch (IOException exp) {
                throw new RepositoryVerificationException(this.metadata.name(), "cannot delete test data at " + this.basePath(), exp);
            }
        }
    }

    @Override
    public RepositoryData getRepositoryData() {
        try {
            return this.getRepositoryData(this.latestIndexBlobId());
        }
        catch (IOException ioe) {
            throw new RepositoryException(this.metadata.name(), "Could not determine repository generation from root blobs", ioe);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private RepositoryData getRepositoryData(long indexGen) {
        if (indexGen == -1L) {
            return RepositoryData.EMPTY;
        }
        try {
            String snapshotsIndexBlobName = "index-" + Long.toString(indexGen);
            try (InputStream blob = this.blobContainer().readBlob(snapshotsIndexBlobName);){
                RepositoryData repositoryData;
                block15: {
                    XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, blob);
                    try {
                        repositoryData = RepositoryData.snapshotsFromXContent(parser, indexGen);
                        if (parser == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    parser.close();
                }
                return repositoryData;
            }
        }
        catch (IOException ioe) {
            throw new RepositoryException(this.metadata.name(), "could not read repository data from index blob", ioe);
        }
    }

    public static String testBlobPrefix(String seed) {
        return TESTS_FILE + seed;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void writeIndexGen(RepositoryData repositoryData, long expectedGen, boolean writeShardGens) throws IOException {
        BytesReference genBytes;
        assert (!this.isReadOnly());
        long currentGen = repositoryData.getGenId();
        if (currentGen != expectedGen) {
            throw new RepositoryException(this.metadata.name(), "concurrent modification of the index-N file, expected current generation [" + expectedGen + "], actual current generation [" + currentGen + "] - possibly due to simultaneous snapshot deletion requests");
        }
        long newGen = currentGen + 1L;
        String indexBlob = "index-" + Long.toString(newGen);
        LOGGER.debug("Repository [{}] writing new index generational blob [{}]", (Object)this.metadata.name(), (Object)indexBlob);
        this.writeAtomic(indexBlob, BytesReference.bytes(repositoryData.snapshotsToXContent(XContentFactory.jsonBuilder(), writeShardGens)), true);
        try (BytesStreamOutput bStream = new BytesStreamOutput();){
            bStream.writeLong(newGen);
            genBytes = bStream.bytes();
        }
        LOGGER.debug("Repository [{}] updating index.latest with generation [{}]", (Object)this.metadata.name(), (Object)newGen);
        this.writeAtomic(INDEX_LATEST_BLOB, genBytes, false);
        if (newGen - 2L >= 0L) {
            String oldSnapshotIndexFile = "index-" + Long.toString(newGen - 2L);
            try {
                this.blobContainer().deleteBlobIgnoringIfNotExists(oldSnapshotIndexFile);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to clean up old index blob [{}]", (Object)oldSnapshotIndexFile);
            }
        }
    }

    long latestIndexBlobId() throws IOException {
        try {
            return this.listBlobsToGetLatestIndexId();
        }
        catch (UnsupportedOperationException e) {
            try {
                return this.readSnapshotIndexLatestBlob();
            }
            catch (NoSuchFileException nsfe) {
                return -1L;
            }
        }
    }

    long readSnapshotIndexLatestBlob() throws IOException {
        try (InputStream blob = this.blobContainer().readBlob(INDEX_LATEST_BLOB);){
            BytesStreamOutput out = new BytesStreamOutput();
            Streams.copy(blob, out);
            long l = Numbers.bytesToLong(out.bytes().toBytesRef());
            return l;
        }
    }

    private long listBlobsToGetLatestIndexId() throws IOException {
        return this.latestGeneration(this.blobContainer().listBlobsByPrefix("index-").keySet());
    }

    private long latestGeneration(Collection<String> rootBlobs) {
        long latest = -1L;
        for (String blobName : rootBlobs) {
            if (!blobName.startsWith("index-")) continue;
            try {
                long curr = Long.parseLong(blobName.substring("index-".length()));
                latest = Math.max(latest, curr);
            }
            catch (NumberFormatException nfe) {
                LOGGER.warn("[{}] Unknown blob in the repository: {}", (Object)this.metadata.name(), (Object)blobName);
            }
        }
        return latest;
    }

    private void writeAtomic(String blobName, BytesReference bytesRef, boolean failIfAlreadyExists) throws IOException {
        try (StreamInput stream = bytesRef.streamInput();){
            this.blobContainer().writeBlobAtomic(blobName, stream, bytesRef.length(), failIfAlreadyExists);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snapshotShard(Store store, MapperService mapperService, SnapshotId snapshotId, IndexId indexId, IndexCommit snapshotIndexCommit, IndexShardSnapshotStatus snapshotStatus, boolean writeShardGens, ActionListener<String> listener) {
        ShardId shardId = store.shardId();
        long startTime = this.threadPool.absoluteTimeInMillis();
        try {
            Collection fileNames;
            Store.MetadataSnapshot metadataFromStore;
            Set<Object> blobs;
            String generation = snapshotStatus.generation();
            LOGGER.debug("[{}] [{}] snapshot to [{}] [{}] ...", (Object)shardId, (Object)snapshotId, (Object)this.metadata.name(), (Object)generation);
            BlobContainer shardContainer = this.shardContainer(indexId, shardId);
            if (generation == null) {
                try {
                    blobs = shardContainer.listBlobsByPrefix("index-").keySet();
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(shardId, "failed to list blobs", e);
                }
            } else {
                blobs = Collections.singleton("index-" + generation);
            }
            Tuple<BlobStoreIndexShardSnapshots, String> tuple = this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer, generation);
            BlobStoreIndexShardSnapshots snapshots = tuple.v1();
            String fileListGeneration = tuple.v2();
            if (snapshots.snapshots().stream().anyMatch(sf -> sf.snapshot().equals(snapshotId.getName()))) {
                throw new IndexShardSnapshotFailedException(shardId, "Duplicate snapshot name [" + snapshotId.getName() + "] detected, aborting");
            }
            ArrayList<BlobStoreIndexShardSnapshot.FileInfo> indexCommitPointFiles = new ArrayList<BlobStoreIndexShardSnapshot.FileInfo>();
            LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> filesToSnapshot = new LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo>();
            store.incRef();
            try {
                try {
                    LOGGER.trace("[{}] [{}] Loading store metadata using index commit [{}]", (Object)shardId, (Object)snapshotId, (Object)snapshotIndexCommit);
                    metadataFromStore = store.getMetadata(snapshotIndexCommit);
                    fileNames = snapshotIndexCommit.getFileNames();
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(shardId, "Failed to get store file metadata", e);
                }
            }
            finally {
                store.decRef();
            }
            int indexIncrementalFileCount = 0;
            int indexTotalNumberOfFiles = 0;
            long indexIncrementalSize = 0L;
            long indexTotalFileCount = 0L;
            for (String fileName : fileNames) {
                if (snapshotStatus.isAborted()) {
                    LOGGER.debug("[{}] [{}] Aborted on the file [{}], exiting", (Object)shardId, (Object)snapshotId, (Object)fileName);
                    throw new IndexShardSnapshotFailedException(shardId, "Aborted");
                }
                LOGGER.trace("[{}] [{}] Processing [{}]", (Object)shardId, (Object)snapshotId, (Object)fileName);
                StoreFileMetadata md = metadataFromStore.get(fileName);
                BlobStoreIndexShardSnapshot.FileInfo existingFileInfo = null;
                List<BlobStoreIndexShardSnapshot.FileInfo> filesInfo = snapshots.findPhysicalIndexFiles(fileName);
                if (filesInfo != null) {
                    for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : filesInfo) {
                        if (!fileInfo.isSame(md)) continue;
                        existingFileInfo = fileInfo;
                        break;
                    }
                }
                indexTotalFileCount += md.length();
                ++indexTotalNumberOfFiles;
                if (existingFileInfo == null) {
                    ++indexIncrementalFileCount;
                    indexIncrementalSize += md.length();
                    BlobStoreIndexShardSnapshot.FileInfo snapshotFileInfo = new BlobStoreIndexShardSnapshot.FileInfo(DATA_BLOB_PREFIX + UUIDs.randomBase64UUID(), md, this.chunkSize());
                    indexCommitPointFiles.add(snapshotFileInfo);
                    filesToSnapshot.add(snapshotFileInfo);
                    continue;
                }
                indexCommitPointFiles.add(existingFileInfo);
            }
            snapshotStatus.moveToStarted(startTime, indexIncrementalFileCount, indexTotalNumberOfFiles, indexIncrementalSize, indexTotalFileCount);
            assert (indexIncrementalFileCount == filesToSnapshot.size());
            StepListener<Collection<Void>> allFilesUploadedListener = new StepListener<Collection<Void>>();
            allFilesUploadedListener.whenComplete(v -> {
                List<String> blobsToDelete;
                String indexGeneration;
                IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.moveToFinalize(snapshotIndexCommit.getGeneration());
                BlobStoreIndexShardSnapshot snapshot = new BlobStoreIndexShardSnapshot(snapshotId.getName(), lastSnapshotStatus.getIndexVersion(), indexCommitPointFiles, lastSnapshotStatus.getStartTime(), this.threadPool.absoluteTimeInMillis() - lastSnapshotStatus.getStartTime(), lastSnapshotStatus.getIncrementalFileCount(), lastSnapshotStatus.getIncrementalSize());
                LOGGER.trace("[{}] [{}] writing shard snapshot file", (Object)shardId, (Object)snapshotId);
                try {
                    this.indexShardSnapshotFormat.write(snapshot, shardContainer, snapshotId.getUUID(), false);
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(shardId, "Failed to write commit point", e);
                }
                ArrayList<SnapshotFiles> newSnapshotsList = new ArrayList<SnapshotFiles>();
                newSnapshotsList.add(new SnapshotFiles(snapshot.snapshot(), snapshot.indexFiles()));
                for (SnapshotFiles point : snapshots) {
                    newSnapshotsList.add(point);
                }
                if (writeShardGens) {
                    indexGeneration = UUIDs.randomBase64UUID();
                    blobsToDelete = Collections.emptyList();
                } else {
                    indexGeneration = Long.toString(Long.parseLong(fileListGeneration) + 1L);
                    blobsToDelete = blobs.stream().filter(blob -> blob.startsWith("index-")).collect(Collectors.toList());
                    assert (blobsToDelete.stream().mapToLong(b -> Long.parseLong(b.replaceFirst("index-", ""))).max().orElse(-1L) < Long.parseLong(indexGeneration)) : "Tried to delete an index-N blob newer than the current generation [" + indexGeneration + "] when deleting index-N blobs " + blobsToDelete;
                }
                try {
                    this.writeShardIndexBlob(shardContainer, indexGeneration, new BlobStoreIndexShardSnapshots(newSnapshotsList));
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(shardId, "Failed to finalize snapshot creation [" + snapshotId + "] with shard index [" + this.indexShardSnapshotsFormat.blobName(indexGeneration) + "]", e);
                }
                if (!writeShardGens) {
                    try {
                        shardContainer.deleteBlobsIgnoringIfNotExists(blobsToDelete);
                    }
                    catch (IOException e) {
                        LOGGER.warn(() -> new ParameterizedMessage("[{}][{}] failed to delete old index-N blobs during finalization", (Object)snapshotId, (Object)shardId), (Throwable)e);
                    }
                }
                snapshotStatus.moveToDone(this.threadPool.absoluteTimeInMillis(), indexGeneration);
                listener.onResponse(indexGeneration);
            }, listener::onFailure);
            if (indexIncrementalFileCount == 0) {
                allFilesUploadedListener.onResponse(Collections.emptyList());
                return;
            }
            Executor executor = this.threadPool.executor(SNAPSHOT_CODEC);
            int maximumPoolSize = executor instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)executor).getMaximumPoolSize() : 1;
            int workers = Math.min(maximumPoolSize, indexIncrementalFileCount);
            ActionListener<Void> filesListener = BlobStoreRepository.fileQueueListener(filesToSnapshot, workers, allFilesUploadedListener);
            for (int i = 0; i < workers; ++i) {
                executor.execute(ActionRunnable.run(filesListener, () -> {
                    BlobStoreIndexShardSnapshot.FileInfo snapshotFileInfo = (BlobStoreIndexShardSnapshot.FileInfo)filesToSnapshot.poll(0L, TimeUnit.MILLISECONDS);
                    if (snapshotFileInfo != null) {
                        store.incRef();
                        try {
                            do {
                                this.snapshotFile(snapshotFileInfo, indexId, shardId, snapshotId, snapshotStatus, store);
                            } while ((snapshotFileInfo = (BlobStoreIndexShardSnapshot.FileInfo)filesToSnapshot.poll(0L, TimeUnit.MILLISECONDS)) != null);
                        }
                        finally {
                            store.decRef();
                        }
                    }
                }));
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    @Override
    public void restoreShard(Store store, SnapshotId snapshotId, IndexId indexId, ShardId snapshotShardId, RecoveryState recoveryState, ActionListener<Void> listener) {
        ShardId shardId = store.shardId();
        ActionListener<Void> restoreListener = ActionListener.delegateResponse(listener, (l, e) -> l.onFailure(new IndexShardRestoreFailedException(shardId, "failed to restore snapshot [" + snapshotId + "]", (Throwable)e)));
        final Executor executor = this.threadPool.executor(SNAPSHOT_CODEC);
        final BlobContainer container = this.shardContainer(indexId, snapshotShardId);
        executor.execute(ActionRunnable.wrap(restoreListener, l -> {
            BlobStoreIndexShardSnapshot snapshot = this.loadShardSnapshot(container, snapshotId);
            final SnapshotFiles snapshotFiles = new SnapshotFiles(snapshot.snapshot(), snapshot.indexFiles());
            new FileRestoreContext(this.metadata.name(), shardId, snapshotId, recoveryState){

                @Override
                protected void restoreFiles(List<BlobStoreIndexShardSnapshot.FileInfo> filesToRecover, Store store, ActionListener<Void> listener) {
                    if (filesToRecover.isEmpty()) {
                        listener.onResponse(null);
                    } else {
                        int maxPoolSize = executor instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)executor).getMaximumPoolSize() : 1;
                        int workers = Math.min(maxPoolSize, snapshotFiles.indexFiles().size());
                        LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> files = new LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo>(filesToRecover);
                        ActionListener<Void> allFilesListener = BlobStoreRepository.fileQueueListener(files, workers, ActionListener.map(listener, v -> null));
                        for (int i = 0; i < workers; ++i) {
                            executor.execute(ActionRunnable.run(allFilesListener, () -> {
                                store.incRef();
                                try {
                                    BlobStoreIndexShardSnapshot.FileInfo fileToRecover;
                                    while ((fileToRecover = (BlobStoreIndexShardSnapshot.FileInfo)files.poll(0L, TimeUnit.MILLISECONDS)) != null) {
                                        this.restoreFile(fileToRecover, store);
                                    }
                                }
                                finally {
                                    store.decRef();
                                }
                            }));
                        }
                    }
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                private void restoreFile(final BlobStoreIndexShardSnapshot.FileInfo fileInfo, Store store) throws IOException {
                    boolean success = false;
                    try (InputStream stream = BlobStoreRepository.maybeRateLimit(new SlicedInputStream(fileInfo.numberOfParts()){

                        @Override
                        protected InputStream openSlice(long slice) throws IOException {
                            return container.readBlob(fileInfo.partName(slice));
                        }
                    }, BlobStoreRepository.this.restoreRateLimiter, BlobStoreRepository.this.restoreRateLimitingTimeInNanos);){
                        try {
                            try (IndexOutput indexOutput = store.createVerifyingOutput(fileInfo.physicalName(), fileInfo.metadata(), IOContext.DEFAULT);){
                                int length;
                                byte[] buffer = new byte[4096];
                                while ((length = stream.read(buffer)) > 0) {
                                    indexOutput.writeBytes(buffer, 0, length);
                                    this.recoveryState.getIndex().addRecoveredBytesToFile(fileInfo.physicalName(), length);
                                }
                                Store.verify(indexOutput);
                                indexOutput.close();
                                store.directory().sync(Collections.singleton(fileInfo.physicalName()));
                                success = true;
                            }
                            if (success) return;
                        }
                        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                            try {
                                try {
                                    store.markStoreCorrupted((IOException)ex);
                                    throw ex;
                                }
                                catch (IOException e) {
                                    LOGGER.warn("store cannot be marked as corrupted", (Throwable)e);
                                }
                                throw ex;
                            }
                            catch (Throwable throwable) {
                                if (success) throw throwable;
                                store.deleteQuiet(fileInfo.physicalName());
                                throw throwable;
                            }
                        }
                        store.deleteQuiet(fileInfo.physicalName());
                        return;
                    }
                }
            }.restore(snapshotFiles, store, (ActionListener<Void>)l);
        }));
    }

    private static ActionListener<Void> fileQueueListener(BlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> files, int workers, ActionListener<Collection<Void>> listener) {
        return ActionListener.delegateResponse(new GroupedActionListener(listener, workers), (l, e) -> {
            files.clear();
            l.onFailure((Exception)e);
        });
    }

    private static InputStream maybeRateLimit(InputStream stream, @Nullable RateLimiter rateLimiter, CounterMetric metric) {
        return rateLimiter == null ? stream : new RateLimitingInputStream(stream, rateLimiter, metric::inc);
    }

    @Override
    public IndexShardSnapshotStatus getShardSnapshotStatus(SnapshotId snapshotId, IndexId indexId, ShardId shardId) {
        BlobStoreIndexShardSnapshot snapshot = this.loadShardSnapshot(this.shardContainer(indexId, shardId), snapshotId);
        return IndexShardSnapshotStatus.newDone(snapshot.startTime(), snapshot.time(), snapshot.incrementalFileCount(), snapshot.totalFileCount(), snapshot.incrementalSize(), snapshot.totalSize(), null);
    }

    @Override
    public void verify(String seed, DiscoveryNode localNode) {
        block12: {
            this.assertSnapshotOrGenericThread();
            if (this.isReadOnly()) {
                try {
                    this.latestIndexBlobId();
                }
                catch (IOException e) {
                    throw new RepositoryVerificationException(this.metadata.name(), "path " + this.basePath() + " is not accessible on node " + localNode, e);
                }
            }
            BlobContainer testBlobContainer = this.blobStore().blobContainer(this.basePath().add(BlobStoreRepository.testBlobPrefix(seed)));
            if (testBlobContainer.blobExists("master.dat")) {
                try {
                    BytesArray bytes = new BytesArray(seed);
                    try (StreamInput stream = bytes.streamInput();){
                        testBlobContainer.writeBlob("data-" + localNode.getId() + ".dat", stream, bytes.length(), true);
                        break block12;
                    }
                }
                catch (IOException exp) {
                    throw new RepositoryVerificationException(this.metadata.name(), "store location [" + this.blobStore() + "] is not accessible on the node [" + localNode + "]", exp);
                }
            }
            throw new RepositoryVerificationException(this.metadata.name(), "a file written by master to the store [" + this.blobStore() + "] cannot be accessed on the node [" + localNode + "]. This might indicate that the store [" + this.blobStore() + "] is not shared between this node and the master node or that permissions on the store don't allow reading files written by the master node");
        }
    }

    public String toString() {
        return "BlobStoreRepository[[" + this.metadata.name() + "], [" + this.blobStore() + "]]";
    }

    private ShardSnapshotMetaDeleteResult deleteFromShardSnapshotMeta(Set<SnapshotId> survivingSnapshots, IndexId indexId, ShardId snapshotShardId, SnapshotId snapshotId, BlobContainer shardContainer, Set<String> blobs, BlobStoreIndexShardSnapshots snapshots, String indexGeneration) {
        ArrayList<SnapshotFiles> newSnapshotsList = new ArrayList<SnapshotFiles>();
        Set survivingSnapshotNames = survivingSnapshots.stream().map(SnapshotId::getName).collect(Collectors.toSet());
        for (SnapshotFiles point : snapshots) {
            if (!survivingSnapshotNames.contains(point.snapshot())) continue;
            newSnapshotsList.add(point);
        }
        try {
            if (newSnapshotsList.isEmpty()) {
                return new ShardSnapshotMetaDeleteResult(indexId, snapshotShardId.id(), "_deleted", blobs);
            }
            BlobStoreIndexShardSnapshots updatedSnapshots = new BlobStoreIndexShardSnapshots(newSnapshotsList);
            this.writeShardIndexBlob(shardContainer, indexGeneration, updatedSnapshots);
            Set<String> survivingSnapshotUUIDs = survivingSnapshots.stream().map(SnapshotId::getUUID).collect(Collectors.toSet());
            return new ShardSnapshotMetaDeleteResult(indexId, snapshotShardId.id(), indexGeneration, BlobStoreRepository.unusedBlobs(blobs, survivingSnapshotUUIDs, updatedSnapshots));
        }
        catch (IOException e) {
            throw new IndexShardSnapshotFailedException(snapshotShardId, "Failed to finalize snapshot deletion [" + snapshotId + "] with shard index [" + this.indexShardSnapshotsFormat.blobName(indexGeneration) + "]", e);
        }
    }

    private void writeShardIndexBlob(BlobContainer shardContainer, String indexGeneration, BlobStoreIndexShardSnapshots updatedSnapshots) throws IOException {
        assert (!"_new".equals(indexGeneration));
        assert (!"_deleted".equals(indexGeneration));
        this.indexShardSnapshotsFormat.writeAtomic(updatedSnapshots, shardContainer, indexGeneration);
    }

    private static Set<String> getShardBlobs(ShardId snapshotShardId, BlobContainer shardContainer) {
        Set<String> blobs;
        try {
            blobs = shardContainer.listBlobs().keySet();
        }
        catch (IOException e) {
            throw new IndexShardSnapshotException(snapshotShardId, "Failed to list content of shard directory", e);
        }
        return blobs;
    }

    private static List<String> unusedBlobs(Set<String> blobs, Set<String> survivingSnapshotUUIDs, BlobStoreIndexShardSnapshots updatedSnapshots) {
        return blobs.stream().filter(blob -> blob.startsWith("index-") || blob.startsWith(SNAPSHOT_PREFIX) && blob.endsWith(".dat") && !survivingSnapshotUUIDs.contains(blob.substring(SNAPSHOT_PREFIX.length(), blob.length() - ".dat".length())) || blob.startsWith(DATA_BLOB_PREFIX) && updatedSnapshots.findNameFile(BlobStoreIndexShardSnapshot.FileInfo.canonicalName(blob)) == null || FsBlobContainer.isTempBlobName(blob)).collect(Collectors.toList());
    }

    private BlobStoreIndexShardSnapshot loadShardSnapshot(BlobContainer shardContainer, SnapshotId snapshotId) {
        try {
            return this.indexShardSnapshotFormat.read(shardContainer, snapshotId.getUUID());
        }
        catch (IOException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotId, "failed to read shard snapshot file for [" + shardContainer.path() + "]", (Throwable)ex);
        }
    }

    private Tuple<BlobStoreIndexShardSnapshots, String> buildBlobStoreIndexShardSnapshots(Set<String> blobs, BlobContainer shardContainer, @Nullable String generation) throws IOException {
        if (generation != null) {
            if (generation.equals("_new")) {
                return new Tuple<BlobStoreIndexShardSnapshots, String>(BlobStoreIndexShardSnapshots.EMPTY, "_new");
            }
            return new Tuple<BlobStoreIndexShardSnapshots, String>(this.indexShardSnapshotsFormat.read(shardContainer, generation), generation);
        }
        Tuple<BlobStoreIndexShardSnapshots, Long> legacyIndex = this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer);
        return new Tuple<BlobStoreIndexShardSnapshots, String>(legacyIndex.v1(), String.valueOf(legacyIndex.v2()));
    }

    private Tuple<BlobStoreIndexShardSnapshots, Long> buildBlobStoreIndexShardSnapshots(Set<String> blobs, BlobContainer shardContainer) throws IOException {
        long latest = this.latestGeneration(blobs);
        if (latest >= 0L) {
            BlobStoreIndexShardSnapshots shardSnapshots = this.indexShardSnapshotsFormat.read(shardContainer, Long.toString(latest));
            return new Tuple<BlobStoreIndexShardSnapshots, Long>(shardSnapshots, latest);
        }
        if (blobs.stream().anyMatch(b -> b.startsWith(SNAPSHOT_PREFIX) || b.startsWith("index-") || b.startsWith(DATA_BLOB_PREFIX))) {
            throw new IllegalStateException("Could not find a readable index-N file in a non-empty shard snapshot directory [" + shardContainer.path() + "]");
        }
        return new Tuple<BlobStoreIndexShardSnapshots, Long>(BlobStoreIndexShardSnapshots.EMPTY, latest);
    }

    private void snapshotFile(final BlobStoreIndexShardSnapshot.FileInfo fileInfo, IndexId indexId, final ShardId shardId, final SnapshotId snapshotId, final IndexShardSnapshotStatus snapshotStatus, Store store) throws IOException {
        BlobContainer shardContainer = this.shardContainer(indexId, shardId);
        String file = fileInfo.physicalName();
        store.incRef();
        try (IndexInput indexInput = store.openVerifyingInput(file, IOContext.READONCE, fileInfo.metadata());){
            int i = 0;
            while ((long)i < fileInfo.numberOfParts()) {
                long partBytes = fileInfo.partBytes(i);
                InputStream inputStream = new InputStreamIndexInput(indexInput, partBytes);
                if (this.snapshotRateLimiter != null) {
                    inputStream = new RateLimitingInputStream(inputStream, this.snapshotRateLimiter, this.snapshotRateLimitingTimeInNanos::inc);
                }
                inputStream = new FilterInputStream(inputStream){

                    @Override
                    public int read() throws IOException {
                        this.checkAborted();
                        return super.read();
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        this.checkAborted();
                        return super.read(b, off, len);
                    }

                    private void checkAborted() {
                        if (snapshotStatus.isAborted()) {
                            LOGGER.debug("[{}] [{}] Aborted on the file [{}], exiting", (Object)shardId, (Object)snapshotId, (Object)fileInfo.physicalName());
                            throw new IndexShardSnapshotFailedException(shardId, "Aborted");
                        }
                    }
                };
                shardContainer.writeBlob(fileInfo.partName(i), inputStream, partBytes, true);
                ++i;
            }
            Store.verify(indexInput);
            snapshotStatus.addProcessedFile(fileInfo.length());
        }
        catch (Exception t) {
            BlobStoreRepository.failStoreIfCorrupted(store, t);
            snapshotStatus.addProcessedFile(0L);
            throw t;
        }
        finally {
            store.decRef();
        }
    }

    private static void failStoreIfCorrupted(Store store, Exception e) {
        if (Lucene.isCorruptionException(e)) {
            try {
                store.markStoreCorrupted((IOException)e);
            }
            catch (IOException inner) {
                inner.addSuppressed(e);
                LOGGER.warn("store cannot be marked as corrupted", (Throwable)inner);
            }
        }
    }

    private static final class ShardSnapshotMetaDeleteResult {
        private final IndexId indexId;
        private final int shardId;
        private final String newGeneration;
        private final Collection<String> blobsToDelete;

        ShardSnapshotMetaDeleteResult(IndexId indexId, int shardId, String newGeneration, Collection<String> blobsToDelete) {
            this.indexId = indexId;
            this.shardId = shardId;
            this.newGeneration = newGeneration;
            this.blobsToDelete = blobsToDelete;
        }
    }
}

