/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import com.microsoft.azure.storage.LocationMode;
import io.crate.common.unit.TimeValue;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.UnknownHostException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.repositories.azure.AzureRepository;

public final class AzureStorageSettings {
    private final String account;
    private final String key;
    private final String endpointSuffix;
    private final TimeValue timeout;
    private final int maxRetries;
    private final Proxy proxy;
    private final LocationMode locationMode;

    private AzureStorageSettings(String account, String key, String endpointSuffix, TimeValue timeout, int maxRetries, Proxy proxy, LocationMode locationMode) {
        this.account = account;
        this.key = key;
        this.endpointSuffix = endpointSuffix;
        this.timeout = timeout;
        this.maxRetries = maxRetries;
        this.proxy = proxy;
        this.locationMode = locationMode;
    }

    private AzureStorageSettings(String account, String key, String endpointSuffix, TimeValue timeout, int maxRetries, Proxy.Type proxyType, String proxyHost, Integer proxyPort) {
        this.account = account;
        this.key = key;
        this.endpointSuffix = endpointSuffix;
        this.timeout = timeout;
        this.maxRetries = maxRetries;
        if (proxyType.equals((Object)Proxy.Type.DIRECT) && (proxyPort != 0 || Strings.hasText(proxyHost))) {
            throw new SettingsException("Azure Proxy port or host have been set but proxy type is not defined.");
        }
        if (!proxyType.equals((Object)Proxy.Type.DIRECT) && (proxyPort == 0 || Strings.isEmpty(proxyHost))) {
            throw new SettingsException("Azure Proxy type has been set but proxy host or port is not defined.");
        }
        if (proxyType.equals((Object)Proxy.Type.DIRECT)) {
            this.proxy = null;
        } else {
            try {
                this.proxy = new Proxy(proxyType, new InetSocketAddress(InetAddress.getByName(proxyHost), (int)proxyPort));
            }
            catch (UnknownHostException e) {
                throw new SettingsException("Azure proxy host is unknown.", e);
            }
        }
        this.locationMode = LocationMode.PRIMARY_ONLY;
    }

    public String getKey() {
        return this.key;
    }

    public String getAccount() {
        return this.account;
    }

    public String getEndpointSuffix() {
        return this.endpointSuffix;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public LocationMode getLocationMode() {
        return this.locationMode;
    }

    public String buildConnectionString() {
        StringBuilder connectionStringBuilder = new StringBuilder();
        connectionStringBuilder.append("DefaultEndpointsProtocol=https").append(";AccountName=").append(this.account).append(";AccountKey=").append(this.key);
        if (Strings.hasText(this.endpointSuffix)) {
            connectionStringBuilder.append(";EndpointSuffix=").append(this.endpointSuffix);
        }
        return connectionStringBuilder.toString();
    }

    static AzureStorageSettings getClientSettings(Settings settings) {
        try (SecureString account = AzureStorageSettings.getConfigValue(settings, AzureRepository.Repository.ACCOUNT_SETTING);){
            SecureString key = AzureStorageSettings.getConfigValue(settings, AzureRepository.Repository.KEY_SETTING);
            try {
                AzureStorageSettings azureStorageSettings = new AzureStorageSettings(account.toString(), key.toString(), AzureStorageSettings.getConfigValue(settings, AzureRepository.Repository.ENDPOINT_SUFFIX_SETTING), AzureStorageSettings.getConfigValue(settings, AzureRepository.Repository.TIMEOUT_SETTING), AzureStorageSettings.getConfigValue(settings, AzureRepository.Repository.MAX_RETRIES_SETTING), AzureStorageSettings.getConfigValue(settings, AzureRepository.Repository.PROXY_TYPE_SETTING), AzureStorageSettings.getConfigValue(settings, AzureRepository.Repository.PROXY_HOST_SETTING), AzureStorageSettings.getConfigValue(settings, AzureRepository.Repository.PROXY_PORT_SETTING));
                if (key != null) {
                    key.close();
                }
                return azureStorageSettings;
            }
            catch (Throwable throwable) {
                if (key != null) {
                    try {
                        key.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    private static <T> T getConfigValue(Settings settings, Setting<T> clientSetting) {
        return clientSetting.get(settings);
    }

    static AzureStorageSettings copy(AzureStorageSettings settings) {
        return new AzureStorageSettings(settings.account, settings.key, settings.endpointSuffix, settings.timeout, settings.maxRetries, settings.proxy, settings.locationMode);
    }

    public String toString() {
        return "AzureStorageSettings{account='" + this.account + "', key='" + this.key + "', timeout=" + this.timeout + ", endpointSuffix='" + this.endpointSuffix + "', maxRetries=" + this.maxRetries + ", proxy=" + this.proxy + ", locationMode='" + this.locationMode + "'}";
    }
}

