/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import io.crate.analyze.repositories.TypeSettings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.azure.AzureRepository;
import org.elasticsearch.repositories.azure.AzureStorageService;
import org.elasticsearch.threadpool.ThreadPool;

public class AzureRepositoryPlugin
extends Plugin
implements RepositoryPlugin {
    private final AzureStorageService azureStoreService = new AzureStorageService();

    @Override
    public Map<String, Repository.Factory> getRepositories(final Environment env, final NamedXContentRegistry namedXContentRegistry, final ThreadPool threadPool) {
        return Collections.singletonMap("azure", new Repository.Factory(){

            @Override
            public TypeSettings settings() {
                return new TypeSettings(AzureRepository.mandatorySettings(), AzureRepository.optionalSettings());
            }

            @Override
            public Repository create(RepositoryMetadata metadata) throws Exception {
                return new AzureRepository(metadata, env, namedXContentRegistry, AzureRepositoryPlugin.this.azureStoreService, threadPool);
            }
        });
    }

    @Override
    public List<Setting<?>> getSettings() {
        return List.of(AzureRepository.Repository.ACCOUNT_SETTING, AzureRepository.Repository.KEY_SETTING);
    }
}

