/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import com.google.common.annotations.VisibleForTesting;
import com.microsoft.azure.storage.LocationMode;
import io.crate.common.unit.TimeValue;
import java.net.Proxy;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.repositories.azure.AzureBlobStore;
import org.elasticsearch.repositories.azure.AzureStorageService;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.threadpool.ThreadPool;

public class AzureRepository
extends BlobStoreRepository {
    private static final Logger LOGGER = LogManager.getLogger(AzureRepository.class);
    public static final String TYPE = "azure";
    private final ByteSizeValue chunkSize;
    private final AzureStorageService storageService;
    private final boolean readonly;

    public static List<Setting<?>> optionalSettings() {
        return List.of(Repository.CONTAINER_SETTING, Repository.BASE_PATH_SETTING, Repository.CHUNK_SIZE_SETTING, Repository.READONLY_SETTING, Repository.LOCATION_MODE_SETTING, COMPRESS_SETTING, Repository.MAX_RETRIES_SETTING, Repository.ENDPOINT_SUFFIX_SETTING, Repository.TIMEOUT_SETTING, Repository.PROXY_TYPE_SETTING, Repository.PROXY_HOST_SETTING, Repository.PROXY_PORT_SETTING);
    }

    public static List<Setting<?>> mandatorySettings() {
        return List.of(Repository.ACCOUNT_SETTING, Repository.KEY_SETTING);
    }

    public AzureRepository(RepositoryMetadata metadata, Environment environment, NamedXContentRegistry namedXContentRegistry, AzureStorageService storageService, ThreadPool threadPool) {
        super(metadata, environment.settings(), namedXContentRegistry, threadPool, AzureRepository.buildBasePath(metadata));
        this.chunkSize = Repository.CHUNK_SIZE_SETTING.get(metadata.settings());
        this.storageService = storageService;
        LocationMode locationMode = Repository.LOCATION_MODE_SETTING.get(metadata.settings());
        this.readonly = Repository.READONLY_SETTING.exists(metadata.settings()) ? Repository.READONLY_SETTING.get(metadata.settings()) : locationMode == LocationMode.SECONDARY_ONLY;
    }

    private static BlobPath buildBasePath(RepositoryMetadata metadata) {
        String basePath = Strings.trimLeadingCharacter(Repository.BASE_PATH_SETTING.get(metadata.settings()), '/');
        if (Strings.hasLength(basePath)) {
            BlobPath path = new BlobPath();
            for (String elem : basePath.split("/")) {
                path = path.add(elem);
            }
            return path;
        }
        return BlobPath.cleanPath();
    }

    @Override
    @VisibleForTesting
    protected BlobStore getBlobStore() {
        return super.getBlobStore();
    }

    @Override
    protected AzureBlobStore createBlobStore() {
        AzureBlobStore blobStore = new AzureBlobStore(this.metadata, this.storageService);
        LOGGER.debug(() -> new ParameterizedMessage("using container [{}], chunk_size [{}], compress [{}], base_path [{}]", new Object[]{blobStore, this.chunkSize, this.isCompress(), this.basePath()}));
        return blobStore;
    }

    @Override
    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    public static final class Repository {
        static final Setting<SecureString> ACCOUNT_SETTING = Setting.maskedString("account");
        static final Setting<SecureString> KEY_SETTING = Setting.maskedString("key");
        public static final Setting<String> CLIENT_NAME = Setting.simpleString("client", Setting.Property.NodeScope);
        static final Setting<String> CONTAINER_SETTING = new Setting("container", "crate-snapshots", Function.identity(), Setting.Property.NodeScope);
        static final Setting<String> BASE_PATH_SETTING = Setting.simpleString("base_path", Setting.Property.NodeScope);
        static final Setting<LocationMode> LOCATION_MODE_SETTING = new Setting<LocationMode>("location_mode", s -> LocationMode.PRIMARY_ONLY.toString(), s -> LocationMode.valueOf((String)s.toUpperCase(Locale.ROOT)), Setting.Property.NodeScope);
        static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting("chunk_size", AzureStorageService.MAX_CHUNK_SIZE, AzureStorageService.MIN_CHUNK_SIZE, AzureStorageService.MAX_CHUNK_SIZE, Setting.Property.NodeScope);
        static final Setting<Boolean> READONLY_SETTING = Setting.boolSetting("readonly", false, Setting.Property.NodeScope);
        static final Setting<Integer> MAX_RETRIES_SETTING = Setting.intSetting("max_retries", 3, Setting.Property.NodeScope);
        static final Setting<String> ENDPOINT_SUFFIX_SETTING = Setting.simpleString("endpoint_suffix", Setting.Property.NodeScope);
        static final Setting<TimeValue> TIMEOUT_SETTING = Setting.timeSetting("timeout", TimeValue.timeValueMinutes(-1L), Setting.Property.NodeScope);
        static final Setting<Proxy.Type> PROXY_TYPE_SETTING = new Setting<Proxy.Type>("proxy_type", "direct", s -> Proxy.Type.valueOf(s.toUpperCase(Locale.ROOT)), Setting.Property.NodeScope);
        static final Setting<String> PROXY_HOST_SETTING = Setting.simpleString("proxy_host", Setting.Property.NodeScope);
        static final Setting<Integer> PROXY_PORT_SETTING = Setting.intSetting("proxy_port", 0, 0, 65535, Setting.Property.NodeScope);
    }
}

