/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import com.microsoft.azure.storage.LocationMode;
import com.microsoft.azure.storage.StorageException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetadata;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.repositories.azure.AzureBlobContainer;
import org.elasticsearch.repositories.azure.AzureRepository;
import org.elasticsearch.repositories.azure.AzureStorageService;
import org.elasticsearch.repositories.azure.AzureStorageSettings;

public class AzureBlobStore
implements BlobStore {
    private final AzureStorageService service;
    private final String clientName;
    private final String container;
    private final LocationMode locationMode;

    public AzureBlobStore(RepositoryMetadata metadata, AzureStorageService service) {
        this.service = service;
        this.container = AzureRepository.Repository.CONTAINER_SETTING.get(metadata.settings());
        this.clientName = AzureRepository.Repository.CLIENT_NAME.get(metadata.settings());
        this.locationMode = AzureRepository.Repository.LOCATION_MODE_SETTING.get(metadata.settings());
        AzureStorageSettings repositorySettings = AzureStorageSettings.getClientSettings(metadata.settings());
        this.service.refreshSettings(repositorySettings);
    }

    public String toString() {
        return this.container;
    }

    public LocationMode getLocationMode() {
        return this.locationMode;
    }

    @Override
    public BlobContainer blobContainer(BlobPath path) {
        return new AzureBlobContainer(path, this);
    }

    @Override
    public void delete(BlobPath path) throws IOException {
        String keyPath = path.buildAsString();
        try {
            this.service.deleteFiles(this.container, keyPath);
        }
        catch (StorageException | URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() {
    }

    public boolean containerExist() throws URISyntaxException, StorageException {
        return this.service.doesContainerExist(this.container);
    }

    public boolean blobExists(String blob) throws URISyntaxException, StorageException {
        return this.service.blobExists(this.container, blob);
    }

    public void deleteBlob(String blob) throws URISyntaxException, StorageException {
        this.service.deleteBlob(this.container, blob);
    }

    public void deleteBlobDirectory(String keyPath) throws URISyntaxException, StorageException, IOException {
        this.service.deleteBlobDirectory(this.container, keyPath);
    }

    public Map<String, BlobContainer> children(BlobPath path) throws URISyntaxException, StorageException {
        return Collections.unmodifiableMap(this.service.children(this.clientName, this.container, path).stream().collect(Collectors.toMap(Function.identity(), name -> new AzureBlobContainer(path.add((String)name), this))));
    }

    public InputStream getInputStream(String blob) throws URISyntaxException, StorageException, IOException {
        return this.service.getInputStream(this.container, blob);
    }

    public Map<String, BlobMetadata> listBlobsByPrefix(String keyPath, String prefix) throws URISyntaxException, StorageException {
        return this.service.listBlobsByPrefix(this.container, keyPath, prefix);
    }

    public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws URISyntaxException, StorageException, IOException {
        this.service.writeBlob(this.container, blobName, inputStream, blobSize, failIfAlreadyExists);
    }
}

