/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import com.microsoft.azure.storage.LocationMode;
import com.microsoft.azure.storage.StorageException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.NoSuchFileException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetadata;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.repositories.azure.AzureBlobStore;

public class AzureBlobContainer
extends AbstractBlobContainer {
    private final Logger logger = LogManager.getLogger(AzureBlobContainer.class);
    private final AzureBlobStore blobStore;
    private final String keyPath;

    public AzureBlobContainer(BlobPath path, AzureBlobStore blobStore) {
        super(path);
        this.blobStore = blobStore;
        this.keyPath = path.buildAsString();
    }

    @Override
    public boolean blobExists(String blobName) {
        this.logger.trace("blobExists({})", (Object)blobName);
        try {
            return this.blobStore.blobExists(this.buildKey(blobName));
        }
        catch (StorageException | URISyntaxException e) {
            this.logger.warn("can not access [{}] in container {{}}: {}", (Object)blobName, (Object)this.blobStore, (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public InputStream readBlob(String blobName) throws IOException {
        this.logger.trace("readBlob({})", (Object)blobName);
        if (this.blobStore.getLocationMode() == LocationMode.SECONDARY_ONLY && !this.blobExists(blobName)) {
            throw new NoSuchFileException("Blob [" + blobName + "] does not exist");
        }
        try {
            return this.blobStore.getInputStream(this.buildKey(blobName));
        }
        catch (StorageException e) {
            if (e.getHttpStatusCode() == 404) {
                throw new NoSuchFileException(e.getMessage());
            }
            throw new IOException(e);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.logger.trace("writeBlob({}, stream, {})", (Object)this.buildKey(blobName), (Object)blobSize);
        try {
            this.blobStore.writeBlob(this.buildKey(blobName), inputStream, blobSize, failIfAlreadyExists);
        }
        catch (StorageException | URISyntaxException e) {
            throw new IOException("Can not write blob " + blobName, e);
        }
    }

    @Override
    public void writeBlobAtomic(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.writeBlob(blobName, inputStream, blobSize, failIfAlreadyExists);
    }

    @Override
    public void deleteBlob(String blobName) throws IOException {
        this.logger.trace("deleteBlob({})", (Object)blobName);
        try {
            this.blobStore.deleteBlob(this.buildKey(blobName));
        }
        catch (StorageException e) {
            if (e.getHttpStatusCode() == 404) {
                throw new NoSuchFileException(e.getMessage());
            }
            throw new IOException(e);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void delete() throws IOException {
        try {
            this.blobStore.deleteBlobDirectory(this.keyPath);
        }
        catch (StorageException | URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Map<String, BlobMetadata> listBlobsByPrefix(@Nullable String prefix) throws IOException {
        this.logger.trace("listBlobsByPrefix({})", (Object)prefix);
        try {
            return this.blobStore.listBlobsByPrefix(this.keyPath, prefix);
        }
        catch (StorageException | URISyntaxException e) {
            this.logger.warn("can not access [{}] in container {{}}: {}", (Object)prefix, (Object)this.blobStore, (Object)e.getMessage());
            throw new IOException(e);
        }
    }

    @Override
    public Map<String, BlobMetadata> listBlobs() throws IOException {
        this.logger.trace("listBlobs()");
        return this.listBlobsByPrefix(null);
    }

    protected String buildKey(String blobName) {
        return this.keyPath + (blobName == null ? "" : blobName);
    }

    @Override
    public Map<String, BlobContainer> children() throws IOException {
        BlobPath path = this.path();
        try {
            return this.blobStore.children(path);
        }
        catch (StorageException | URISyntaxException e) {
            throw new IOException("Failed to list children in path [" + path.buildAsString() + "].", e);
        }
    }
}

