/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.VerificationFailure;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class VerifyNodeRepositoryAction {
    private static final Logger LOGGER = LogManager.getLogger(VerifyNodeRepositoryAction.class);
    public static final String ACTION_NAME = "internal:admin/repository/verify";
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;

    public VerifyNodeRepositoryAction(TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService) {
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        transportService.registerRequestHandler(ACTION_NAME, "snapshot", VerifyNodeRepositoryRequest::new, new VerifyNodeRepositoryRequestHandler());
    }

    public void verify(String repository, boolean readOnly, String verificationToken, final ActionListener<RepositoriesService.VerifyResponse> listener) {
        DiscoveryNodes discoNodes = this.clusterService.state().nodes();
        DiscoveryNode localNode = discoNodes.getLocalNode();
        ObjectContainer<DiscoveryNode> masterAndDataNodes = discoNodes.getMasterAndDataNodes().values();
        final ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>();
        for (ObjectCursor cursor : masterAndDataNodes) {
            DiscoveryNode node = (DiscoveryNode)cursor.value;
            if (readOnly && node.getVersion().before(Version.V_4_2_0)) continue;
            nodes.add(node);
        }
        final CopyOnWriteArrayList<VerificationFailure> errors = new CopyOnWriteArrayList<VerificationFailure>();
        final AtomicInteger counter = new AtomicInteger(nodes.size());
        for (final DiscoveryNode node : nodes) {
            if (node.equals(localNode)) {
                try {
                    this.doVerify(repository, verificationToken, localNode);
                }
                catch (Exception e) {
                    LOGGER.warn(() -> new ParameterizedMessage("[{}] failed to verify repository", (Object)repository), (Throwable)e);
                    errors.add(new VerificationFailure(node.getId(), e));
                }
                if (counter.decrementAndGet() != 0) continue;
                this.finishVerification(listener, nodes, errors);
                continue;
            }
            this.transportService.sendRequest(node, ACTION_NAME, new VerifyNodeRepositoryRequest(repository, verificationToken), new EmptyTransportResponseHandler("same"){

                @Override
                public void handleResponse(TransportResponse.Empty response) {
                    if (counter.decrementAndGet() == 0) {
                        VerifyNodeRepositoryAction.this.finishVerification(listener, nodes, errors);
                    }
                }

                @Override
                public void handleException(TransportException exp) {
                    errors.add(new VerificationFailure(node.getId(), exp));
                    if (counter.decrementAndGet() == 0) {
                        VerifyNodeRepositoryAction.this.finishVerification(listener, nodes, errors);
                    }
                }
            });
        }
    }

    public void finishVerification(ActionListener<RepositoriesService.VerifyResponse> listener, List<DiscoveryNode> nodes, CopyOnWriteArrayList<VerificationFailure> errors) {
        listener.onResponse(new RepositoriesService.VerifyResponse(nodes.toArray(new DiscoveryNode[nodes.size()]), errors.toArray(new VerificationFailure[errors.size()])));
    }

    private void doVerify(String repositoryName, String verificationToken, DiscoveryNode localNode) {
        Repository repository = this.repositoriesService.repository(repositoryName);
        repository.verify(verificationToken, localNode);
    }

    class VerifyNodeRepositoryRequestHandler
    implements TransportRequestHandler<VerifyNodeRepositoryRequest> {
        VerifyNodeRepositoryRequestHandler() {
        }

        @Override
        public void messageReceived(VerifyNodeRepositoryRequest request, TransportChannel channel, Task task) throws Exception {
            DiscoveryNode localNode = VerifyNodeRepositoryAction.this.clusterService.state().nodes().getLocalNode();
            try {
                VerifyNodeRepositoryAction.this.doVerify(request.repository, request.verificationToken, localNode);
            }
            catch (Exception ex) {
                LOGGER.warn(() -> new ParameterizedMessage("[{}] failed to verify repository", (Object)request.repository), (Throwable)ex);
                throw ex;
            }
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    public static class VerifyNodeRepositoryRequest
    extends TransportRequest {
        private final String repository;
        private final String verificationToken;

        VerifyNodeRepositoryRequest(String repository, String verificationToken) {
            this.repository = repository;
            this.verificationToken = verificationToken;
        }

        public VerifyNodeRepositoryRequest(StreamInput in) throws IOException {
            super(in);
            this.repository = in.readString();
            this.verificationToken = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.repository);
            out.writeString(this.verificationToken);
        }
    }
}

