/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import io.crate.analyze.repositories.TypeSettings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.fs.FsRepository;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.SnapshotShardsService;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ThreadPool;

public class RepositoriesModule
extends AbstractModule {
    private final Map<String, Repository.Factory> repositoryTypes;

    public RepositoriesModule(final Environment env, List<RepositoryPlugin> repoPlugins, final NamedXContentRegistry namedXContentRegistry, final ThreadPool threadPool) {
        HashMap<String, Repository.Factory> factories = new HashMap<String, Repository.Factory>();
        factories.put("fs", new Repository.Factory(){

            @Override
            public TypeSettings settings() {
                return new TypeSettings(FsRepository.mandatorySettings(), FsRepository.optionalSettings());
            }

            @Override
            public Repository create(RepositoryMetadata metadata) throws Exception {
                return new FsRepository(metadata, env, namedXContentRegistry, threadPool);
            }
        });
        for (RepositoryPlugin repoPlugin : repoPlugins) {
            Map<String, Repository.Factory> newRepoTypes = repoPlugin.getRepositories(env, namedXContentRegistry, threadPool);
            for (Map.Entry<String, Repository.Factory> entry : newRepoTypes.entrySet()) {
                if (factories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Repository type [" + entry.getKey() + "] is already registered");
            }
        }
        this.repositoryTypes = Collections.unmodifiableMap(factories);
    }

    @Override
    protected void configure() {
        this.bind(RepositoriesService.class).asEagerSingleton();
        this.bind(SnapshotsService.class).asEagerSingleton();
        this.bind(SnapshotShardsService.class).asEagerSingleton();
        this.bind(RestoreService.class).asEagerSingleton();
        MapBinder<String, Repository.Factory> typesBinder = MapBinder.newMapBinder(this.binder(), String.class, Repository.Factory.class);
        this.repositoryTypes.forEach((k, v) -> typesBinder.addBinding((String)k).toInstance(v));
        MapBinder<String, TypeSettings> typeSettingsBinder = MapBinder.newMapBinder(this.binder(), String.class, TypeSettings.class);
        for (Map.Entry<String, Repository.Factory> e : this.repositoryTypes.entrySet()) {
            String repoScheme = e.getKey();
            TypeSettings repoSettings = e.getValue().settings();
            typeSettingsBinder.addBinding(repoScheme).toInstance(repoSettings);
        }
    }
}

