/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.repository.url;

import io.crate.analyze.repositories.TypeSettings;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.url.URLRepository;
import org.elasticsearch.threadpool.ThreadPool;

public class URLRepositoryPlugin
extends Plugin
implements RepositoryPlugin {
    @Override
    public List<Setting<?>> getSettings() {
        return Arrays.asList(URLRepository.ALLOWED_URLS_SETTING, URLRepository.REPOSITORIES_URL_SETTING, URLRepository.SUPPORTED_PROTOCOLS_SETTING);
    }

    @Override
    public Map<String, Repository.Factory> getRepositories(final Environment env, final NamedXContentRegistry namedXContentRegistry, final ThreadPool threadPool) {
        return Collections.singletonMap("url", new Repository.Factory(){

            @Override
            public TypeSettings settings() {
                return new TypeSettings(URLRepository.mandatorySettings(), List.of());
            }

            @Override
            public Repository create(RepositoryMetadata metadata) throws Exception {
                return new URLRepository(metadata, env, namedXContentRegistry, threadPool);
            }
        });
    }
}

