/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import io.crate.common.io.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.monitor.MonitorService;
import org.elasticsearch.transport.TransportService;

public class NodeService
implements Closeable {
    private final MonitorService monitorService;
    private final IndicesService indicesService;
    private final TransportService transportService;

    NodeService(MonitorService monitorService, IndicesService indicesService, TransportService transportService) {
        this.monitorService = monitorService;
        this.indicesService = indicesService;
        this.transportService = transportService;
    }

    public MonitorService getMonitorService() {
        return this.monitorService;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(new Closeable[]{this.indicesService});
    }

    public NodeStats stats() {
        return new NodeStats(this.transportService.getLocalNode(), System.currentTimeMillis(), this.monitorService.fsService().stats());
    }

    public boolean awaitClose(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.indicesService.awaitClose(timeout, timeUnit);
    }
}

