/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.lucene.util.IOUtils;

public final class NodeNames {
    public static String randomNodeName() {
        List<String> names = NodeNames.nodeNames();
        int index = ThreadLocalRandom.current().nextInt(names.size());
        return names.get(index);
    }

    static List<String> nodeNames() {
        ArrayList<String> arrayList;
        InputStream input = NodeNames.class.getResourceAsStream("/config/names.txt");
        try {
            ArrayList<String> names = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                String line = reader.readLine();
                while (line != null) {
                    String[] fields = line.split("\t");
                    if (fields.length == 0) {
                        throw new RuntimeException("Failed to parse the names.txt. Malformed record: " + line);
                    }
                    names.add(fields[0]);
                    line = reader.readLine();
                }
            }
            arrayList = names;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Could not read node names list", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{input});
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{input});
        return arrayList;
    }
}

