/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import io.crate.common.io.IOUtils;
import io.crate.common.unit.TimeValue;
import io.crate.execution.engine.aggregation.impl.AggregationImplModule;
import io.crate.execution.engine.window.WindowFunctionModule;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.tablefunctions.TableFunctionModule;
import io.crate.metadata.settings.session.SessionSettingModule;
import io.crate.netty.EventLoopGroups;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.net.ssl.SNIHostName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Build;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.InternalClusterInfoService;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.metadata.AliasValidator;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataIndexUpgradeService;
import org.elasticsearch.cluster.metadata.TemplateUpgradeService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.BatchedRerouteService;
import org.elasticsearch.cluster.routing.LazilyInitializedRerouteService;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdMonitor;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.StopWatch;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.logging.NodeAndClusterIdStateListener;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.SettingUpgrader;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.GatewayAllocator;
import org.elasticsearch.gateway.GatewayMetaState;
import org.elasticsearch.gateway.GatewayModule;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.HierarchyCircuitBreakerService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.recovery.PeerRecoverySourceService;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.store.IndicesStore;
import org.elasticsearch.monitor.MonitorService;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.node.NodeService;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.EnginePlugin;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.MetadataUpgrader;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.RepositoriesModule;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.snapshots.SnapshotShardsService;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportService;

public class Node
implements Closeable {
    public static final Setting<Boolean> WRITE_PORTS_FILE_SETTING = Setting.boolSetting("node.portsfile", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> NODE_DATA_SETTING = Setting.boolSetting("node.data", true, Setting.Property.NodeScope);
    public static final Setting<Boolean> NODE_MASTER_SETTING = Setting.boolSetting("node.master", true, Setting.Property.NodeScope);
    public static final Setting<Boolean> NODE_LOCAL_STORAGE_SETTING = Setting.boolSetting("node.local_storage", true, Setting.Property.NodeScope);
    public static final Setting<String> NODE_NAME_SETTING = Setting.simpleString("node.name", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<String> NODE_ATTRIBUTES = Setting.prefixKeySetting("node.attr.", key -> new Setting<String>((String)key, "", value -> {
        if (value.length() > 0 && (Character.isWhitespace(value.charAt(0)) || Character.isWhitespace(value.charAt(value.length() - 1)))) {
            throw new IllegalArgumentException(key + " cannot have leading or trailing whitespace [" + value + "]");
        }
        if (value.length() > 0 && "node.attr.server_name".equals(key)) {
            try {
                new SNIHostName((String)value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("invalid node.attr.server_name [" + value + "]", e);
            }
        }
        return value;
    }, Setting.Property.NodeScope));
    public static final Setting<TimeValue> INITIAL_STATE_TIMEOUT_SETTING = Setting.timeSetting("discovery.initial_state_timeout", TimeValue.timeValueSeconds(30L), Setting.Property.NodeScope);
    private final Lifecycle lifecycle = new Lifecycle();
    private final Logger logger = LogManager.getLogger(Node.class);
    private final Injector injector;
    private final Settings settings;
    private final Environment environment;
    private final NodeEnvironment nodeEnvironment;
    private final PluginsService pluginsService;
    private final NodeClient client;
    private final Collection<LifecycleComponent> pluginLifecycleComponents;
    private final LocalNodeFactory localNodeFactory;
    private final NodeService nodeService;

    public Node(Environment environment) {
        this(environment, Collections.emptyList(), true);
    }

    protected Node(Environment environment, Collection<Class<? extends Plugin>> classpathPlugins, boolean forbidPrivateIndexSettings) {
        ArrayList<Closeable> resourcesToClose = new ArrayList<Closeable>();
        boolean success = false;
        try {
            Settings tmpSettings = Settings.builder().put(environment.settings()).build();
            this.nodeEnvironment = new NodeEnvironment(tmpSettings, environment);
            resourcesToClose.add(this.nodeEnvironment);
            this.logger.info("node name [{}], node ID [{}], cluster name [{}]", (Object)NODE_NAME_SETTING.get(tmpSettings), (Object)this.nodeEnvironment.nodeId(), (Object)ClusterName.CLUSTER_NAME_SETTING.get(tmpSettings).value());
            JvmInfo jvmInfo = JvmInfo.jvmInfo();
            this.logVersion(this.logger, jvmInfo);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("using config [{}], data [{}], logs [{}], plugins [{}]", (Object)environment.configFile(), (Object)Arrays.toString(environment.dataFiles()), (Object)environment.logsFile(), (Object)environment.pluginsFile());
            }
            this.pluginsService = new PluginsService(tmpSettings, environment.configFile(), environment.modulesFile(), environment.pluginsFile(), classpathPlugins);
            this.settings = this.pluginsService.updatedSettings();
            this.localNodeFactory = new LocalNodeFactory(this.settings, this.nodeEnvironment.nodeId());
            this.environment = new Environment(this.settings, environment.configFile());
            Environment.assertEquivalent(environment, this.environment);
            ThreadPool threadPool = new ThreadPool(this.settings);
            resourcesToClose.add(() -> ThreadPool.terminate(threadPool, 10L, TimeUnit.SECONDS));
            ArrayList additionalSettings = new ArrayList(this.pluginsService.getPluginSettings());
            for (ExecutorBuilder builder : threadPool.builders()) {
                additionalSettings.addAll(builder.getRegisteredSettings());
            }
            this.client = new NodeClient(this.settings, threadPool);
            AnalysisModule analysisModule = new AnalysisModule(this.environment, this.pluginsService.filterPlugins(AnalysisPlugin.class));
            Set<SettingUpgrader<?>> settingsUpgraders = this.pluginsService.filterPlugins(Plugin.class).stream().map(Plugin::getSettingUpgraders).flatMap(Collection::stream).collect(Collectors.toSet());
            SettingsModule settingsModule = new SettingsModule(this.settings, additionalSettings, settingsUpgraders);
            NetworkService networkService = new NetworkService(this.getCustomNameResolvers(this.pluginsService.filterPlugins(DiscoveryPlugin.class)));
            List<ClusterPlugin> clusterPlugins = this.pluginsService.filterPlugins(ClusterPlugin.class);
            ClusterService clusterService = new ClusterService(this.settings, settingsModule.getClusterSettings(), threadPool);
            resourcesToClose.add(clusterService);
            LazilyInitializedRerouteService lazilyInitializedRerouteService = new LazilyInitializedRerouteService();
            DiskThresholdMonitor diskThresholdMonitor = new DiskThresholdMonitor(this.settings, clusterService::state, clusterService.getClusterSettings(), this.client, threadPool::relativeTimeInMillis, lazilyInitializedRerouteService);
            ClusterInfoService clusterInfoService = this.newClusterInfoService(this.settings, clusterService, threadPool, this.client);
            clusterInfoService.addListener(diskThresholdMonitor::onNewInfo);
            ModulesBuilder modules = new ModulesBuilder();
            for (Module pluginModule : this.pluginsService.createGuiceModules()) {
                modules.add(pluginModule);
            }
            modules.add(new SessionSettingModule());
            modules.add(new AggregationImplModule());
            modules.add(new ScalarFunctionModule());
            modules.add(new TableFunctionModule());
            modules.add(new WindowFunctionModule());
            MonitorService monitorService = new MonitorService(this.settings, this.nodeEnvironment, threadPool, clusterInfoService);
            ClusterModule clusterModule = new ClusterModule(this.settings, clusterService, clusterPlugins, clusterInfoService);
            modules.add(clusterModule);
            IndicesModule indicesModule = new IndicesModule(this.pluginsService.filterPlugins(MapperPlugin.class));
            modules.add(indicesModule);
            BooleanQuery.setMaxClauseCount((int)SearchModule.INDICES_MAX_CLAUSE_COUNT_SETTING.get(this.settings));
            HierarchyCircuitBreakerService circuitBreakerService = new HierarchyCircuitBreakerService(this.settings, settingsModule.getClusterSettings());
            resourcesToClose.add(circuitBreakerService);
            modules.add(new GatewayModule());
            PageCacheRecycler pageCacheRecycler = this.createPageCacheRecycler(this.settings);
            BigArrays bigArrays = this.createBigArrays(pageCacheRecycler, circuitBreakerService);
            resourcesToClose.add(pageCacheRecycler);
            modules.add(settingsModule);
            List<NamedWriteableRegistry.Entry> namedWriteables = Stream.of(NetworkModule.getNamedWriteables().stream(), IndicesModule.getNamedWriteables().stream(), this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getNamedWriteables().stream()), ClusterModule.getNamedWriteables().stream()).flatMap(Function.identity()).collect(Collectors.toList());
            NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(namedWriteables);
            NamedXContentRegistry xContentRegistry = new NamedXContentRegistry(Stream.of(NetworkModule.getNamedXContents().stream(), IndicesModule.getNamedXContents().stream(), this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getNamedXContent().stream()), ClusterModule.getNamedXWriteables().stream()).flatMap(Function.identity()).collect(Collectors.toList()));
            MetaStateService metaStateService = new MetaStateService(this.nodeEnvironment, xContentRegistry);
            List<EnginePlugin> enginePlugins = this.pluginsService.filterPlugins(EnginePlugin.class);
            Collection engineFactoryProviders = Stream.concat(indicesModule.getEngineFactories().stream(), enginePlugins.stream().map(plugin -> plugin::getEngineFactory)).collect(Collectors.toList());
            Map<String, IndexStorePlugin.DirectoryFactory> indexStoreFactories = this.pluginsService.filterPlugins(IndexStorePlugin.class).stream().map(IndexStorePlugin::getDirectoryFactories).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            IndicesService indicesService = new IndicesService(this.settings, this.pluginsService, this.nodeEnvironment, xContentRegistry, analysisModule.getAnalysisRegistry(), indicesModule.getMapperRegistry(), namedWriteableRegistry, threadPool, settingsModule.getIndexScopedSettings(), circuitBreakerService, bigArrays, this.client, metaStateService, engineFactoryProviders, indexStoreFactories);
            AliasValidator aliasValidator = new AliasValidator();
            ShardLimitValidator shardLimitValidator = new ShardLimitValidator(this.settings, clusterService);
            MetadataCreateIndexService metadataCreateIndexService = new MetadataCreateIndexService(this.settings, clusterService, indicesService, clusterModule.getAllocationService(), aliasValidator, shardLimitValidator, environment, settingsModule.getIndexScopedSettings(), threadPool, xContentRegistry, forbidPrivateIndexSettings);
            Collection pluginComponents = this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.createComponents(this.client, clusterService, threadPool, xContentRegistry, environment, this.nodeEnvironment, namedWriteableRegistry).stream()).collect(Collectors.toList());
            ActionModule actionModule = new ActionModule(this.settings, settingsModule.getClusterSettings(), this.pluginsService.filterPlugins(ActionPlugin.class));
            modules.add(actionModule);
            EventLoopGroups eventLoopGroups = new EventLoopGroups();
            NetworkModule networkModule = new NetworkModule(this.settings, this.pluginsService.filterPlugins(NetworkPlugin.class), threadPool, bigArrays, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, xContentRegistry, networkService, eventLoopGroups, this.client);
            Collection customMetadataUpgraders = this.pluginsService.filterPlugins(Plugin.class).stream().map(Plugin::getCustomMetadataUpgrader).collect(Collectors.toList());
            Collection indexTemplateMetadataUpgraders = this.pluginsService.filterPlugins(Plugin.class).stream().map(Plugin::getIndexTemplateMetadataUpgrader).collect(Collectors.toList());
            Collection indexMetadataUpgraders = this.pluginsService.filterPlugins(Plugin.class).stream().map(Plugin::getIndexMetadataUpgrader).collect(Collectors.toList());
            MetadataUpgrader metadataUpgrader = new MetadataUpgrader(customMetadataUpgraders, indexTemplateMetadataUpgraders);
            MetadataIndexUpgradeService metadataIndexUpgradeService = new MetadataIndexUpgradeService(this.settings, xContentRegistry, indicesModule.getMapperRegistry(), settingsModule.getIndexScopedSettings(), indexMetadataUpgraders);
            new TemplateUpgradeService(this.client, clusterService, threadPool, indexTemplateMetadataUpgraders);
            Transport transport = networkModule.getTransportSupplier().get();
            TransportService transportService = this.newTransportService(this.settings, transport, threadPool, this.localNodeFactory, settingsModule.getClusterSettings());
            GatewayMetaState gatewayMetaState = new GatewayMetaState();
            HttpServerTransport httpServerTransport = this.newHttpTransport(networkModule);
            modules.add(new RepositoriesModule(this.environment, this.pluginsService.filterPlugins(RepositoryPlugin.class), xContentRegistry, threadPool));
            BatchedRerouteService rerouteService = new BatchedRerouteService(clusterService, clusterModule.getAllocationService()::reroute);
            lazilyInitializedRerouteService.setRerouteService(rerouteService);
            DiscoveryModule discoveryModule = new DiscoveryModule(this.settings, threadPool, transportService, namedWriteableRegistry, networkService, clusterService.getMasterService(), clusterService.getClusterApplierService(), clusterService.getClusterSettings(), this.pluginsService.filterPlugins(DiscoveryPlugin.class), clusterModule.getAllocationService(), environment.configFile(), gatewayMetaState, rerouteService);
            this.nodeService = new NodeService(monitorService, indicesService, transportService);
            modules.add(b -> {
                b.bind(Node.class).toInstance(this);
                b.bind(NodeService.class).toInstance(this.nodeService);
                b.bind(NamedXContentRegistry.class).toInstance(xContentRegistry);
                b.bind(PluginsService.class).toInstance(this.pluginsService);
                b.bind(Client.class).toInstance(this.client);
                b.bind(NodeClient.class).toInstance(this.client);
                b.bind(Environment.class).toInstance(this.environment);
                b.bind(ThreadPool.class).toInstance(threadPool);
                b.bind(NodeEnvironment.class).toInstance(this.nodeEnvironment);
                b.bind(CircuitBreakerService.class).toInstance(circuitBreakerService);
                b.bind(BigArrays.class).toInstance(bigArrays);
                b.bind(PageCacheRecycler.class).toInstance(pageCacheRecycler);
                b.bind(AnalysisRegistry.class).toInstance(analysisModule.getAnalysisRegistry());
                b.bind(NamedWriteableRegistry.class).toInstance(namedWriteableRegistry);
                b.bind(MetadataUpgrader.class).toInstance(metadataUpgrader);
                b.bind(MetaStateService.class).toInstance(metaStateService);
                b.bind(IndicesService.class).toInstance(indicesService);
                b.bind(AliasValidator.class).toInstance(aliasValidator);
                b.bind(MetadataCreateIndexService.class).toInstance(metadataCreateIndexService);
                b.bind(Transport.class).toInstance(transport);
                b.bind(TransportService.class).toInstance(transportService);
                b.bind(NetworkService.class).toInstance(networkService);
                b.bind(MetadataIndexUpgradeService.class).toInstance(metadataIndexUpgradeService);
                b.bind(ClusterInfoService.class).toInstance(clusterInfoService);
                b.bind(GatewayMetaState.class).toInstance(gatewayMetaState);
                b.bind(Discovery.class).toInstance(discoveryModule.getDiscovery());
                RecoverySettings recoverySettings = new RecoverySettings(this.settings, settingsModule.getClusterSettings());
                this.processRecoverySettings(settingsModule.getClusterSettings(), recoverySettings);
                b.bind(PeerRecoverySourceService.class).toInstance(new PeerRecoverySourceService(transportService, indicesService, recoverySettings));
                b.bind(PeerRecoveryTargetService.class).toInstance(new PeerRecoveryTargetService(threadPool, transportService, recoverySettings, clusterService));
                b.bind(HttpServerTransport.class).toInstance(httpServerTransport);
                b.bind(ShardLimitValidator.class).toInstance(shardLimitValidator);
                b.bind(EventLoopGroups.class).toInstance(eventLoopGroups);
                b.bind(RerouteService.class).toInstance(rerouteService);
                pluginComponents.stream().forEach(p -> b.bind(p.getClass()).toInstance(p));
            });
            this.injector = modules.createInjector();
            clusterModule.getAllocationService().setGatewayAllocator(this.injector.getInstance(GatewayAllocator.class));
            List pluginLifecycleComponents = pluginComponents.stream().filter(p -> p instanceof LifecycleComponent).map(p -> (LifecycleComponent)p).collect(Collectors.toList());
            pluginLifecycleComponents.addAll(this.pluginsService.getGuiceServiceClasses().stream().map(this.injector::getInstance).collect(Collectors.toList()));
            resourcesToClose.addAll(pluginLifecycleComponents);
            resourcesToClose.add(this.injector.getInstance(PeerRecoverySourceService.class));
            this.pluginLifecycleComponents = Collections.unmodifiableList(pluginLifecycleComponents);
            this.client.initialize(this.injector.getInstance(new Key<Map<ActionType, TransportAction>>(){}));
            this.logger.info("initialized");
            success = true;
        }
        catch (IOException ex) {
            throw new ElasticsearchException("failed to bind service", (Throwable)ex, new Object[0]);
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException(resourcesToClose);
            }
        }
    }

    private void logVersion(Logger logger, JvmInfo jvmInfo) {
        logger.info("version[{}], pid[{}], build[{}/{}], OS[{}/{}/{}], JVM[{}/{}/{}/{}]", new Object[]{Version.displayVersion(Version.CURRENT, Version.CURRENT.isSnapshot()), jvmInfo.pid(), Build.CURRENT.hashShort(), Build.CURRENT.timestamp(), Constants.OS_NAME, Constants.OS_VERSION, Constants.OS_ARCH, Constants.JVM_VENDOR, Constants.JVM_NAME, Constants.JAVA_VERSION, Constants.JVM_VERSION});
        Node.warnIfPreRelease(Version.CURRENT, Version.CURRENT.isSnapshot(), logger);
    }

    private static void warnIfPreRelease(Version version, boolean isSnapshot, Logger logger) {
        if (!version.isRelease() || isSnapshot) {
            logger.warn("version [{}] is a pre-release version of CrateDB and is not suitable for production", (Object)Version.displayVersion(version, isSnapshot));
        }
    }

    protected TransportService newTransportService(Settings settings, Transport transport, ThreadPool threadPool, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, ClusterSettings clusterSettings) {
        return new TransportService(settings, transport, threadPool, localNodeFactory, clusterSettings);
    }

    protected void processRecoverySettings(ClusterSettings clusterSettings, RecoverySettings recoverySettings) {
    }

    public Settings settings() {
        return this.settings;
    }

    public Client client() {
        return this.client;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public NodeEnvironment getNodeEnvironment() {
        return this.nodeEnvironment;
    }

    public Node start() throws NodeValidationException {
        if (!this.lifecycle.moveToStarted()) {
            return this;
        }
        this.logger.info("starting ...");
        this.pluginLifecycleComponents.forEach(LifecycleComponent::start);
        this.injector.getInstance(MappingUpdatedAction.class).setClient(this.client);
        this.injector.getInstance(IndicesService.class).start();
        this.injector.getInstance(IndicesClusterStateService.class).start();
        this.injector.getInstance(SnapshotsService.class).start();
        this.injector.getInstance(SnapshotShardsService.class).start();
        this.nodeService.getMonitorService().start();
        ClusterService clusterService = this.injector.getInstance(ClusterService.class);
        NodeConnectionsService nodeConnectionsService = this.injector.getInstance(NodeConnectionsService.class);
        nodeConnectionsService.start();
        clusterService.setNodeConnectionsService(nodeConnectionsService);
        this.injector.getInstance(GatewayService.class).start();
        Discovery discovery = this.injector.getInstance(Discovery.class);
        clusterService.getMasterService().setClusterStatePublisher(discovery::publish);
        HttpServerTransport httpServerTransport = this.injector.getInstance(HttpServerTransport.class);
        httpServerTransport.start();
        TransportAddress publishAddress = httpServerTransport.info().address().publishAddress();
        this.localNodeFactory.httpPublishAddress = publishAddress.getAddress() + ":" + publishAddress.getPort();
        TransportService transportService = this.injector.getInstance(TransportService.class);
        transportService.start();
        assert (this.localNodeFactory.getNode() != null);
        assert (transportService.getLocalNode().equals(this.localNodeFactory.getNode())) : "transportService has a different local node than the factory provided";
        this.injector.getInstance(PeerRecoverySourceService.class).start();
        GatewayMetaState gatewayMetaState = this.injector.getInstance(GatewayMetaState.class);
        gatewayMetaState.start(this.settings(), transportService, clusterService, this.injector.getInstance(MetaStateService.class), this.injector.getInstance(MetadataIndexUpgradeService.class), this.injector.getInstance(MetadataUpgrader.class));
        Metadata onDiskMetadata = gatewayMetaState.getPersistedState().getLastAcceptedState().metadata();
        assert (onDiskMetadata != null) : "metadata is null but shouldn't";
        this.validateNodeBeforeAcceptingRequests(transportService.boundAddress(), this.pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getBootstrapChecks().stream()).collect(Collectors.toList()));
        clusterService.addStateApplier(transportService.getTaskManager());
        discovery.start();
        clusterService.start();
        assert (clusterService.localNode().equals(this.localNodeFactory.getNode())) : "clusterService has a different local node than the factory provided";
        transportService.acceptIncomingRequests();
        discovery.startInitialJoin();
        final TimeValue initialStateTimeout = INITIAL_STATE_TIMEOUT_SETTING.get(this.settings);
        this.configureNodeAndClusterIdStateListener(clusterService);
        if (initialStateTimeout.millis() > 0L) {
            ThreadPool thread = this.injector.getInstance(ThreadPool.class);
            ClusterState clusterState = clusterService.state();
            ClusterStateObserver observer = new ClusterStateObserver(clusterState, clusterService, null, this.logger);
            if (clusterState.nodes().getMasterNodeId() == null) {
                this.logger.debug("waiting to join the cluster. timeout [{}]", (Object)initialStateTimeout);
                final CountDownLatch latch = new CountDownLatch(1);
                observer.waitForNextChange(new ClusterStateObserver.Listener(){

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        latch.countDown();
                    }

                    @Override
                    public void onClusterServiceClose() {
                        latch.countDown();
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        Node.this.logger.warn("timed out while waiting for initial discovery state - timeout: {}", (Object)initialStateTimeout);
                        latch.countDown();
                    }
                }, state -> state.nodes().getMasterNodeId() != null, initialStateTimeout);
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new ElasticsearchTimeoutException("Interrupted while waiting for initial discovery state", new Object[0]);
                }
            }
        }
        if (WRITE_PORTS_FILE_SETTING.get(this.settings).booleanValue()) {
            TransportService transport = this.injector.getInstance(TransportService.class);
            this.writePortsFile("transport", transport.boundAddress());
            HttpServerTransport http = this.injector.getInstance(HttpServerTransport.class);
            this.writePortsFile("http", http.boundAddress());
        }
        this.logger.info("started");
        this.pluginsService.filterPlugins(ClusterPlugin.class).forEach(ClusterPlugin::onNodeStarted);
        return this;
    }

    protected void configureNodeAndClusterIdStateListener(ClusterService clusterService) {
        NodeAndClusterIdStateListener.getAndSetNodeIdAndClusterId(clusterService);
    }

    private Node stop() {
        if (!this.lifecycle.moveToStopped()) {
            return this;
        }
        this.logger.info("stopping ...");
        this.injector.getInstance(HttpServerTransport.class).stop();
        this.injector.getInstance(SnapshotsService.class).stop();
        this.injector.getInstance(SnapshotShardsService.class).stop();
        this.injector.getInstance(IndicesClusterStateService.class).stop();
        this.injector.getInstance(Discovery.class).stop();
        this.injector.getInstance(ClusterService.class).stop();
        this.injector.getInstance(NodeConnectionsService.class).stop();
        this.nodeService.getMonitorService().stop();
        this.injector.getInstance(GatewayService.class).stop();
        this.injector.getInstance(TransportService.class).stop();
        this.pluginLifecycleComponents.forEach(LifecycleComponent::stop);
        this.injector.getInstance(IndicesService.class).stop();
        this.logger.info("stopped");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        Lifecycle lifecycle = this.lifecycle;
        synchronized (lifecycle) {
            if (this.lifecycle.started()) {
                this.stop();
            }
            if (!this.lifecycle.moveToClosed()) {
                return;
            }
        }
        this.logger.info("closing ...");
        ArrayList<Closeable> toClose = new ArrayList<Closeable>();
        StopWatch stopWatch = new StopWatch("node_close");
        toClose.add(() -> stopWatch.start("node_service"));
        toClose.add(this.nodeService);
        toClose.add(() -> stopWatch.stop().start("http"));
        toClose.add(this.injector.getInstance(HttpServerTransport.class));
        toClose.add(() -> stopWatch.stop().start("snapshot_service"));
        toClose.add(this.injector.getInstance(SnapshotsService.class));
        toClose.add(this.injector.getInstance(SnapshotShardsService.class));
        toClose.add(() -> stopWatch.stop().start("client"));
        Releasables.close(this.injector.getInstance(Client.class));
        toClose.add(() -> stopWatch.stop().start("indices_cluster"));
        toClose.add(this.injector.getInstance(IndicesClusterStateService.class));
        toClose.add(() -> stopWatch.stop().start("indices"));
        toClose.add(this.injector.getInstance(IndicesService.class));
        toClose.add(this.injector.getInstance(IndicesStore.class));
        toClose.add(this.injector.getInstance(PeerRecoverySourceService.class));
        toClose.add(() -> stopWatch.stop().start("routing"));
        toClose.add(() -> stopWatch.stop().start("cluster"));
        toClose.add(this.injector.getInstance(ClusterService.class));
        toClose.add(() -> stopWatch.stop().start("node_connections_service"));
        toClose.add(this.injector.getInstance(NodeConnectionsService.class));
        toClose.add(() -> stopWatch.stop().start("discovery"));
        toClose.add(this.injector.getInstance(Discovery.class));
        toClose.add(() -> stopWatch.stop().start("monitor"));
        toClose.add(this.nodeService.getMonitorService());
        toClose.add(() -> stopWatch.stop().start("gateway"));
        toClose.add(this.injector.getInstance(GatewayService.class));
        toClose.add(() -> stopWatch.stop().start("transport"));
        toClose.add(this.injector.getInstance(TransportService.class));
        for (LifecycleComponent plugin : this.pluginLifecycleComponents) {
            toClose.add(() -> stopWatch.stop().start("plugin(" + plugin.getClass().getName() + ")"));
            toClose.add(plugin);
        }
        toClose.addAll(this.pluginsService.filterPlugins(Plugin.class));
        toClose.add(() -> stopWatch.stop().start("thread_pool"));
        toClose.add(() -> this.injector.getInstance(ThreadPool.class).shutdown());
        toClose.add(() -> stopWatch.stop());
        toClose.add(this.injector.getInstance(NodeEnvironment.class));
        toClose.add(this.injector.getInstance(PageCacheRecycler.class));
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Close times for each service:\n{}", (Object)stopWatch.prettyPrint());
        }
        IOUtils.close(toClose);
        this.logger.info("closed");
    }

    public synchronized boolean awaitClose(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (!this.lifecycle.closed()) {
            throw new IllegalStateException("Call close() first");
        }
        ThreadPool threadPool = this.injector.getInstance(ThreadPool.class);
        boolean terminated = ThreadPool.terminate(threadPool, timeout, timeUnit);
        if (terminated && !this.nodeService.awaitClose(0L, TimeUnit.MILLISECONDS)) {
            throw new IllegalStateException("Some shards are still open after the threadpool terminated. Something is leaking index readers or store references.");
        }
        return terminated;
    }

    public boolean isClosed() {
        return this.lifecycle.closed();
    }

    public Injector injector() {
        return this.injector;
    }

    protected void validateNodeBeforeAcceptingRequests(BoundTransportAddress boundTransportAddress, List<BootstrapCheck> bootstrapChecks) throws NodeValidationException {
    }

    private void writePortsFile(String type, BoundTransportAddress boundAddress) {
        Path tmpPortsFile = this.environment.logsFile().resolve(type + ".ports.tmp");
        try (BufferedWriter writer = Files.newBufferedWriter(tmpPortsFile, Charset.forName("UTF-8"), new OpenOption[0]);){
            for (TransportAddress address : boundAddress.boundAddresses()) {
                InetAddress inetAddress = InetAddress.getByName(address.getAddress());
                writer.write(NetworkAddress.format(new InetSocketAddress(inetAddress, address.getPort())) + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write ports file", e);
        }
        Path portsFile = this.environment.logsFile().resolve(type + ".ports");
        try {
            Files.move(tmpPortsFile, portsFile, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to rename ports file", e);
        }
    }

    protected PluginsService getPluginsService() {
        return this.pluginsService;
    }

    BigArrays createBigArrays(PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService) {
        return new BigArrays(pageCacheRecycler, circuitBreakerService, "request");
    }

    PageCacheRecycler createPageCacheRecycler(Settings settings) {
        return new PageCacheRecycler(settings);
    }

    private List<NetworkService.CustomNameResolver> getCustomNameResolvers(List<DiscoveryPlugin> discoveryPlugins) {
        ArrayList<NetworkService.CustomNameResolver> customNameResolvers = new ArrayList<NetworkService.CustomNameResolver>();
        for (DiscoveryPlugin discoveryPlugin : discoveryPlugins) {
            NetworkService.CustomNameResolver customNameResolver = discoveryPlugin.getCustomNameResolver(this.settings);
            if (customNameResolver == null) continue;
            customNameResolvers.add(customNameResolver);
        }
        return customNameResolvers;
    }

    protected ClusterInfoService newClusterInfoService(Settings settings, ClusterService clusterService, ThreadPool threadPool, NodeClient client) {
        return new InternalClusterInfoService(settings, clusterService, threadPool, client);
    }

    protected HttpServerTransport newHttpTransport(NetworkModule networkModule) {
        return networkModule.getHttpServerTransportSupplier().get();
    }

    private static class LocalNodeFactory
    implements Function<BoundTransportAddress, DiscoveryNode> {
        private final SetOnce<DiscoveryNode> localNode = new SetOnce();
        private final String persistentNodeId;
        private final Settings settings;
        @Nullable
        String httpPublishAddress;

        private LocalNodeFactory(Settings settings, String persistentNodeId) {
            this.persistentNodeId = persistentNodeId;
            this.settings = settings;
        }

        @Override
        public DiscoveryNode apply(BoundTransportAddress boundTransportAddress) {
            HashMap<String, String> attributes = new HashMap<String, String>(NODE_ATTRIBUTES.getAsMap(this.settings));
            Set<DiscoveryNode.Role> roles = DiscoveryNode.getRolesFromSettings(this.settings);
            if (this.httpPublishAddress != null) {
                attributes.put("http_address", this.httpPublishAddress);
            }
            this.localNode.set((Object)new DiscoveryNode(NODE_NAME_SETTING.get(this.settings), this.persistentNodeId, boundTransportAddress.publishAddress(), attributes, roles, Version.CURRENT));
            return (DiscoveryNode)this.localNode.get();
        }

        DiscoveryNode getNode() {
            assert (this.localNode.get() != null);
            return (DiscoveryNode)this.localNode.get();
        }
    }
}

