/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.env.Environment;
import org.elasticsearch.node.Node;

public class InternalSettingsPreparer {
    public static Settings prepareSettings(Settings input) {
        Settings.Builder output = Settings.builder();
        InternalSettingsPreparer.initializeSettings(output, input, Collections.emptyMap());
        InternalSettingsPreparer.finalizeSettings(output, () -> null);
        return output.build();
    }

    public static Environment prepareEnvironment(Settings input, Map<String, String> properties, Path configPath, Supplier<String> defaultNodeName) {
        Settings.Builder output = Settings.builder();
        InternalSettingsPreparer.initializeSettings(output, input, properties);
        Environment environment = new Environment(output.build(), configPath);
        output = Settings.builder();
        Path path = environment.configFile().resolve("crate.yml");
        if (Files.exists(path, new LinkOption[0])) {
            try {
                output.loadFromPath(path);
            }
            catch (IOException e) {
                throw new SettingsException("Failed to load settings from " + path.toString(), e);
            }
        }
        InternalSettingsPreparer.initializeSettings(output, input, properties);
        InternalSettingsPreparer.finalizeSettings(output, defaultNodeName);
        environment = new Environment(output.build(), configPath);
        output.put(Environment.PATH_LOGS_SETTING.getKey(), environment.logsFile().toAbsolutePath().normalize().toString());
        return new Environment(output.build(), configPath);
    }

    static void initializeSettings(Settings.Builder output, Settings input, Map<String, String> esSettings) {
        output.put(input);
        output.putProperties(esSettings, Function.identity());
        output.replacePropertyPlaceholders();
    }

    private static void finalizeSettings(Settings.Builder output, Supplier<String> defaultNodeName) {
        ArrayList<String> forcedSettings = new ArrayList<String>();
        for (String setting : output.keys()) {
            if (!setting.startsWith("force.")) continue;
            forcedSettings.add(setting);
        }
        for (String forcedSetting : forcedSettings) {
            String value = output.remove(forcedSetting);
            output.put(forcedSetting.substring("force.".length()), value);
        }
        output.replacePropertyPlaceholders();
        if (output.get(ClusterName.CLUSTER_NAME_SETTING.getKey()) == null) {
            output.put(ClusterName.CLUSTER_NAME_SETTING.getKey(), ClusterName.CLUSTER_NAME_SETTING.getDefault(Settings.EMPTY).value());
        }
        if (output.get(Node.NODE_NAME_SETTING.getKey()) == null) {
            output.put(Node.NODE_NAME_SETTING.getKey(), defaultNodeName.get());
        }
    }
}

