/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.os;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;

public class OsStats
implements Writeable {
    private final long timestamp;
    private final Cpu cpu;
    private final Mem mem;
    private final Swap swap;
    private final Cgroup cgroup;

    public OsStats(long timestamp, Cpu cpu, Mem mem, Swap swap, Cgroup cgroup) {
        this.timestamp = timestamp;
        this.cpu = Objects.requireNonNull(cpu);
        this.mem = Objects.requireNonNull(mem);
        this.swap = Objects.requireNonNull(swap);
        this.cgroup = cgroup;
    }

    public OsStats(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.cpu = new Cpu(in);
        this.mem = new Mem(in);
        this.swap = new Swap(in);
        this.cgroup = in.readOptionalWriteable(Cgroup::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        this.cpu.writeTo(out);
        this.mem.writeTo(out);
        this.swap.writeTo(out);
        out.writeOptionalWriteable(this.cgroup);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Cpu getCpu() {
        return this.cpu;
    }

    public Mem getMem() {
        return this.mem;
    }

    public Swap getSwap() {
        return this.swap;
    }

    public Cgroup getCgroup() {
        return this.cgroup;
    }

    public static short calculatePercentage(long used, long max) {
        return max <= 0L ? (short)0 : (short)Math.round(100.0 * (double)used / (double)max);
    }

    public static class Cpu
    implements Writeable {
        private final short percent;
        private final double[] loadAverage;

        public Cpu(short systemCpuPercent, double[] systemLoadAverage) {
            this.percent = systemCpuPercent;
            this.loadAverage = systemLoadAverage;
        }

        public Cpu(StreamInput in) throws IOException {
            this.percent = in.readShort();
            this.loadAverage = (double[])(in.readBoolean() ? in.readDoubleArray() : null);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeShort(this.percent);
            if (this.loadAverage == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeDoubleArray(this.loadAverage);
            }
        }

        public short getPercent() {
            return this.percent;
        }

        public double[] getLoadAverage() {
            return this.loadAverage;
        }
    }

    public static class Mem
    implements Writeable {
        private final long total;
        private final long free;

        public Mem(long total, long free) {
            this.total = total;
            this.free = free;
        }

        public Mem(StreamInput in) throws IOException {
            this.total = in.readLong();
            this.free = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.total);
            out.writeLong(this.free);
        }

        public ByteSizeValue getTotal() {
            return new ByteSizeValue(this.total);
        }

        public ByteSizeValue getUsed() {
            return new ByteSizeValue(this.total - this.free);
        }

        public short getUsedPercent() {
            return OsStats.calculatePercentage(this.getUsed().getBytes(), this.total);
        }

        public ByteSizeValue getFree() {
            return new ByteSizeValue(this.free);
        }

        public short getFreePercent() {
            return OsStats.calculatePercentage(this.free, this.total);
        }
    }

    public static class Swap
    implements Writeable {
        private final long total;
        private final long free;

        public Swap(long total, long free) {
            this.total = total;
            this.free = free;
        }

        public Swap(StreamInput in) throws IOException {
            this.total = in.readLong();
            this.free = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.total);
            out.writeLong(this.free);
        }

        public ByteSizeValue getFree() {
            return new ByteSizeValue(this.free);
        }

        public ByteSizeValue getUsed() {
            return new ByteSizeValue(this.total - this.free);
        }

        public ByteSizeValue getTotal() {
            return new ByteSizeValue(this.total);
        }
    }

    public static class Cgroup
    implements Writeable {
        private final String cpuAcctControlGroup;
        private final long cpuAcctUsageNanos;
        private final String cpuControlGroup;
        private final long cpuCfsPeriodMicros;
        private final long cpuCfsQuotaMicros;
        private final CpuStat cpuStat;
        private final String memoryControlGroup;
        private final String memoryLimitInBytes;
        private final String memoryUsageInBytes;

        public String getCpuAcctControlGroup() {
            return this.cpuAcctControlGroup;
        }

        public long getCpuAcctUsageNanos() {
            return this.cpuAcctUsageNanos;
        }

        public String getCpuControlGroup() {
            return this.cpuControlGroup;
        }

        public long getCpuCfsPeriodMicros() {
            return this.cpuCfsPeriodMicros;
        }

        public long getCpuCfsQuotaMicros() {
            return this.cpuCfsQuotaMicros;
        }

        public CpuStat getCpuStat() {
            return this.cpuStat;
        }

        public String getMemoryControlGroup() {
            return this.memoryControlGroup;
        }

        public String getMemoryLimitInBytes() {
            return this.memoryLimitInBytes;
        }

        public String getMemoryUsageInBytes() {
            return this.memoryUsageInBytes;
        }

        public Cgroup(String cpuAcctControlGroup, long cpuAcctUsageNanos, String cpuControlGroup, long cpuCfsPeriodMicros, long cpuCfsQuotaMicros, CpuStat cpuStat, String memoryControlGroup, String memoryLimitInBytes, String memoryUsageInBytes) {
            this.cpuAcctControlGroup = Objects.requireNonNull(cpuAcctControlGroup);
            this.cpuAcctUsageNanos = cpuAcctUsageNanos;
            this.cpuControlGroup = Objects.requireNonNull(cpuControlGroup);
            this.cpuCfsPeriodMicros = cpuCfsPeriodMicros;
            this.cpuCfsQuotaMicros = cpuCfsQuotaMicros;
            this.cpuStat = Objects.requireNonNull(cpuStat);
            this.memoryControlGroup = memoryControlGroup;
            this.memoryLimitInBytes = memoryLimitInBytes;
            this.memoryUsageInBytes = memoryUsageInBytes;
        }

        Cgroup(StreamInput in) throws IOException {
            this.cpuAcctControlGroup = in.readString();
            this.cpuAcctUsageNanos = in.readLong();
            this.cpuControlGroup = in.readString();
            this.cpuCfsPeriodMicros = in.readLong();
            this.cpuCfsQuotaMicros = in.readLong();
            this.cpuStat = new CpuStat(in);
            this.memoryControlGroup = in.readOptionalString();
            this.memoryLimitInBytes = in.readOptionalString();
            this.memoryUsageInBytes = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.cpuAcctControlGroup);
            out.writeLong(this.cpuAcctUsageNanos);
            out.writeString(this.cpuControlGroup);
            out.writeLong(this.cpuCfsPeriodMicros);
            out.writeLong(this.cpuCfsQuotaMicros);
            this.cpuStat.writeTo(out);
            out.writeOptionalString(this.memoryControlGroup);
            out.writeOptionalString(this.memoryLimitInBytes);
            out.writeOptionalString(this.memoryUsageInBytes);
        }

        public static class CpuStat
        implements Writeable {
            private final long numberOfElapsedPeriods;
            private final long numberOfTimesThrottled;
            private final long timeThrottledNanos;

            public long getNumberOfElapsedPeriods() {
                return this.numberOfElapsedPeriods;
            }

            public long getNumberOfTimesThrottled() {
                return this.numberOfTimesThrottled;
            }

            public long getTimeThrottledNanos() {
                return this.timeThrottledNanos;
            }

            public CpuStat(long numberOfElapsedPeriods, long numberOfTimesThrottled, long timeThrottledNanos) {
                this.numberOfElapsedPeriods = numberOfElapsedPeriods;
                this.numberOfTimesThrottled = numberOfTimesThrottled;
                this.timeThrottledNanos = timeThrottledNanos;
            }

            CpuStat(StreamInput in) throws IOException {
                this.numberOfElapsedPeriods = in.readLong();
                this.numberOfTimesThrottled = in.readLong();
                this.timeThrottledNanos = in.readLong();
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeLong(this.numberOfElapsedPeriods);
                out.writeLong(this.numberOfTimesThrottled);
                out.writeLong(this.timeThrottledNanos);
            }
        }
    }
}

