/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.jvm;

import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.monitor.jvm.GcNames;

public class JvmStats
implements Writeable {
    private static final RuntimeMXBean RUNTIME_MXBEAN = ManagementFactory.getRuntimeMXBean();
    private static final MemoryMXBean MEMORY_MXBEAN = ManagementFactory.getMemoryMXBean();
    private static final ThreadMXBean THREAD_MXBEAN = ManagementFactory.getThreadMXBean();
    private static final ClassLoadingMXBean CLASS_LOADING_MXBEAN = ManagementFactory.getClassLoadingMXBean();
    private final long timestamp;
    private final long uptime;
    private final Mem mem;
    private final Threads threads;
    private final GarbageCollectors gc;
    private final List<BufferPool> bufferPools;
    private final Classes classes;

    public static JvmStats jvmStats() {
        MemoryUsage memUsage = MEMORY_MXBEAN.getHeapMemoryUsage();
        long heapUsed = memUsage.getUsed() < 0L ? 0L : memUsage.getUsed();
        long heapCommitted = memUsage.getCommitted() < 0L ? 0L : memUsage.getCommitted();
        long heapMax = memUsage.getMax() < 0L ? 0L : memUsage.getMax();
        memUsage = MEMORY_MXBEAN.getNonHeapMemoryUsage();
        long nonHeapUsed = memUsage.getUsed() < 0L ? 0L : memUsage.getUsed();
        long nonHeapCommitted = memUsage.getCommitted() < 0L ? 0L : memUsage.getCommitted();
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        ArrayList<MemoryPool> pools = new ArrayList<MemoryPool>();
        for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            try {
                MemoryUsage usage = memoryPoolMXBean.getUsage();
                MemoryUsage peakUsage = memoryPoolMXBean.getPeakUsage();
                String name = GcNames.getByMemoryPoolName(memoryPoolMXBean.getName(), null);
                if (name == null) continue;
                pools.add(new MemoryPool(name, usage.getUsed() < 0L ? 0L : usage.getUsed(), usage.getMax() < 0L ? 0L : usage.getMax(), peakUsage.getUsed() < 0L ? 0L : peakUsage.getUsed(), peakUsage.getMax() < 0L ? 0L : peakUsage.getMax()));
            }
            catch (Exception usage) {}
        }
        Mem mem = new Mem(heapCommitted, heapUsed, heapMax, nonHeapCommitted, nonHeapUsed, Collections.unmodifiableList(pools));
        Threads threads = new Threads(THREAD_MXBEAN.getThreadCount(), THREAD_MXBEAN.getPeakThreadCount());
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        GarbageCollector[] collectors = new GarbageCollector[gcMxBeans.size()];
        for (int i = 0; i < collectors.length; ++i) {
            GarbageCollectorMXBean gcMxBean = gcMxBeans.get(i);
            collectors[i] = new GarbageCollector(GcNames.getByGcName(gcMxBean.getName(), gcMxBean.getName()), gcMxBean.getCollectionCount(), gcMxBean.getCollectionTime());
        }
        GarbageCollectors garbageCollectors = new GarbageCollectors(collectors);
        List<BufferPool> bufferPoolsList = Collections.emptyList();
        try {
            List<BufferPoolMXBean> bufferPools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
            bufferPoolsList = new ArrayList(bufferPools.size());
            for (BufferPoolMXBean bufferPool : bufferPools) {
                bufferPoolsList.add(new BufferPool(bufferPool.getName(), bufferPool.getCount(), bufferPool.getTotalCapacity(), bufferPool.getMemoryUsed()));
            }
        }
        catch (Exception bufferPools) {
            // empty catch block
        }
        Classes classes = new Classes(CLASS_LOADING_MXBEAN.getLoadedClassCount(), CLASS_LOADING_MXBEAN.getTotalLoadedClassCount(), CLASS_LOADING_MXBEAN.getUnloadedClassCount());
        return new JvmStats(System.currentTimeMillis(), RUNTIME_MXBEAN.getUptime(), mem, threads, garbageCollectors, bufferPoolsList, classes);
    }

    public JvmStats(long timestamp, long uptime, Mem mem, Threads threads, GarbageCollectors gc, List<BufferPool> bufferPools, Classes classes) {
        this.timestamp = timestamp;
        this.uptime = uptime;
        this.mem = mem;
        this.threads = threads;
        this.gc = gc;
        this.bufferPools = bufferPools;
        this.classes = classes;
    }

    public JvmStats(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.uptime = in.readVLong();
        this.mem = new Mem(in);
        this.threads = new Threads(in);
        this.gc = new GarbageCollectors(in);
        this.bufferPools = in.readList(BufferPool::new);
        this.classes = new Classes(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        out.writeVLong(this.uptime);
        this.mem.writeTo(out);
        this.threads.writeTo(out);
        this.gc.writeTo(out);
        out.writeList(this.bufferPools);
        this.classes.writeTo(out);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public TimeValue getUptime() {
        return new TimeValue(this.uptime);
    }

    public Mem getMem() {
        return this.mem;
    }

    public Threads getThreads() {
        return this.threads;
    }

    public GarbageCollectors getGc() {
        return this.gc;
    }

    public List<BufferPool> getBufferPools() {
        return this.bufferPools;
    }

    public Classes getClasses() {
        return this.classes;
    }

    public static class MemoryPool
    implements Writeable {
        private final String name;
        private final long used;
        private final long max;
        private final long peakUsed;
        private final long peakMax;

        public MemoryPool(String name, long used, long max, long peakUsed, long peakMax) {
            this.name = name;
            this.used = used;
            this.max = max;
            this.peakUsed = peakUsed;
            this.peakMax = peakMax;
        }

        public MemoryPool(StreamInput in) throws IOException {
            this.name = in.readString();
            this.used = in.readVLong();
            this.max = in.readVLong();
            this.peakUsed = in.readVLong();
            this.peakMax = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeVLong(this.used);
            out.writeVLong(this.max);
            out.writeVLong(this.peakUsed);
            out.writeVLong(this.peakMax);
        }

        public String getName() {
            return this.name;
        }

        public ByteSizeValue getUsed() {
            return new ByteSizeValue(this.used);
        }

        public ByteSizeValue getMax() {
            return new ByteSizeValue(this.max);
        }

        public ByteSizeValue getPeakUsed() {
            return new ByteSizeValue(this.peakUsed);
        }

        public ByteSizeValue getPeakMax() {
            return new ByteSizeValue(this.peakMax);
        }
    }

    public static class Mem
    implements Writeable,
    Iterable<MemoryPool> {
        private final long heapCommitted;
        private final long heapUsed;
        private final long heapMax;
        private final long nonHeapCommitted;
        private final long nonHeapUsed;
        private final List<MemoryPool> pools;

        public Mem(long heapCommitted, long heapUsed, long heapMax, long nonHeapCommitted, long nonHeapUsed, List<MemoryPool> pools) {
            this.heapCommitted = heapCommitted;
            this.heapUsed = heapUsed;
            this.heapMax = heapMax;
            this.nonHeapCommitted = nonHeapCommitted;
            this.nonHeapUsed = nonHeapUsed;
            this.pools = pools;
        }

        public Mem(StreamInput in) throws IOException {
            this.heapCommitted = in.readVLong();
            this.heapUsed = in.readVLong();
            this.nonHeapCommitted = in.readVLong();
            this.nonHeapUsed = in.readVLong();
            this.heapMax = in.readVLong();
            this.pools = in.readList(MemoryPool::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.heapCommitted);
            out.writeVLong(this.heapUsed);
            out.writeVLong(this.nonHeapCommitted);
            out.writeVLong(this.nonHeapUsed);
            out.writeVLong(this.heapMax);
            out.writeList(this.pools);
        }

        @Override
        public Iterator<MemoryPool> iterator() {
            return this.pools.iterator();
        }

        public ByteSizeValue getHeapCommitted() {
            return new ByteSizeValue(this.heapCommitted);
        }

        public ByteSizeValue getHeapUsed() {
            return new ByteSizeValue(this.heapUsed);
        }

        public ByteSizeValue getHeapMax() {
            return new ByteSizeValue(this.heapMax);
        }

        public short getHeapUsedPercent() {
            if (this.heapMax == 0L) {
                return -1;
            }
            return (short)(this.heapUsed * 100L / this.heapMax);
        }

        public ByteSizeValue getNonHeapCommitted() {
            return new ByteSizeValue(this.nonHeapCommitted);
        }

        public ByteSizeValue getNonHeapUsed() {
            return new ByteSizeValue(this.nonHeapUsed);
        }
    }

    public static class Threads
    implements Writeable {
        private final int count;
        private final int peakCount;

        public Threads(int count, int peakCount) {
            this.count = count;
            this.peakCount = peakCount;
        }

        public Threads(StreamInput in) throws IOException {
            this.count = in.readVInt();
            this.peakCount = in.readVInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.count);
            out.writeVInt(this.peakCount);
        }

        public int getCount() {
            return this.count;
        }

        public int getPeakCount() {
            return this.peakCount;
        }
    }

    public static class GarbageCollector
    implements Writeable {
        private final String name;
        private final long collectionCount;
        private final long collectionTime;

        public GarbageCollector(String name, long collectionCount, long collectionTime) {
            this.name = name;
            this.collectionCount = collectionCount;
            this.collectionTime = collectionTime;
        }

        public GarbageCollector(StreamInput in) throws IOException {
            this.name = in.readString();
            this.collectionCount = in.readVLong();
            this.collectionTime = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeVLong(this.collectionCount);
            out.writeVLong(this.collectionTime);
        }

        public String getName() {
            return this.name;
        }

        public long getCollectionCount() {
            return this.collectionCount;
        }

        public TimeValue getCollectionTime() {
            return new TimeValue(this.collectionTime, TimeUnit.MILLISECONDS);
        }
    }

    public static class GarbageCollectors
    implements Writeable,
    Iterable<GarbageCollector> {
        private final GarbageCollector[] collectors;

        public GarbageCollectors(GarbageCollector[] collectors) {
            this.collectors = collectors;
        }

        public GarbageCollectors(StreamInput in) throws IOException {
            this.collectors = in.readArray(GarbageCollector::new, GarbageCollector[]::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeArray(this.collectors);
        }

        public GarbageCollector[] getCollectors() {
            return this.collectors;
        }

        @Override
        public Iterator<GarbageCollector> iterator() {
            return Arrays.stream(this.collectors).iterator();
        }
    }

    public static class BufferPool
    implements Writeable {
        private final String name;
        private final long count;
        private final long totalCapacity;
        private final long used;

        public BufferPool(String name, long count, long totalCapacity, long used) {
            this.name = name;
            this.count = count;
            this.totalCapacity = totalCapacity;
            this.used = used;
        }

        public BufferPool(StreamInput in) throws IOException {
            this.name = in.readString();
            this.count = in.readLong();
            this.totalCapacity = in.readLong();
            this.used = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeLong(this.count);
            out.writeLong(this.totalCapacity);
            out.writeLong(this.used);
        }

        public String getName() {
            return this.name;
        }

        public long getCount() {
            return this.count;
        }

        public ByteSizeValue getTotalCapacity() {
            return new ByteSizeValue(this.totalCapacity);
        }

        public ByteSizeValue getUsed() {
            return new ByteSizeValue(this.used);
        }
    }

    public static class Classes
    implements Writeable {
        private final long loadedClassCount;
        private final long totalLoadedClassCount;
        private final long unloadedClassCount;

        public Classes(long loadedClassCount, long totalLoadedClassCount, long unloadedClassCount) {
            this.loadedClassCount = loadedClassCount;
            this.totalLoadedClassCount = totalLoadedClassCount;
            this.unloadedClassCount = unloadedClassCount;
        }

        public Classes(StreamInput in) throws IOException {
            this.loadedClassCount = in.readLong();
            this.totalLoadedClassCount = in.readLong();
            this.unloadedClassCount = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.loadedClassCount);
            out.writeLong(this.totalLoadedClassCount);
            out.writeLong(this.unloadedClassCount);
        }

        public long getLoadedClassCount() {
            return this.loadedClassCount;
        }

        public long getTotalLoadedClassCount() {
            return this.totalLoadedClassCount;
        }

        public long getUnloadedClassCount() {
            return this.unloadedClassCount;
        }
    }
}

