/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.jvm;

import io.crate.common.unit.TimeValue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.jvm.JvmStats;

public class JvmService {
    private static final Logger LOGGER = LogManager.getLogger(JvmService.class);
    private final JvmInfo jvmInfo = JvmInfo.jvmInfo();
    private final TimeValue refreshInterval;
    private JvmStats jvmStats = JvmStats.jvmStats();
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.jvm.refresh_interval", TimeValue.timeValueSeconds(1L), TimeValue.timeValueSeconds(1L), Setting.Property.NodeScope);

    public JvmService(Settings settings) {
        this.refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        LOGGER.debug("using refresh_interval [{}]", (Object)this.refreshInterval);
    }

    public JvmInfo info() {
        return this.jvmInfo;
    }

    public synchronized JvmStats stats() {
        if (System.currentTimeMillis() - this.jvmStats.getTimestamp() > this.refreshInterval.millis()) {
            this.jvmStats = JvmStats.jvmStats();
        }
        return this.jvmStats;
    }
}

