/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.jvm;

import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.monitor.jvm.JvmPid;

public class JvmInfo
implements Writeable {
    private static JvmInfo INSTANCE;
    private final long pid;
    private final String version;
    private final String vmName;
    private final String vmVersion;
    private final String vmVendor;
    private final long startTime;
    private final long configuredInitialHeapSize;
    private final long configuredMaxHeapSize;
    private final Mem mem;
    private final String[] inputArguments;
    private final String bootClassPath;
    private final String classPath;
    private final Map<String, String> systemProperties;
    private final String[] gcCollectors;
    private final String[] memoryPools;
    private final String onError;
    private final String onOutOfMemoryError;
    private final String useCompressedOops;
    private final String useG1GC;
    private final String useSerialGC;

    public static JvmInfo jvmInfo() {
        return INSTANCE;
    }

    private JvmInfo(long pid, String version, String vmName, String vmVersion, String vmVendor, long startTime, long configuredInitialHeapSize, long configuredMaxHeapSize, Mem mem, String[] inputArguments, String bootClassPath, String classPath, Map<String, String> systemProperties, String[] gcCollectors, String[] memoryPools, String onError, String onOutOfMemoryError, String useCompressedOops, String useG1GC, String useSerialGC) {
        this.pid = pid;
        this.version = version;
        this.vmName = vmName;
        this.vmVersion = vmVersion;
        this.vmVendor = vmVendor;
        this.startTime = startTime;
        this.configuredInitialHeapSize = configuredInitialHeapSize;
        this.configuredMaxHeapSize = configuredMaxHeapSize;
        this.mem = mem;
        this.inputArguments = inputArguments;
        this.bootClassPath = bootClassPath;
        this.classPath = classPath;
        this.systemProperties = systemProperties;
        this.gcCollectors = gcCollectors;
        this.memoryPools = memoryPools;
        this.onError = onError;
        this.onOutOfMemoryError = onOutOfMemoryError;
        this.useCompressedOops = useCompressedOops;
        this.useG1GC = useG1GC;
        this.useSerialGC = useSerialGC;
    }

    public JvmInfo(StreamInput in) throws IOException {
        this.pid = in.readLong();
        this.version = in.readString();
        this.vmName = in.readString();
        this.vmVersion = in.readString();
        this.vmVendor = in.readString();
        this.startTime = in.readLong();
        this.inputArguments = new String[in.readInt()];
        for (int i = 0; i < this.inputArguments.length; ++i) {
            this.inputArguments[i] = in.readString();
        }
        this.bootClassPath = in.readString();
        this.classPath = in.readString();
        this.systemProperties = in.readMap(StreamInput::readString, StreamInput::readString);
        this.mem = new Mem(in);
        this.gcCollectors = in.readStringArray();
        this.memoryPools = in.readStringArray();
        this.useCompressedOops = in.readString();
        this.configuredMaxHeapSize = -1L;
        this.configuredInitialHeapSize = -1L;
        this.onError = null;
        this.onOutOfMemoryError = null;
        this.useG1GC = "unknown";
        this.useSerialGC = "unknown";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.pid);
        out.writeString(this.version);
        out.writeString(this.vmName);
        out.writeString(this.vmVersion);
        out.writeString(this.vmVendor);
        out.writeLong(this.startTime);
        out.writeInt(this.inputArguments.length);
        for (String inputArgument : this.inputArguments) {
            out.writeString(inputArgument);
        }
        out.writeString(this.bootClassPath);
        out.writeString(this.classPath);
        out.writeVInt(this.systemProperties.size());
        for (Map.Entry entry : this.systemProperties.entrySet()) {
            out.writeString((String)entry.getKey());
            out.writeString((String)entry.getValue());
        }
        this.mem.writeTo(out);
        out.writeStringArray(this.gcCollectors);
        out.writeStringArray(this.memoryPools);
        out.writeString(this.useCompressedOops);
    }

    public long pid() {
        return this.pid;
    }

    public String version() {
        return this.version;
    }

    public String getVmName() {
        return this.vmName;
    }

    public Mem getMem() {
        return this.mem;
    }

    public String[] getInputArguments() {
        return this.inputArguments;
    }

    public long getConfiguredInitialHeapSize() {
        return this.configuredInitialHeapSize;
    }

    public long getConfiguredMaxHeapSize() {
        return this.configuredMaxHeapSize;
    }

    public String onError() {
        return this.onError;
    }

    public String onOutOfMemoryError() {
        return this.onOutOfMemoryError;
    }

    public String useCompressedOops() {
        return this.useCompressedOops;
    }

    public String useG1GC() {
        return this.useG1GC;
    }

    public String useSerialGC() {
        return this.useSerialGC;
    }

    static {
        String bootClassPath;
        Mem mem;
        String[] inputArguments;
        RuntimeMXBean runtimeMXBean;
        block20: {
            runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            long heapInit = memoryMXBean.getHeapMemoryUsage().getInit() < 0L ? 0L : memoryMXBean.getHeapMemoryUsage().getInit();
            long heapMax = memoryMXBean.getHeapMemoryUsage().getMax() < 0L ? 0L : memoryMXBean.getHeapMemoryUsage().getMax();
            inputArguments = runtimeMXBean.getInputArguments().toArray(new String[runtimeMXBean.getInputArguments().size()]);
            mem = new Mem(heapInit, heapMax);
            try {
                bootClassPath = runtimeMXBean.getBootClassPath();
            }
            catch (UnsupportedOperationException e) {
                bootClassPath = System.getProperty("sun.boot.class.path");
                if (bootClassPath != null) break block20;
                bootClassPath = "<unknown>";
            }
        }
        String classPath = runtimeMXBean.getClassPath();
        Map<String, String> systemProperties = Collections.unmodifiableMap(runtimeMXBean.getSystemProperties());
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        String[] gcCollectors = new String[gcMxBeans.size()];
        for (int i = 0; i < gcMxBeans.size(); ++i) {
            GarbageCollectorMXBean gcMxBean = gcMxBeans.get(i);
            gcCollectors[i] = gcMxBean.getName();
        }
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        String[] memoryPools = new String[memoryPoolMXBeans.size()];
        for (int i = 0; i < memoryPoolMXBeans.size(); ++i) {
            MemoryPoolMXBean memoryPoolMXBean = memoryPoolMXBeans.get(i);
            memoryPools[i] = memoryPoolMXBean.getName();
        }
        String onError = null;
        String onOutOfMemoryError = null;
        String useCompressedOops = "unknown";
        String useG1GC = "unknown";
        String useSerialGC = "unknown";
        long configuredInitialHeapSize = -1L;
        long configuredMaxHeapSize = -1L;
        try {
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            Class<?> vmOptionClazz = Class.forName("com.sun.management.VMOption");
            Object hotSpotDiagnosticMXBean = ManagementFactory.getPlatformMXBean(clazz);
            Method vmOptionMethod = clazz.getMethod("getVMOption", String.class);
            Method valueMethod = vmOptionClazz.getMethod("getValue", new Class[0]);
            try {
                Object onErrorObject = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "OnError");
                onError = (String)valueMethod.invoke(onErrorObject, new Object[0]);
            }
            catch (Exception onErrorObject) {
                // empty catch block
            }
            try {
                Object onOutOfMemoryErrorObject = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "OnOutOfMemoryError");
                onOutOfMemoryError = (String)valueMethod.invoke(onOutOfMemoryErrorObject, new Object[0]);
            }
            catch (Exception onOutOfMemoryErrorObject) {
                // empty catch block
            }
            try {
                Object useCompressedOopsVmOptionObject = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "UseCompressedOops");
                useCompressedOops = (String)valueMethod.invoke(useCompressedOopsVmOptionObject, new Object[0]);
            }
            catch (Exception useCompressedOopsVmOptionObject) {
                // empty catch block
            }
            try {
                Object useG1GCVmOptionObject = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "UseG1GC");
                useG1GC = (String)valueMethod.invoke(useG1GCVmOptionObject, new Object[0]);
            }
            catch (Exception useG1GCVmOptionObject) {
                // empty catch block
            }
            try {
                Object initialHeapSizeVmOptionObject = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "InitialHeapSize");
                configuredInitialHeapSize = Long.parseLong((String)valueMethod.invoke(initialHeapSizeVmOptionObject, new Object[0]));
            }
            catch (Exception initialHeapSizeVmOptionObject) {
                // empty catch block
            }
            try {
                Object maxHeapSizeVmOptionObject = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "MaxHeapSize");
                configuredMaxHeapSize = Long.parseLong((String)valueMethod.invoke(maxHeapSizeVmOptionObject, new Object[0]));
            }
            catch (Exception maxHeapSizeVmOptionObject) {
                // empty catch block
            }
            try {
                Object useSerialGCVmOptionObject = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "UseSerialGC");
                useSerialGC = (String)valueMethod.invoke(useSerialGCVmOptionObject, new Object[0]);
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        INSTANCE = new JvmInfo(JvmPid.getPid(), System.getProperty("java.version"), runtimeMXBean.getVmName(), runtimeMXBean.getVmVersion(), runtimeMXBean.getVmVendor(), runtimeMXBean.getStartTime(), configuredInitialHeapSize, configuredMaxHeapSize, mem, inputArguments, bootClassPath, classPath, systemProperties, gcCollectors, memoryPools, onError, onOutOfMemoryError, useCompressedOops, useG1GC, useSerialGC);
    }

    public static class Mem
    implements Writeable {
        private final long heapInit;
        private final long heapMax;

        Mem(long heapInit, long heapMax) {
            this.heapInit = heapInit;
            this.heapMax = heapMax;
        }

        Mem(StreamInput in) throws IOException {
            this.heapInit = in.readVLong();
            this.heapMax = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.heapInit);
            out.writeVLong(this.heapMax);
        }

        public ByteSizeValue getHeapInit() {
            return new ByteSizeValue(this.heapInit);
        }

        public ByteSizeValue getHeapMax() {
            return new ByteSizeValue(this.heapMax);
        }
    }
}

